/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import io.polaris.core.function.FunctionWithArgs3;
import io.polaris.core.map.reference.ReferenceType;
import io.polaris.core.map.reference.ValueReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class ReferenceMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final BiFunction<K, ReferenceQueue<K>, Reference<K>> keyRreferenceFactory;
    private final FunctionWithArgs3<Reference<K>, V, ReferenceQueue<V>, ValueReference<Reference<K>, V>> valueReferenceFactory;
    private final Map<Reference<K>, ValueReference<Reference<K>, V>> raw;
    private final ReferenceQueue<K> keyQueue = new ReferenceQueue();
    private final ReferenceQueue<V> valueQueue = new ReferenceQueue();

    public ReferenceMap(Map<Reference<K>, ValueReference<Reference<K>, V>> raw, ReferenceType referenceType) {
        this.raw = raw;
        this.valueReferenceFactory = referenceType::buildValueReference;
        this.keyRreferenceFactory = referenceType::buildKeyReference;
    }

    public ReferenceMap(Supplier<Map<Reference<K>, ValueReference<Reference<K>, V>>> supplier, ReferenceType referenceType) {
        this(supplier.get(), referenceType);
    }

    private Reference<K> buildKeyReference(K key) {
        return this.keyRreferenceFactory.apply(key, this.keyQueue);
    }

    private ValueReference<Reference<K>, V> buildValueReference(Reference<K> key, V value) {
        return this.valueReferenceFactory.apply(key, value, this.valueQueue);
    }

    private void processQueue() {
        Reference<Object> ref;
        while ((ref = this.keyQueue.poll()) != null) {
            this.raw.remove(ref);
        }
        while ((ref = this.valueQueue.poll()) != null) {
            if (!(ref instanceof ValueReference)) continue;
            ValueReference vr = (ValueReference)((Object)ref);
            Reference keyRef = (Reference)vr.key();
            this.raw.remove(keyRef, vr);
        }
    }

    @Override
    public int size() {
        this.processQueue();
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.raw.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.raw.containsKey(this.buildKeyReference(key));
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        ValueReference<Reference<K>, V> ref = this.raw.get(this.buildKeyReference(key));
        if (ref != null) {
            return ref.value();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        ValueReference<Reference<K>, V> ref = this.raw.put(keyRef, this.buildValueReference(keyRef, value));
        if (ref != null) {
            return ref.value();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        ValueReference<Reference<K>, V> removed = this.raw.remove(this.buildKeyReference(key));
        if (removed == null) {
            return null;
        }
        return removed.value();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.raw.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.raw.isEmpty()) {
            return Collections.emptyMap().entrySet();
        }
        this.processQueue();
        if (this.raw.isEmpty()) {
            return Collections.emptyMap().entrySet();
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<Reference<K>, ValueReference<Reference<K>, V>> entry : this.raw.entrySet()) {
            K key;
            V value;
            ValueReference<Reference<K>, V> valueReference = entry.getValue();
            if (valueReference == null || (value = valueReference.value()) == null || (key = entry.getKey().get()) == null) continue;
            map.put(key, value);
        }
        return map.entrySet();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.processQueue();
        this.raw.replaceAll((k, v) -> this.buildValueReference((Reference<K>)k, (V)function.apply((K)k.get(), (V)v.value())));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        ValueReference<Reference<K>, V> ref = this.raw.putIfAbsent(keyRef, this.buildValueReference(keyRef, value));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.processQueue();
        Reference<Object> keyRef = this.buildKeyReference(key);
        return this.raw.remove(keyRef, this.buildValueReference(keyRef, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        return this.raw.replace(keyRef, this.buildValueReference(keyRef, oldValue), this.buildValueReference(keyRef, newValue));
    }

    @Override
    public V replace(K key, V value) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        ValueReference<Reference<K>, V> ref = this.raw.replace(keyRef, this.buildValueReference(keyRef, value));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        ValueReference ref = this.raw.computeIfAbsent(keyRef, k -> this.buildValueReference((Reference<K>)k, (V)mappingFunction.apply((K)k.get())));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        ValueReference ref = this.raw.computeIfPresent(keyRef, (k, v) -> this.buildValueReference((Reference<K>)k, v == null ? null : (V)remappingFunction.apply((K)k.get(), (V)v.value())));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        ValueReference ref = this.raw.compute(keyRef, (k, v) -> this.buildValueReference((Reference<K>)k, (V)remappingFunction.apply((K)k.get(), (V)(v == null ? null : (Object)v.value()))));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        ValueReference ref = this.raw.merge(keyRef, this.buildValueReference(keyRef, value), (v1, v2) -> this.buildValueReference(keyRef, remappingFunction.apply((V)v1.value(), (V)v2.value())));
        return ref == null ? null : (V)ref.value();
    }
}

