/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import io.polaris.core.function.FunctionWithArgs3;
import io.polaris.core.map.reference.ReferenceType;
import io.polaris.core.map.reference.ValueReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class ValueReferenceMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final FunctionWithArgs3<K, V, ReferenceQueue<V>, ValueReference<K, V>> referenceFactory;
    private final Map<K, ValueReference<K, V>> raw;
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public ValueReferenceMap(Map<K, ValueReference<K, V>> raw, FunctionWithArgs3<K, V, ReferenceQueue<V>, ValueReference<K, V>> referenceFactory) {
        this.raw = raw;
        this.referenceFactory = referenceFactory;
    }

    public ValueReferenceMap(Map<K, ValueReference<K, V>> raw, ReferenceType referenceType) {
        this.raw = raw;
        this.referenceFactory = referenceType::buildValueReference;
    }

    public ValueReferenceMap(Supplier<Map<K, ValueReference<K, V>>> supplier, ReferenceType referenceType) {
        this(supplier.get(), referenceType);
    }

    private ValueReference<K, V> buildValueReference(K key, V value) {
        return this.referenceFactory.apply(key, value, this.queue);
    }

    private void processQueue() {
        Reference<V> ref;
        while ((ref = this.queue.poll()) != null) {
            if (!(ref instanceof ValueReference)) continue;
            ValueReference vr = (ValueReference)((Object)ref);
            this.raw.remove(vr.key(), vr);
        }
    }

    @Override
    public int size() {
        this.processQueue();
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.raw.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.raw.containsKey(key);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        ValueReference<K, V> ref = this.raw.get(key);
        if (ref != null) {
            return ref.value();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        ValueReference<K, V> ref = this.raw.put(key, this.buildValueReference(key, value));
        if (ref != null) {
            return ref.value();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        ValueReference<K, V> removed = this.raw.remove(key);
        if (removed == null) {
            return null;
        }
        return removed.value();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.raw.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.raw.isEmpty()) {
            return Collections.emptyMap().entrySet();
        }
        this.processQueue();
        if (this.raw.isEmpty()) {
            return Collections.emptyMap().entrySet();
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, ValueReference<K, V>> entry : this.raw.entrySet()) {
            V value = entry.getValue().value();
            if (value == null) continue;
            map.put(entry.getKey(), value);
        }
        return map.entrySet();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.processQueue();
        this.raw.replaceAll((k, v) -> this.buildValueReference(k, function.apply((K)k, (V)v.value())));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.processQueue();
        ValueReference<K, V> ref = this.raw.putIfAbsent(key, this.buildValueReference(key, value));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.processQueue();
        return this.raw.remove(key, this.buildValueReference(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.processQueue();
        return this.raw.replace(key, this.buildValueReference(key, oldValue), this.buildValueReference(key, newValue));
    }

    @Override
    public V replace(K key, V value) {
        this.processQueue();
        ValueReference<K, V> ref = this.raw.replace(key, this.buildValueReference(key, value));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.processQueue();
        ValueReference ref = this.raw.computeIfAbsent(key, k -> this.buildValueReference(k, mappingFunction.apply((K)k)));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.processQueue();
        ValueReference ref = this.raw.computeIfPresent(key, (k, v) -> this.buildValueReference(k, v == null ? null : (V)remappingFunction.apply((K)k, (V)v.value())));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.processQueue();
        ValueReference ref = this.raw.compute(key, (k, v) -> this.buildValueReference(k, remappingFunction.apply((K)k, (V)(v == null ? null : (Object)v.value()))));
        return ref == null ? null : (V)ref.value();
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.processQueue();
        ValueReference ref = this.raw.merge(key, this.buildValueReference(key, value), (v1, v2) -> this.buildValueReference(key, remappingFunction.apply((V)v1.value(), (V)v2.value())));
        return ref == null ? null : (V)ref.value();
    }
}

