/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.msg;

import io.polaris.core.collection.Iterables;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringJoiner;

public class AggregateResourceBundles {
    public static final ResourceBundle.Control CONTROL = new AggregateControl();

    public static String aggregateNames(String ... baseNames) {
        StringJoiner joiner = new StringJoiner(",");
        for (String baseName : baseNames) {
            joiner.add(baseName);
        }
        String baseName = joiner.toString();
        return baseName;
    }

    public static ResourceBundle getBundle(String baseName) {
        return ResourceBundle.getBundle(baseName, CONTROL);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale) {
        return ResourceBundle.getBundle(baseName, locale, CONTROL);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        return ResourceBundle.getBundle(baseName, locale, loader, CONTROL);
    }

    public static ResourceBundle getBundle(String ... baseNames) {
        String baseName = AggregateResourceBundles.aggregateNames(baseNames);
        return ResourceBundle.getBundle(baseName, CONTROL);
    }

    public static ResourceBundle getBundle(Locale locale, String ... baseNames) {
        return ResourceBundle.getBundle(AggregateResourceBundles.aggregateNames(baseNames), locale, CONTROL);
    }

    public static ResourceBundle getBundle(Locale locale, ClassLoader loader, String ... baseNames) {
        return ResourceBundle.getBundle(AggregateResourceBundles.aggregateNames(baseNames), locale, loader, CONTROL);
    }

    static Properties loadProperties(ClassLoader loader, String ... resourceNames) throws IOException {
        Properties aggregatedProperties = new Properties();
        for (String resourceName : resourceNames) {
            Enumeration urls = AggregateResourceBundles.run(() -> {
                try {
                    return loader.getResources(resourceName);
                }
                catch (IOException e) {
                    return Collections.emptyEnumeration();
                }
            });
            while (urls.hasMoreElements()) {
                URL url = (URL)urls.nextElement();
                Properties properties = new Properties();
                properties.load(url.openStream());
                aggregatedProperties.putAll((Map<?, ?>)properties);
            }
        }
        return aggregatedProperties;
    }

    static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    public static class AggregateControl
    extends ResourceBundle.Control {
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (!"java.properties".equals(format)) {
                return super.newBundle(baseName, locale, format, loader, reload);
            }
            String[] names = baseName.split("[,|]+");
            String[] resourceNames = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                resourceNames[i] = this.toBundleName(names[i].trim(), locale).replace(".", "/") + ".properties";
            }
            Properties properties = AggregateResourceBundles.loadProperties(loader, resourceNames);
            return new AggregateResourceBundle(properties);
        }
    }

    public static class AggregateResourceBundle
    extends ResourceBundle {
        private final Properties properties;

        protected AggregateResourceBundle(Properties properties) {
            this.properties = properties;
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.properties.get(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Iterables.enumeration(this.properties.stringPropertyNames());
        }

        @Override
        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }

        public Properties getProperties() {
            return this.properties;
        }
    }
}

