/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.net;

import io.polaris.core.tuple.Pair;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public class URLEncoders {
    private static final char QP_SEP_A = '&';
    private static final char QP_SEP_S = ';';
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final char PATH_SEPARATOR = '/';
    private static final BitSet PATH_SEPARATORS;
    private static final BitSet UNRESERVED;
    private static final BitSet PUNCTUATION;
    private static final BitSet USERINFO;
    private static final BitSet PATH_SAFE;
    private static final BitSet URIC;
    private static final BitSet RESERVED;
    private static final BitSet URL_ENCODER;
    private static final BitSet PATH_SPECIAL;
    private static final int RADIX = 16;

    static List<Pair<String, String>> createEmptyList() {
        return new ArrayList<Pair<String, String>>(0);
    }

    static String urlEncode(String content, Charset charset, BitSet safeChars, boolean blankAsPlus) {
        if (content == null) {
            return null;
        }
        charset = charset != null ? charset : StandardCharsets.UTF_8;
        StringBuilder buf = new StringBuilder();
        ByteBuffer bb = charset.encode(content);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (safeChars.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (blankAsPlus && b == 32) {
                buf.append('+');
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf.toString();
    }

    static String urlDecode(String content, Charset charset, boolean plusAsBlank) {
        if (content == null) {
            return null;
        }
        charset = charset != null ? charset : StandardCharsets.UTF_8;
        ByteBuffer bb = ByteBuffer.allocate(content.length());
        CharBuffer cb = CharBuffer.wrap(content);
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (c == '%' && cb.remaining() >= 2) {
                char uc = cb.get();
                char lc = cb.get();
                int u = Character.digit(uc, 16);
                int l = Character.digit(lc, 16);
                if (u != -1 && l != -1) {
                    bb.put((byte)((u << 4) + l));
                    continue;
                }
                bb.put((byte)37);
                bb.put((byte)uc);
                bb.put((byte)lc);
                continue;
            }
            if (plusAsBlank && c == '+') {
                bb.put((byte)32);
                continue;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return charset.decode(bb).toString();
    }

    public static String decodeFormFields(String content) {
        return URLEncoders.decodeFormFields(content, StandardCharsets.UTF_8);
    }

    public static String decodeFormFields(String content, String charset) {
        return URLEncoders.decodeFormFields(content, charset != null ? Charset.forName(charset) : StandardCharsets.UTF_8);
    }

    public static String decodeFormFields(String content, Charset charset) {
        return URLEncoders.decodeFormFields(content, charset, true);
    }

    public static String decodeFormFields(String content, Charset charset, boolean blankAsPlus) {
        return URLEncoders.urlDecode(content, charset, blankAsPlus);
    }

    public static String encodeFormFields(String content) {
        return URLEncoders.encodeFormFields(content, StandardCharsets.UTF_8);
    }

    public static String encodeFormFields(String content, String charset) {
        return URLEncoders.encodeFormFields(content, charset != null ? Charset.forName(charset) : StandardCharsets.UTF_8);
    }

    public static String encodeFormFields(String content, Charset charset) {
        return URLEncoders.encodeFormFields(content, charset, false);
    }

    public static String encodeFormFields(String content, Charset charset, boolean blankAsPlus) {
        return URLEncoders.urlEncode(content, charset, URL_ENCODER, blankAsPlus);
    }

    public static String encodeUserInfo(String content) {
        return URLEncoders.urlEncode(content, StandardCharsets.UTF_8, USERINFO, false);
    }

    public static String encodeUserInfo(String content, Charset charset) {
        return URLEncoders.urlEncode(content, charset, USERINFO, false);
    }

    public static String encodeUric(String content) {
        return URLEncoders.urlEncode(content, StandardCharsets.UTF_8, URIC, false);
    }

    public static String encodeUric(String content, Charset charset) {
        return URLEncoders.urlEncode(content, charset, URIC, false);
    }

    public static String encodePath(String content) {
        return URLEncoders.urlEncode(content, StandardCharsets.UTF_8, PATH_SPECIAL, false);
    }

    public static String encodePath(String content, Charset charset) {
        return URLEncoders.urlEncode(content, charset, PATH_SPECIAL, false);
    }

    public static String format(Iterable<? extends Pair<String, String>> parameters) {
        return URLEncoders.format(parameters, StandardCharsets.UTF_8, '&');
    }

    public static String format(Iterable<? extends Pair<String, String>> parameters, Charset charset) {
        return URLEncoders.format(parameters, charset, '&');
    }

    public static String format(Iterable<? extends Pair<String, String>> parameters, char parameterSeparator) {
        return URLEncoders.format(parameters, StandardCharsets.UTF_8, parameterSeparator);
    }

    public static String format(Iterable<? extends Pair<String, String>> parameters, Charset charset, char parameterSeparator) {
        StringBuilder result = new StringBuilder();
        for (Pair<String, String> pair : parameters) {
            String encodedName = URLEncoders.encodeFormFields(pair.getKey(), charset);
            String encodedValue = URLEncoders.encodeFormFields(pair.getValue(), charset);
            if (result.length() > 0) {
                result.append(parameterSeparator);
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    public static String formatSegments(String ... segments) {
        return URLEncoders.formatSegments(Arrays.asList(segments), StandardCharsets.UTF_8);
    }

    public static String formatSegments(Iterable<String> segments) {
        return URLEncoders.formatSegments(segments, StandardCharsets.UTF_8);
    }

    public static String formatSegments(Iterable<String> segments, Charset charset) {
        StringBuilder result = new StringBuilder();
        for (String segment : segments) {
            result.append('/').append(URLEncoders.urlEncode(segment, charset, PATH_SAFE, false));
        }
        return result.toString();
    }

    public static List<Pair<String, String>> parseQuery(CharSequence s) {
        return URLEncoders.parseQuery(s, StandardCharsets.UTF_8);
    }

    public static List<Pair<String, String>> parseQuery(CharSequence s, char ... separators) {
        return URLEncoders.parseQuery(s, StandardCharsets.UTF_8, separators);
    }

    public static List<Pair<String, String>> parseQuery(CharSequence s, Charset charset) {
        return URLEncoders.parseQuery(s, charset, '&', ';');
    }

    public static List<Pair<String, String>> parseQuery(CharSequence s, Charset charset, char ... separators) {
        BitSet delimSet = new BitSet();
        for (char separator : separators) {
            delimSet.set(separator);
        }
        return URLEncoders.parseQuery(s, charset, delimSet);
    }

    private static List<Pair<String, String>> parseQuery(CharSequence s, Charset charset, BitSet separators) {
        int i;
        Charset charset2 = charset = charset != null ? charset : StandardCharsets.UTF_8;
        if (s == null || s.length() == 0) {
            return Collections.emptyList();
        }
        int start = 0;
        int end = s.length() - 1;
        for (i = start; i < end; ++i) {
            if (separators.get(s.charAt(i))) continue;
            start = i;
            break;
        }
        for (i = end; i >= start; --i) {
            if (separators.get(s.charAt(i))) continue;
            end = i;
            break;
        }
        if (start == end) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        StringBuilder buf = new StringBuilder();
        int equalsIndex = -1;
        for (int i2 = start; i2 <= end; ++i2) {
            char ch = s.charAt(i2);
            if (separators.get(ch)) {
                if (buf.length() <= 0) continue;
                if (equalsIndex < 0) {
                    list.add(Pair.of(URLEncoders.decodeFormFields(buf.toString(), charset), ""));
                } else {
                    list.add(Pair.of(URLEncoders.decodeFormFields(buf.substring(0, equalsIndex), charset), equalsIndex >= buf.length() - 1 ? "" : URLEncoders.decodeFormFields(buf.substring(equalsIndex + 1), charset)));
                }
                buf.setLength(0);
                equalsIndex = -1;
                continue;
            }
            if (equalsIndex < 0 && ch == '=') {
                equalsIndex = buf.length();
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            if (equalsIndex < 0) {
                list.add(Pair.of(URLEncoders.decodeFormFields(buf.toString(), charset), ""));
            } else {
                list.add(Pair.of(URLEncoders.decodeFormFields(buf.substring(0, equalsIndex), charset), equalsIndex >= buf.length() - 1 ? "" : URLEncoders.decodeFormFields(buf.substring(equalsIndex + 1), charset)));
            }
        }
        return list;
    }

    public static List<String> parsePathSegments(CharSequence s) {
        return URLEncoders.parsePathSegments(s, StandardCharsets.UTF_8, PATH_SEPARATORS);
    }

    public static List<String> parsePathSegments(CharSequence s, Charset charset) {
        return URLEncoders.parsePathSegments(s, charset, PATH_SEPARATORS);
    }

    private static List<String> parsePathSegments(CharSequence s, Charset charset, BitSet separators) {
        int i;
        Charset charset2 = charset = charset != null ? charset : StandardCharsets.UTF_8;
        if (s == null || s.length() == 0) {
            return Collections.emptyList();
        }
        int start = 0;
        int end = s.length() - 1;
        for (i = start; i < end; ++i) {
            if (separators.get(s.charAt(i))) continue;
            start = i;
            break;
        }
        for (i = end; i >= start; --i) {
            if (separators.get(s.charAt(i))) continue;
            end = i;
            break;
        }
        if (start == end) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (int i2 = start; i2 <= end; ++i2) {
            char ch = s.charAt(i2);
            if (separators.get(ch)) {
                if (buf.length() <= 0) continue;
                list.add(URLEncoders.urlDecode(buf.toString(), charset, false));
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            list.add(URLEncoders.urlDecode(buf.toString(), charset, false));
        }
        return list;
    }

    static {
        int i;
        PATH_SEPARATORS = new BitSet(256);
        UNRESERVED = new BitSet(256);
        PUNCTUATION = new BitSet(256);
        USERINFO = new BitSet(256);
        PATH_SAFE = new BitSet(256);
        URIC = new BitSet(256);
        RESERVED = new BitSet(256);
        URL_ENCODER = new BitSet(256);
        PATH_SPECIAL = new BitSet(256);
        PATH_SEPARATORS.set(47);
        for (i = 97; i <= 122; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            UNRESERVED.set(i);
        }
        UNRESERVED.set(95);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(42);
        URL_ENCODER.or(UNRESERVED);
        UNRESERVED.set(33);
        UNRESERVED.set(126);
        UNRESERVED.set(39);
        UNRESERVED.set(40);
        UNRESERVED.set(41);
        PUNCTUATION.set(44);
        PUNCTUATION.set(59);
        PUNCTUATION.set(58);
        PUNCTUATION.set(36);
        PUNCTUATION.set(38);
        PUNCTUATION.set(43);
        PUNCTUATION.set(61);
        USERINFO.or(UNRESERVED);
        USERINFO.or(PUNCTUATION);
        PATH_SAFE.or(UNRESERVED);
        PATH_SAFE.set(59);
        PATH_SAFE.set(58);
        PATH_SAFE.set(64);
        PATH_SAFE.set(38);
        PATH_SAFE.set(61);
        PATH_SAFE.set(43);
        PATH_SAFE.set(36);
        PATH_SAFE.set(44);
        PATH_SPECIAL.or(PATH_SAFE);
        PATH_SPECIAL.set(47);
        RESERVED.set(59);
        RESERVED.set(47);
        RESERVED.set(63);
        RESERVED.set(58);
        RESERVED.set(64);
        RESERVED.set(38);
        RESERVED.set(61);
        RESERVED.set(43);
        RESERVED.set(36);
        RESERVED.set(44);
        RESERVED.set(91);
        RESERVED.set(93);
        URIC.or(RESERVED);
        URIC.or(UNRESERVED);
    }
}

