/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.net.http;

import io.polaris.core.io.IO;
import io.polaris.core.net.http.ContentType;
import io.polaris.core.net.http.RequestSettings;
import io.polaris.core.net.http.Response;
import io.polaris.core.string.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class HttpClients {
    public static Response doFormPost(String url, String params) throws IOException, GeneralSecurityException {
        return HttpClients.doRequest(new RequestSettings().withUrl(url).withContentType(ContentType.FORM_URLENCODED).withRequestMethod("POST").withContent(params));
    }

    public static Response doPost(String url, String content) throws IOException, GeneralSecurityException {
        return HttpClients.doRequest(new RequestSettings().withUrl(url).withContent(content).withRequestMethod("POST"));
    }

    public static Response doHttpsPost(String url, String keyStorePath, String keyStorePassword, String content) throws IOException, GeneralSecurityException {
        return HttpClients.doRequest(new RequestSettings().withUrl(url).withRequestMethod("POST").withKeyStorePassword(keyStorePassword).withKeyStorePath(keyStorePath).withContent(content));
    }

    public static Response doRequest(RequestSettings settings) throws IOException, GeneralSecurityException {
        Object keyStorePath;
        String requestMethod = settings.getRequestMethod();
        String requestUrl = settings.getUrl();
        boolean https = requestUrl.startsWith("https://");
        String charset = settings.getCharset();
        ContentType contentType = settings.getContentType();
        URL url = new URL(requestUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (https) {
            SSLContext sslContext = settings.getSslContext();
            if (sslContext == null) {
                String keyStorePassword = settings.getKeyStorePassword();
                keyStorePath = settings.getKeyStorePath();
                sslContext = Strings.isNotBlank(keyStorePassword) && Strings.isNotBlank((CharSequence)keyStorePath) ? HttpClients.getSSLContext(keyStorePassword, (String)keyStorePath) : HttpClients.getNoopSSLContext();
            }
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslContext.getSocketFactory());
            ((HttpsURLConnection)conn).setHostnameVerifier(HttpClients.getNoopHostnameVerifier());
        }
        conn.setRequestMethod(requestMethod);
        if (settings.getConnectTimeout() > 0) {
            conn.setConnectTimeout(settings.getConnectTimeout());
        }
        if (settings.getReadTimeout() > 0) {
            conn.setReadTimeout(settings.getReadTimeout());
        }
        conn.setRequestProperty("accept", "*/*");
        conn.setRequestProperty("Connection", "Keep-Alive");
        if (settings.getHeaders() != null) {
            settings.getHeaders().forEach(conn::setRequestProperty);
        }
        conn.setRequestProperty("User-Agent", settings.getUserAgent());
        conn.setRequestProperty("Content-Type", contentType.toString(charset));
        conn.setUseCaches(true);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.connect();
        String content = settings.getContent();
        if (Strings.isNotBlank(content)) {
            OutputStream out = conn.getOutputStream();
            keyStorePath = null;
            try {
                out.write(content.getBytes(charset));
                out.flush();
            }
            catch (Throwable throwable) {
                keyStorePath = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (keyStorePath != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)keyStorePath).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        Response response = new Response();
        response.setResponseCode(conn.getResponseCode());
        response.setResponseMessage(conn.getResponseMessage());
        response.setResponseHeaders(conn.getHeaderFields());
        response.setContentLength(conn.getContentLengthLong());
        response.setContentType(conn.getContentType());
        try (InputStream in = conn.getInputStream();){
            if (settings.isReadBytes()) {
                response.setContentBytes(IO.toBytes(in));
            } else {
                response.setContent(IO.toString(in, charset));
            }
        }
        return response;
    }

    public static HostnameVerifier getNoopHostnameVerifier() {
        HostnameVerifier noop = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        return noop;
    }

    public static X509TrustManager getNoopX509TrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
    }

    public static SSLContext getNoopSSLContext() throws GeneralSecurityException {
        SSLContext ctx = SSLContext.getInstance("SSL");
        ctx.init(null, new TrustManager[]{HttpClients.getNoopX509TrustManager()}, new SecureRandom());
        return ctx;
    }

    public static SSLContext getSSLContext(String password, String keyStorePath) throws GeneralSecurityException, IOException {
        return HttpClients.getSSLContext(password, keyStorePath, keyStorePath);
    }

    public static SSLContext getSSLContext(String password, String keyStorePath, String trustStorePath) throws GeneralSecurityException, IOException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = HttpClients.getKeyStore(password, keyStorePath);
        keyManagerFactory.init(keyStore, password.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = HttpClients.getKeyStore(password, trustStorePath);
        trustManagerFactory.init(trustStore);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return ctx;
    }

    public static KeyStore getKeyStore(String password, String keyStorePath) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        InputStream is = IO.getInputStream(keyStorePath, HttpClients.class);
        ks.load(is, password.toCharArray());
        is.close();
        return ks;
    }

    public static void initHttpsDefaultConfig(String password, String keyStorePath, String trustStorePath) throws Exception {
        SSLContext sslContext = null;
        HostnameVerifier noop = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            sslContext = HttpClients.getSSLContext(password, keyStorePath, trustStorePath);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(noop);
    }
}

