/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.os;

import io.polaris.core.os.OS;
import io.polaris.core.os.OsType;
import io.polaris.core.os.TopResult;
import io.polaris.core.regex.Patterns;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TopExecutor {
    public static final String REGEXP_TOP_PID = "(\\d+)\\s+(\\w+)\\s+(\\d+)\\s+(\\d+)\\s+([\\d.kmg]+)\\s+([\\d.kmg]+)\\s+([\\d.kmg]+)\\s+([\\w]+)\\s+([\\d.kmg]+)\\s+([\\d.kmg]+)\\s+([\\d.kmg]+)";
    public static final String REGEXP_TOP_SWAP = "Swap:\\s*([\\dkmg]+)\\s*total,\\s*([\\dkmg]+)\\s*used,\\s*([\\dkmg]+)\\s*free,\\s*([\\dkmg]+)\\s*cached";
    public static final String REGEXP_TOP_MEM = "Mem:\\s*([\\dkmg]+)\\s*total,\\s*([\\dkmg]+)\\s*used,\\s*([\\dkmg]+)\\s*free,\\s*([\\dkmg]+)\\s*buffers";
    public static final String REGEXP_TOP_CPU = "Cpu\\(s\\):\\s*([\\d.]+)%us,\\s*([\\d.]+)%sy,\\s*([\\d.]+)%ni,\\s*([\\d.]+)%id,\\s*([\\d.]+)%wa,\\s*([\\d.]+)%hi,\\s*([\\d.]+)%si,\\s*([\\d.]+)%st";
    public static final String REGEXP_TOP_TASK = "Tasks:\\s*(\\d+) total,\\s*(\\d+) running,\\s*(\\d+) sleeping,\\s*(\\d+) stopped,\\s*(\\d+) zombie";
    private static volatile TopExecutor instance;
    private volatile boolean topThreadStarted = false;
    private volatile boolean topThreadRunning = true;
    private volatile Process topProcess;
    private volatile TopResult topResult;
    private volatile boolean collectTopSimple = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TopExecutor getInstance() {
        if (instance != null) return instance;
        Class<TopExecutor> clazz = TopExecutor.class;
        synchronized (TopExecutor.class) {
            if (instance != null) return instance;
            instance = new TopExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TopExecutor() {
        this.start();
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public TopExecutor simple(boolean simple) {
        this.collectTopSimple = simple;
        return this;
    }

    public TopResult getTopResult() {
        return this.topResult;
    }

    public boolean isStarted() {
        return this.topThreadStarted;
    }

    public TopExecutor stop() {
        if (!this.topThreadStarted) {
            return this;
        }
        try {
            this.topThreadRunning = false;
            if (this.topProcess != null) {
                this.topProcess.destroy();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public TopExecutor start() {
        if (this.topThreadStarted) {
            return this;
        }
        this.startTopThread();
        return this;
    }

    private void startTopThread() {
        if (OsType.WINDOWS == OS.getOsType()) {
            return;
        }
        Thread topThread = new Thread(() -> {
            String cmd = "top -b -d 5 -n 2 -H -p " + OS.getPid();
            String[] cmdArray = cmd.split(" +");
            while (this.topThreadRunning) {
                Process process = null;
                try {
                    process = this.topProcess = Runtime.getRuntime().exec(cmdArray);
                    InputStream stdin = process.getInputStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(stdin, StandardCharsets.UTF_8));
                    TopResult[] topResult = new TopResult[]{new TopResult()};
                    String line = br.readLine();
                    while (line != null) {
                        line = line.trim();
                        this.parseTopResult(topResult, line);
                        line = br.readLine();
                    }
                    process.waitFor();
                }
                catch (Throwable throwable) {}
                continue;
                finally {
                    if (process == null) continue;
                    try {
                        process.destroy();
                    }
                    catch (Exception exception) {}
                }
            }
            this.topThreadStarted = false;
        });
        topThread.setDaemon(true);
        topThread.setName("daemon-top-thread-p" + OS.getPid());
        this.topThreadStarted = true;
        topThread.start();
    }

    private double toByteDoubleVal(String byteStr) {
        if (byteStr.endsWith("b") || byteStr.endsWith("B")) {
            return this.toByteDoubleVal(byteStr.substring(0, byteStr.length() - 1));
        }
        if (byteStr.endsWith("k") || byteStr.endsWith("K")) {
            return 1024.0 * this.toByteDoubleVal(byteStr.substring(0, byteStr.length() - 1));
        }
        if (byteStr.endsWith("m") || byteStr.endsWith("M")) {
            return 1048576.0 * this.toByteDoubleVal(byteStr.substring(0, byteStr.length() - 1));
        }
        if (byteStr.endsWith("g") || byteStr.endsWith("G")) {
            return 1.073741824E9 * this.toByteDoubleVal(byteStr.substring(0, byteStr.length() - 1));
        }
        return Double.parseDouble(byteStr);
    }

    private long toByteVal(String byteStr) {
        return (long)this.toByteDoubleVal(byteStr);
    }

    private void parseTopResult(TopResult[] topResultRef, String line) {
        TopResult topResult = topResultRef[0];
        if (topResult == null) {
            topResult = topResultRef[0] = new TopResult();
        }
        try {
            if (line.startsWith("top - ")) {
                topResult = topResultRef[0] = new TopResult();
                if (this.collectTopSimple) {
                    topResult.setSimpleData(new TopResult.SimpleData());
                    topResult.setFullData(null);
                } else {
                    topResult.setSimpleData(null);
                    topResult.setFullData(new TopResult.FullData());
                }
                int i = line.indexOf("load average: ");
                String loadAverage = line.substring(i + "load average: ".length());
                String[] arr = loadAverage.split(",");
                String loadAverage1 = arr[0].trim();
                String loadAverage5 = arr[1].trim();
                String loadAverage15 = arr[2].trim();
                if (!topResult.isSimple()) {
                    topResult.getFullData().setLoadAverage1(Double.parseDouble(loadAverage1));
                    topResult.getFullData().setLoadAverage5(Double.parseDouble(loadAverage5));
                    topResult.getFullData().setLoadAverage15(Double.parseDouble(loadAverage15));
                }
            } else if (line.startsWith("Tasks:")) {
                Pattern pattern;
                Matcher matcher;
                if (!topResult.isSimple() && (matcher = (pattern = Patterns.getPattern(REGEXP_TOP_TASK)).matcher(line)).find()) {
                    topResult.getFullData().setTaskTotal(Integer.parseInt(matcher.group(1)));
                    topResult.getFullData().setTaskRunningTotal(Integer.parseInt(matcher.group(2)));
                    topResult.getFullData().setTaskSleepingTotal(Integer.parseInt(matcher.group(3)));
                    topResult.getFullData().setTaskStoppedTotal(Integer.parseInt(matcher.group(4)));
                    topResult.getFullData().setTaskZombieTotal(Integer.parseInt(matcher.group(5)));
                }
            } else if (line.startsWith("Cpu(s):")) {
                Pattern pattern;
                Matcher matcher;
                if (!topResult.isSimple() && (matcher = (pattern = Patterns.getPattern(REGEXP_TOP_CPU)).matcher(line)).find()) {
                    topResult.getFullData().setCpuUnnicedUser(Double.parseDouble(matcher.group(1)));
                    topResult.getFullData().setCpuSystem(Double.parseDouble(matcher.group(2)));
                    topResult.getFullData().setCpuNicedUser(Double.parseDouble(matcher.group(3)));
                    topResult.getFullData().setCpuIdle(Double.parseDouble(matcher.group(4)));
                    topResult.getFullData().setCpuIoWait(Double.parseDouble(matcher.group(5)));
                    topResult.getFullData().setCpuHardInterrupts(Double.parseDouble(matcher.group(6)));
                    topResult.getFullData().setCpuSoftInterrupts(Double.parseDouble(matcher.group(7)));
                }
            } else if (line.startsWith("Mem:")) {
                Pattern pattern;
                Matcher matcher;
                if (!topResult.isSimple() && (matcher = (pattern = Patterns.getPattern(REGEXP_TOP_MEM)).matcher(line)).find()) {
                    topResult.getFullData().setMemTotal(this.toByteVal(matcher.group(1)));
                    topResult.getFullData().setMemUsed(this.toByteVal(matcher.group(2)));
                    topResult.getFullData().setMemFree(this.toByteVal(matcher.group(3)));
                    topResult.getFullData().setMemBuffers(this.toByteVal(matcher.group(4)));
                }
            } else if (line.startsWith("Swap:")) {
                Pattern pattern;
                Matcher matcher;
                if (!topResult.isSimple() && (matcher = (pattern = Patterns.getPattern(REGEXP_TOP_SWAP)).matcher(line)).find()) {
                    topResult.getFullData().setSwapTotal(this.toByteVal(matcher.group(1)));
                    topResult.getFullData().setSwapUsed(this.toByteVal(matcher.group(2)));
                    topResult.getFullData().setSwapFree(this.toByteVal(matcher.group(3)));
                    topResult.getFullData().setSwapCached(this.toByteVal(matcher.group(4)));
                }
            } else if (line.length() == 0) {
                if (!topResult.isSimple()) {
                    if (!topResult.getFullData().getProcessResults().isEmpty()) {
                        this.topResult = topResult;
                    }
                } else if (!topResult.getSimpleData().getThreadCpuUsage().isEmpty()) {
                    this.topResult = topResult;
                }
            } else if (line.length() > 0 && !line.startsWith("PID")) {
                Pattern pattern = Patterns.getPattern(REGEXP_TOP_PID);
                Matcher matcher = pattern.matcher(line);
                if (!topResult.isSimple()) {
                    if (matcher.find()) {
                        TopResult.TopProcessResult processResult = new TopResult.TopProcessResult();
                        String pid = matcher.group(1);
                        processResult.setPid(Integer.parseInt(pid));
                        String user = matcher.group(2);
                        processResult.setUser(user);
                        String priority = matcher.group(3);
                        processResult.setPriority(Integer.parseInt(priority));
                        String nice = matcher.group(4);
                        processResult.setNice(Integer.parseInt(nice));
                        String virtualMemory = matcher.group(5);
                        processResult.setVirtualMemory(this.toByteVal(virtualMemory));
                        String residentMemory = matcher.group(6);
                        processResult.setResidentMemory(this.toByteVal(residentMemory));
                        String sharedMemory = matcher.group(7);
                        processResult.setSharedMemory(this.toByteVal(sharedMemory));
                        String status = matcher.group(8);
                        processResult.setStatus(status);
                        String cpuUsage = matcher.group(9);
                        processResult.setCpuUsage(Double.parseDouble(cpuUsage));
                        String memUsage = matcher.group(10);
                        processResult.setMemUsage(Double.parseDouble(memUsage));
                        topResult.getFullData().getProcessResults().add(processResult);
                    }
                } else if (matcher.find()) {
                    String pid = matcher.group(1);
                    String cpuUsage = matcher.group(9);
                    topResult.getSimpleData().getThreadCpuUsage().put(Integer.parseInt(pid), Double.parseDouble(cpuUsage));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

