/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.reflect;

import io.polaris.core.collection.Iterables;
import io.polaris.core.lang.Types;
import io.polaris.core.map.Maps;
import io.polaris.core.reflect.GetterFunction;
import io.polaris.core.reflect.MethodReferenceReflection;
import io.polaris.core.reflect.SerializableConsumer;
import io.polaris.core.reflect.SerializableSupplier;
import io.polaris.core.reflect.SetterFunction;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class Reflects {
    public static final String TO_STRING = "toString";
    public static final String HASH_CODE = "hashCode";
    public static final String EQUALS = "equals";
    public static final String GET_CLASS = "getClass";
    public static final String CLONE = "clone";
    public static final String FINALIZE = "finalize";
    public static final String WAIT = "wait";
    public static final String NOTIFY = "notify";
    public static final String NOTIFY_ALL = "notifyAll";
    public static final String SET = "set";
    public static final String IS = "is";
    public static final String GET = "get";
    public static final String ANNOTATION_TYPE = "annotationType";
    public static final String MAIN_METHOD = "main";
    public static final Class<?>[] MAIN_METHOD_ARGS = new Class[]{String[].class};
    private static final Map<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = Maps.newWeakKeyMap(new ConcurrentHashMap());
    private static final Map<Class<?>, Field[]> FIELDS_CACHE = Maps.newWeakKeyMap(new ConcurrentHashMap());
    private static final Map<Class<?>, Method[]> METHODS_CACHE = Maps.newWeakKeyMap(new ConcurrentHashMap());

    public static Class findMethodGenericReturnType(Method method, Class targetType) {
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof TypeVariable) {
            Object genericDeclaration = ((TypeVariable)genericReturnType).getGenericDeclaration();
            TypeVariable<?>[] typeParameters = genericDeclaration.getTypeParameters();
            int idx = -1;
            for (int i = 0; i < typeParameters.length; ++i) {
                TypeVariable<?> typeParameter = typeParameters[i];
                if (typeParameter != genericReturnType) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                return Reflects.findActualTypeArgument(method.getDeclaringClass(), targetType, idx);
            }
        }
        return null;
    }

    public static Class findActualTypeArgument(Class parameterizedSuperType, Object obj, int index) {
        return Reflects.findActualTypeArgument(parameterizedSuperType, obj.getClass(), index);
    }

    public static Class findActualTypeArgument(Class parameterizedSuperType, Class targetClass, int index) {
        if (parameterizedSuperType == targetClass || !parameterizedSuperType.isAssignableFrom(targetClass)) {
            return null;
        }
        TypeVariable<Class<T>>[] typeParameters = parameterizedSuperType.getTypeParameters();
        if (typeParameters.length <= index) {
            return null;
        }
        Deque<ParameterizedType> q = Reflects.findParameterizedTypes(parameterizedSuperType, targetClass);
        int i = index;
        ParameterizedType t = q.pollLast();
        while (t != null) {
            Type[] actualTypeArguments = t.getActualTypeArguments();
            if (actualTypeArguments[i] instanceof Class) {
                return (Class)actualTypeArguments[i];
            }
            if (actualTypeArguments[i] instanceof WildcardType) {
                Type[] upperBounds = ((WildcardType)actualTypeArguments[i]).getUpperBounds();
                if (upperBounds.length == 1) {
                    return Types.getClass(upperBounds[0]);
                }
                return Object.class;
            }
            if (actualTypeArguments[i] instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)actualTypeArguments[i]).getRawType();
                if (rawType instanceof Class) {
                    return (Class)rawType;
                }
                return Object.class;
            }
            if (actualTypeArguments[i] instanceof TypeVariable) {
                for (int j = 0; j < i; ++j) {
                    if (!(actualTypeArguments[j] instanceof Class)) continue;
                    --i;
                }
            } else if (actualTypeArguments[i] instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)actualTypeArguments[i]).getGenericComponentType();
                Class<?> componentClass = Types.getClass(componentType);
                return Types.getArrayClass(componentClass);
            }
            t = q.pollLast();
        }
        return null;
    }

    static Deque<ParameterizedType> findParameterizedTypes(Class parameterizedSuperType, Class targetClass) {
        ArrayDeque<ParameterizedType> q = new ArrayDeque<ParameterizedType>();
        Class that = targetClass;
        block0: while (true) {
            Type[] genericInterfaces;
            Type genericSuperclass;
            if ((genericSuperclass = that.getGenericSuperclass()) != null) {
                if (parameterizedSuperType == genericSuperclass) break;
                if (genericSuperclass instanceof ParameterizedType) {
                    Type rawType = ((ParameterizedType)genericSuperclass).getRawType();
                    if (parameterizedSuperType == rawType) {
                        q.offerLast((ParameterizedType)genericSuperclass);
                        break;
                    }
                    if (rawType instanceof Class && parameterizedSuperType.isAssignableFrom((Class)rawType)) {
                        that = (Class)rawType;
                        q.offerLast((ParameterizedType)genericSuperclass);
                        continue;
                    }
                } else if (genericSuperclass instanceof Class && parameterizedSuperType.isAssignableFrom((Class)genericSuperclass)) {
                    that = (Class)genericSuperclass;
                    continue;
                }
            }
            for (Type genericInterface : genericInterfaces = that.getGenericInterfaces()) {
                if (parameterizedSuperType == genericInterface) break block0;
                if (genericInterface instanceof ParameterizedType) {
                    Type rawType = ((ParameterizedType)genericInterface).getRawType();
                    if (parameterizedSuperType == rawType) {
                        q.offerLast((ParameterizedType)genericInterface);
                        break block0;
                    }
                    if (!(rawType instanceof Class) || !parameterizedSuperType.isAssignableFrom((Class)rawType)) continue;
                    that = (Class)rawType;
                    q.offerLast((ParameterizedType)genericInterface);
                    continue block0;
                }
                if (!(genericInterface instanceof Class) || !parameterizedSuperType.isAssignableFrom((Class)genericInterface)) continue;
                that = (Class)genericInterface;
                continue block0;
            }
            break;
        }
        return q;
    }

    public static Class findActualTypeArgument(Class clazz, int index) {
        Class[] actualTypeArguments = Reflects.findActualTypeArguments(clazz);
        if (actualTypeArguments == null || actualTypeArguments.length == 0) {
            return null;
        }
        return actualTypeArguments[index];
    }

    public static Class firstParameterizedType(Class clazz) {
        return Reflects.findActualTypeArgument(clazz, 0);
    }

    public static Class[] findActualTypeArguments(Class clazz) {
        Deque<ParameterizedType> parameterizedTypes = Reflects.findAllParameterizedTypes(clazz);
        if (parameterizedTypes.isEmpty()) {
            return null;
        }
        ParameterizedType parameterizedType = parameterizedTypes.peekFirst();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Class[] types = new Class[actualTypeArguments.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = Types.getClass(actualTypeArguments[i]);
        }
        return types;
    }

    static Deque<ParameterizedType> findAllParameterizedTypes(Class clazz) {
        ArrayDeque<ParameterizedType> rs = new ArrayDeque<ParameterizedType>();
        ArrayDeque<Type> q = new ArrayDeque<Type>();
        q.offerLast(clazz);
        while (!q.isEmpty()) {
            Type[] genericInterfaces;
            Type genericSuperclass;
            Type type = (Type)q.pollFirst();
            if (type instanceof ParameterizedType) {
                rs.offerLast((ParameterizedType)type);
                continue;
            }
            if (!(type instanceof Class)) continue;
            if (!((Class)type).isInterface() && (genericSuperclass = ((Class)type).getGenericSuperclass()) != null && genericSuperclass != Object.class) {
                q.offerLast(genericSuperclass);
            }
            for (Type genericInterface : genericInterfaces = ((Class)type).getGenericInterfaces()) {
                q.offerLast(genericInterface);
            }
        }
        return rs;
    }

    private static String toGetterOrSetterName(String name) {
        if (name.startsWith(GET) || name.startsWith(SET)) {
            name = name.substring(3);
        } else if (name.startsWith(IS)) {
            name = name.substring(2);
        }
        return Introspector.decapitalize(name);
    }

    public static String getLambdaMethodName(MethodReferenceReflection f) {
        return f.serialized().getImplMethodName();
    }

    public static <T> String getPropertyName(SerializableSupplier<T> getter) {
        return Reflects.toGetterOrSetterName(getter.method().getName());
    }

    public static <T> String getPropertyName(SerializableConsumer<T> setter) {
        return Reflects.toGetterOrSetterName(setter.method().getName());
    }

    public static <T, R> String getPropertyName(GetterFunction<T, R> getter) {
        return Reflects.toGetterOrSetterName(getter.method().getName());
    }

    public static <T, R> String getPropertyName(SetterFunction<T, R> setter) {
        return Reflects.toGetterOrSetterName(setter.method().getName());
    }

    public static void setAccessible(AccessibleObject accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }

    public static <T> Constructor<T> getConstructor(@Nonnull Class<T> clazz, Class<?> ... parameterTypes) {
        Class<?>[] pts;
        Constructor<T>[] constructors;
        for (Constructor<T> constructor : constructors = Reflects.getConstructors(clazz)) {
            pts = constructor.getParameterTypes();
            if (!Iterables.isMatchAll(pts, parameterTypes, (c1, c2) -> c1 == c2)) continue;
            Reflects.setAccessible(constructor);
            return constructor;
        }
        for (Constructor<T> constructor : constructors) {
            pts = constructor.getParameterTypes();
            if (!Iterables.isMatchAll(pts, parameterTypes, Class::isAssignableFrom)) continue;
            Reflects.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(@Nonnull Class<T> beanClass) {
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, c -> Reflects.getConstructorsDirectly(beanClass));
    }

    public static <T> Constructor<T>[] getConstructorsDirectly(@Nonnull Class<T> beanClass) {
        return beanClass.getDeclaredConstructors();
    }

    public static Field[] getFields(Class<?> beanClass) {
        return FIELDS_CACHE.computeIfAbsent(beanClass, c -> Reflects.getFieldsDirectly(beanClass, true));
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) {
        Class<?> searchType = beanClass;
        ArrayList<Field> list = new ArrayList<Field>();
        while (searchType != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = searchType.getDeclaredFields()) {
                list.add(field);
            }
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return list.toArray(new Field[0]);
    }

    public static Field[] getFields(Class<?> beanClass, Predicate<Field> fieldFilter) {
        return (Field[])Arrays.stream(Reflects.getFields(beanClass)).filter(fieldFilter).toArray(Field[]::new);
    }

    public static Field getField(Class<?> beanClass, String name) {
        Field[] fields = Reflects.getFields(beanClass);
        return Arrays.stream(Reflects.getFields(beanClass)).filter(f -> f.getName().equals(name)).findFirst().orElse(null);
    }

    public static Map<String, Field> getFieldMap(Class<?> beanClass) {
        Field[] fields = Reflects.getFields(beanClass);
        HashMap<String, Field> map = new HashMap<String, Field>((int)((double)fields.length * 1.5));
        for (Field field : fields) {
            map.putIfAbsent(field.getName(), field);
        }
        return map;
    }

    public static Object getFieldValueQuietly(Object o, String name) {
        try {
            return Reflects.getFieldValue(o, name);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public static Object getFieldValue(Object o, String name) throws ReflectiveOperationException {
        Field field = Reflects.getField(o.getClass(), name);
        if (field == null) {
            return null;
        }
        Reflects.setAccessible(field);
        if (Modifier.isStatic(field.getModifiers())) {
            return field.get(null);
        }
        return field.get(o);
    }

    public static void setFieldValue(Object o, String name, Object value) throws ReflectiveOperationException {
        Field field = Reflects.getField(o.getClass(), name);
        if (field == null) {
            return;
        }
        if (!field.getType().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException();
        }
        Reflects.setAccessible(field);
        if (Modifier.isStatic(field.getModifiers())) {
            field.set(null, value);
        } else {
            field.set(o, value);
        }
    }

    private static String toMethodKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName()).append("(");
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        sb.append("):").append(method.getReturnType().getName());
        return sb.toString();
    }

    public static Method[] getMethods(Class<?> beanClass) {
        return METHODS_CACHE.computeIfAbsent(beanClass, c -> Reflects.getMethodsDirectly(beanClass, true, true));
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) {
        if (beanClass.isInterface()) {
            return withSupers ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        }
        LinkedHashMap<String, Method> map = new LinkedHashMap<String, Method>();
        Class<?> searchType = beanClass;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            for (Method method : searchType.getDeclaredMethods()) {
                map.putIfAbsent(Reflects.toMethodKey(method), method);
            }
            for (GenericDeclaration genericDeclaration : searchType.getInterfaces()) {
                for (Method m : ((Class)genericDeclaration).getMethods()) {
                    if (Modifier.isAbstract(m.getModifiers())) continue;
                    map.putIfAbsent(Reflects.toMethodKey(m), m);
                }
            }
            searchType = withSupers && !searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return map.values().toArray(new Method[0]);
    }

    public static Method[] getMethods(Class<?> clazz, Predicate<Method> filter) {
        return (Method[])Arrays.stream(Reflects.getMethods(clazz)).filter(filter).toArray(Method[]::new);
    }

    public static Set<String> getMethodNames(Class<?> clazz) {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = Reflects.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) {
        return Reflects.getMethodByName(clazz, methodName, false);
    }

    public static Method getMethodByName(Class<?> clazz, String methodName, boolean ignoreCase) {
        Method[] methods = Reflects.getMethods(clazz);
        if (ignoreCase) {
            for (Method method : methods) {
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method;
            }
        } else {
            for (Method method : methods) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        for (Method method : methods = Reflects.getMethods(clazz)) {
            if (!method.getName().equalsIgnoreCase(methodName) || !Iterables.isMatchAll(method.getParameterTypes(), paramTypes, (c1, c2) -> c1 == c2)) continue;
            return method;
        }
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(methodName) || !Iterables.isMatchAll(method.getParameterTypes(), paramTypes, Class::isAssignableFrom)) continue;
            return method;
        }
        return null;
    }

    public static boolean isGetterMethod(Method method) {
        return method != null && method.getParameterCount() == 0 && method.getName().length() > 2 && (method.getName().startsWith(IS) && method.getReturnType() == Boolean.TYPE || method.getName().startsWith(GET) && method.getReturnType() != Void.TYPE);
    }

    public static boolean isSetterMethod(Method method) {
        return method != null && method.getParameterCount() == 1 && method.getName().length() > 3 && method.getName().startsWith(SET);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || method.getParameterCount() != 1 || !EQUALS.equals(method.getName())) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && HASH_CODE.equals(method.getName()) && method.getParameterCount() == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && TO_STRING.equals(method.getName()) && method.getParameterCount() == 0;
    }

    public static boolean isGetClassMethod(Method method) {
        return method != null && GET_CLASS.equals(method.getName()) && method.getParameterCount() == 0;
    }

    public static boolean isCloneMethod(Method method) {
        return method != null && CLONE.equals(method.getName()) && method.getParameterCount() == 0;
    }

    public static boolean isNotifyMethod(Method method) {
        return method != null && NOTIFY.equals(method.getName()) && method.getParameterCount() == 0;
    }

    public static boolean isNotifyAllMethod(Method method) {
        return method != null && NOTIFY_ALL.equals(method.getName()) && method.getParameterCount() == 0;
    }

    public static boolean isWaitMethod(Method method) {
        return method != null && WAIT.equals(method.getName()) && (method.getParameterCount() == 0 || method.getParameterCount() == 1 && method.getParameterTypes()[0] == Long.TYPE || method.getParameterCount() == 2 && method.getParameterTypes()[0] == Long.TYPE && method.getParameterTypes()[1] == Integer.TYPE);
    }

    public static boolean isFinalizeMethod(Method method) {
        return method != null && FINALIZE.equals(method.getName()) && method.getParameterCount() == 0;
    }

    public boolean isAnnotationTypeMethod(Method method) {
        return method != null && ANNOTATION_TYPE.equals(method.getName()) && method.getParameterCount() == 0;
    }

    public static boolean isObjectDeclaredMethod(Method method) {
        return Reflects.isEqualsMethod(method) || Reflects.isHashCodeMethod(method) || Reflects.isToStringMethod(method) || Reflects.isGetClassMethod(method) || Reflects.isCloneMethod(method) || Reflects.isNotifyMethod(method) || Reflects.isNotifyAllMethod(method) || Reflects.isWaitMethod(method) || Reflects.isFinalizeMethod(method);
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Predicate<Method> filter) {
        Method[] methods = Reflects.getPublicMethods(clazz);
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods) {
            if (!filter.test(method)) continue;
            methodList.add(method);
        }
        return methodList;
    }

    public static <T> T newInstance(String className) throws ReflectiveOperationException {
        return (T)Reflects.newInstance(Class.forName(className), new Object[0]);
    }

    public static <T> T newInstance(Class<T> clazz, Class[] paramTypes, Object[] params) throws ReflectiveOperationException {
        Constructor<T> constructor = Reflects.getConstructor(clazz, paramTypes);
        if (constructor != null) {
            return constructor.newInstance(params);
        }
        throw new NoSuchMethodException();
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws ReflectiveOperationException {
        if (params.length == 0) {
            Constructor<T> constructor = Reflects.getConstructor(clazz, new Class[0]);
            if (constructor != null) {
                return constructor.newInstance(new Object[0]);
            }
            constructor = Reflects.getConstructor(clazz, Object[].class);
            if (constructor != null) {
                return constructor.newInstance(params);
            }
        } else {
            Class[] paramTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramTypes[i] = params[i] == null ? Object.class : params[i].getClass();
            }
            Constructor<T> constructor = Reflects.getConstructor(clazz, paramTypes);
            if (constructor != null) {
                return constructor.newInstance(params);
            }
        }
        throw new NoSuchMethodException();
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        if (Types.isPrimitiveWrapper(type)) {
            type = Types.getPrimitiveClassByWrapper(type);
        }
        if (type.isPrimitive()) {
            return (T)Types.getDefaultValue(type);
        }
        if (type.isAssignableFrom(AbstractMap.class)) {
            type = HashMap.class;
        } else if (type.isAssignableFrom(ConcurrentNavigableMap.class)) {
            type = ConcurrentSkipListMap.class;
        } else if (type.isAssignableFrom(ConcurrentMap.class)) {
            type = ConcurrentHashMap.class;
        } else if (type.isAssignableFrom(NavigableMap.class)) {
            type = TreeMap.class;
        } else if (type.isAssignableFrom(List.class)) {
            type = ArrayList.class;
        } else if (type.isAssignableFrom(Set.class)) {
            type = HashSet.class;
        } else if (type.isAssignableFrom(BlockingDeque.class)) {
            type = LinkedBlockingDeque.class;
        } else if (type.isAssignableFrom(Deque.class)) {
            type = ArrayDeque.class;
        }
        try {
            return (T)Reflects.newInstance(type, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<T>[] constructors;
            if (type.isEnum()) {
                return type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            for (Constructor<T> constructor : constructors = Reflects.getConstructors(type)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                Reflects.setAccessible(constructor);
                try {
                    return constructor.newInstance(Types.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws ReflectiveOperationException {
        return Reflects.invoke(null, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws ReflectiveOperationException {
        Reflects.setAccessible(method);
        return (T)method.invoke(Modifier.isStatic(method.getModifiers()) ? null : obj, args);
    }

    public static <T> T invokeQuietly(Object obj, Method method, Object ... args) {
        try {
            return Reflects.invoke(obj, method, args);
        }
        catch (ReflectiveOperationException ignore) {
            return null;
        }
    }

    public Object invokeMain(Class clazz) throws ReflectiveOperationException {
        return this.invokeMain(clazz, new String[0]);
    }

    public Object invokeMain(Class clazz, String ... mainArgs) throws ReflectiveOperationException {
        Method main = clazz.getMethod(MAIN_METHOD, MAIN_METHOD_ARGS);
        return main.invoke(null, new Object[]{mainArgs});
    }

    public <T> T invoke(Class clazz, String methodName, Class[] paramTypes, Object[] paramValues) throws ReflectiveOperationException {
        Method method = Reflects.getMethod(clazz, methodName, paramTypes);
        if (method == null) {
            return null;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return Reflects.invoke(null, method, paramValues);
        }
        T o = Reflects.newInstanceIfPossible(clazz);
        return Reflects.invoke(o, method, paramValues);
    }

    public static boolean removeFinalModifier(Field field) throws ReflectiveOperationException {
        if (Modifier.isFinal(field.getModifiers())) {
            Reflects.setAccessible(field);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            return true;
        }
        return false;
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        return Reflects.loadClass(name, null);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class type;
        name = name.replace('/', '.');
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((type = Types.getPrimitiveClassByName(name)) == null) {
            type = Reflects.doLoadClass(name, classLoader);
        }
        return type;
    }

    private static Class doLoadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        block8: {
            if (name.endsWith("[]")) {
                String elementClassName = name.substring(0, name.length() - 2);
                Class<?> elementClass = Reflects.loadClass(elementClassName, classLoader);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith("[L") && name.endsWith(";")) {
                String elementName = name.substring(2, name.length() - 1);
                Class<?> elementClass = Reflects.loadClass(elementName, classLoader);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith("[")) {
                String elementName = name.substring(1);
                Class<?> elementClass = Reflects.loadClass(elementName, classLoader);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                try {
                    clazz = Class.forName(name, true, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    clazz = Reflects.tryLoadInnerClass(name, classLoader);
                    if (null != clazz) break block8;
                    throw ex;
                }
            }
        }
        return clazz;
    }

    private static Class<?> tryLoadInnerClass(String name, ClassLoader classLoader) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
            try {
                return Class.forName(innerClassName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                return Reflects.tryLoadInnerClass(innerClassName, classLoader);
            }
        }
        return null;
    }
}

