/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.regex;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Patterns {
    private static final Map<String, Pattern> CACHED_PATTERNS = new ConcurrentHashMap<String, Pattern>();

    public static boolean find(String regex, String content) {
        return Patterns.getPattern(regex).matcher(content).find();
    }

    public static boolean matches(String regex, String content) {
        return Patterns.getPattern(regex).matcher(content).matches();
    }

    public static Matcher matcher(String regex, String content) {
        return Patterns.getPattern(regex).matcher(content);
    }

    public static Pattern getPattern(String regex) {
        Pattern pattern = CACHED_PATTERNS.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            CACHED_PATTERNS.put(regex, pattern);
        }
        return pattern;
    }
}

