/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.script;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import io.polaris.core.crypto.digest.Digests;
import io.polaris.core.script.ErrorScript;
import io.polaris.core.script.NullScript;
import io.polaris.core.script.Script;
import io.polaris.core.script.ScriptEvalException;
import io.polaris.core.string.Strings;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyCompiler {
    private String defaultClassNamePrefix = "DefGvy_";
    private String defaultClassNameSuffix = ".groovy";
    private MyGroovyClassLoader groovyClassLoader;
    private Map<String, ClassEntry> classCache = new ConcurrentHashMap<String, ClassEntry>();

    public GroovyCompiler(ClassLoader classLoader) {
        CompilerConfiguration config = CompilerConfiguration.DEFAULT;
        this.groovyClassLoader = new MyGroovyClassLoader(classLoader, config);
    }

    public static GroovyCompiler getInstance() {
        return Holder.get(Thread.currentThread().getContextClassLoader());
    }

    public static GroovyCompiler getInstance(ClassLoader classLoader) {
        return Holder.get(classLoader);
    }

    private static String sha1(String content) {
        return Base64.getEncoder().encodeToString(Digests.sha1(content != null ? content.trim() : ""));
    }

    private String buildDefaultScriptName(String str) {
        return this.defaultClassNamePrefix + str + this.defaultClassNameSuffix;
    }

    public void clearScript(String scriptName) {
        ClassEntry entry;
        if (Strings.isNotBlank(scriptName) && (entry = this.classCache.get(scriptName)) != null) {
            this.classCache.remove(scriptName);
            this.groovyClassLoader.clearCache(entry.getValue());
        }
    }

    public void clearScript(String scriptName, String scriptSource) {
        if (Strings.isBlank(scriptName)) {
            String hash = GroovyCompiler.sha1(scriptSource);
            scriptName = this.buildDefaultScriptName(hash);
        }
        this.clearScript(scriptName);
    }

    public Script compileScript(String scriptName, String scriptSource) {
        try {
            Class klass = this.compile(scriptName, scriptSource);
            return this.createScript(klass);
        }
        catch (Throwable e) {
            return new ErrorScript(e);
        }
    }

    public Script createScript(Class klass) {
        if (klass == null) {
            return new NullScript();
        }
        if (Script.class.isAssignableFrom(klass)) {
            try {
                return (Script)klass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new ScriptEvalException("\u521d\u59cb\u5316\u811a\u672c\u7c7b\u5931\u8d25", e);
            }
        }
        try {
            return variables -> {
                groovy.lang.Script script = InvokerHelper.createScript((Class)klass, null);
                script.setBinding(new Binding(variables));
                return script.run();
            };
        }
        catch (Exception e) {
            throw new ScriptEvalException("\u521d\u59cb\u5316\u811a\u672c\u7c7b\u5931\u8d25", e);
        }
    }

    public GroovyClassLoader getClassLoader() {
        return this.groovyClassLoader;
    }

    public Class compile(String content) {
        return this.compile(null, content);
    }

    public Class compile(String name, String content) {
        ClassEntry entry;
        String hash = GroovyCompiler.sha1(content);
        if (Strings.isBlank(name)) {
            name = this.buildDefaultScriptName(hash);
        }
        if ((entry = this.classCache.get(name)) != null) {
            if (entry.getHash().equals(hash)) {
                return entry.getValue();
            }
            this.groovyClassLoader.clearCache(entry.getValue());
        }
        GroovyCodeSource codeSource = new GroovyCodeSource(content, name, "/groovy/script");
        codeSource.setCachable(false);
        Class klass = this.groovyClassLoader.parseClass(codeSource);
        this.classCache.put(name, new ClassEntry(hash, klass));
        return klass;
    }

    public groovy.lang.Script createGroovyScript(Class scriptClass, Binding binding) {
        return InvokerHelper.createScript((Class)scriptClass, (Binding)binding);
    }

    public groovy.lang.Script compileGroovyScript(String name, String content, Binding binding) {
        Class clazz = this.compile(name, content);
        groovy.lang.Script script = this.createGroovyScript(clazz, binding);
        return script;
    }

    public groovy.lang.Script compileGroovyScript(String name, String content, Map<String, Object> variables) {
        return this.compileGroovyScript(name, content, new Binding(variables));
    }

    public groovy.lang.Script compileGroovyScript(String content, Map<String, Object> variables) {
        return this.compileGroovyScript(null, content, new Binding(variables));
    }

    public groovy.lang.Script compileGroovyScript(String name, String content, String ... args) {
        return this.compileGroovyScript(name, content, new Binding(args));
    }

    public groovy.lang.Script compileGroovyScript(String content, String ... args) {
        return this.compileGroovyScript(null, content, new Binding(args));
    }

    public Object runScript(String content, String name, Map<String, Object> variables) {
        return this.compileGroovyScript(name, content, variables).run();
    }

    public Object runScript(String content, Map<String, Object> variables) {
        return this.compileGroovyScript(content, variables).run();
    }

    public Object runScript(String content, String name, String ... args) {
        return this.compileGroovyScript(name, content, args).run();
    }

    public Object runScript(String content, String ... args) {
        return this.compileGroovyScript(content, args).run();
    }

    public Object runScript(String content, String name, Binding binding) {
        return this.compileGroovyScript(name, content, binding).run();
    }

    private static class MyGroovyClassLoader
    extends GroovyClassLoader {
        public MyGroovyClassLoader(ClassLoader classLoader, CompilerConfiguration config) {
            super(classLoader, config);
        }

        public MyGroovyClassLoader(CompilerConfiguration config) {
            super(Thread.currentThread().getContextClassLoader(), config);
        }

        public void clearCache(Class cls) {
            Class removed = (Class)this.classCache.remove(cls.getName());
            if (removed != null) {
                InvokerHelper.removeClass((Class)removed);
            }
        }
    }

    private static class ClassEntry {
        private String hash;
        private Class value;

        public ClassEntry(String hash, Class value) {
            this.hash = hash;
            this.value = value;
        }

        public String getHash() {
            return this.hash;
        }

        public Class getValue() {
            return this.value;
        }
    }

    private static class Holder {
        private static final Map<ClassLoader, GroovyCompiler> COMPILERS = new ConcurrentHashMap<ClassLoader, GroovyCompiler>();

        private Holder() {
        }

        public static GroovyCompiler get(ClassLoader classLoader) {
            return COMPILERS.computeIfAbsent(classLoader, loader -> new GroovyCompiler(classLoader));
        }
    }
}

