/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.service;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class Service<S> {
    static final Comparator<Service> defaultComparator = (a, b) -> {
        if (Objects.equals(a, b)) {
            return 0;
        }
        int rs = Integer.compare(a.order, b.order);
        if (rs == 0) {
            rs = a.serviceClass.getName().compareTo(b.serviceClass.getName());
        }
        return rs;
    };
    private final Class<? extends S> serviceClass;
    private final String serviceName;
    private final int order;
    private final Map<String, String> properties;
    private final Function<S, S> wrapperBuilder;
    private volatile S singletonPure;
    private volatile S singleton;

    Service(Class<? extends S> serviceClass, Map<String, String> properties, String serviceName, int order, Function<S, S> wrapperBuilder) {
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.order = order;
        this.properties = properties;
        this.wrapperBuilder = wrapperBuilder;
    }

    public String getProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    private void build() {
        this.singletonPure = this.newPureInstance();
        this.singleton = this.wrapperBuilder == null ? this.singletonPure : this.wrapperBuilder.apply(this.singletonPure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getPureSingleton() {
        if (this.singletonPure == null) {
            Service service = this;
            synchronized (service) {
                if (this.singletonPure == null) {
                    this.build();
                }
            }
        }
        return this.singletonPure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getSingleton() {
        if (this.singleton == null) {
            Service service = this;
            synchronized (service) {
                if (this.singleton == null) {
                    this.build();
                }
            }
        }
        return this.singleton;
    }

    public S newInstance() {
        return this.wrapperBuilder == null ? this.newPureInstance() : this.wrapperBuilder.apply(this.newPureInstance());
    }

    public S newInstance(Class<?>[] parameterTypes, Object[] args) {
        return this.wrapperBuilder == null ? this.newPureInstance(parameterTypes, args) : this.wrapperBuilder.apply(this.newPureInstance(parameterTypes, args));
    }

    public S newPureInstance() {
        try {
            return this.serviceClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25", e);
        }
    }

    public S newPureInstance(Class<?>[] parameterTypes, Object[] args) {
        try {
            return this.serviceClass.getConstructor(parameterTypes).newInstance(args);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25", e);
        }
    }

    public String toString() {
        return "Service{serviceClass=" + this.serviceClass.getName() + ", serviceName=" + this.serviceName + ", properties=" + this.properties + '}';
    }

    public Class<? extends S> getServiceClass() {
        return this.serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    int getOrder() {
        return this.order;
    }
}

