/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.service.provider;

import io.polaris.core.service.StatefulServiceLoader;
import java.util.Optional;
import java.util.function.Supplier;

public class ServiceProvider<S> {
    private final Supplier<S> factory;
    private volatile boolean initialized = false;
    private S service;

    public ServiceProvider(Supplier<S> factory) {
        this.factory = factory;
    }

    public static <S> ServiceProvider<S> of(Supplier<S> factory) {
        return new ServiceProvider<S>(factory);
    }

    public static <S> ServiceProvider<S> of(Class<S> clazz) {
        return new ServiceProvider<Object>(() -> StatefulServiceLoader.load(clazz).service());
    }

    public Optional<S> optional() {
        return Optional.ofNullable(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S get() {
        if (!this.initialized) {
            ServiceProvider serviceProvider = this;
            synchronized (serviceProvider) {
                if (!this.initialized) {
                    this.service = this.factory.get();
                    this.initialized = true;
                }
            }
        }
        return this.service;
    }
}

