/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.string;

public class Hex {
    private static final char[] DIGITS_UPPER;

    private static String format(long num, int bits, int width) {
        int len = bits / width + (bits % width > 0 ? 1 : 0);
        long mask = ~(-1 << width);
        char[] chs = new char[len];
        for (int i = len - 1; i >= 0; --i) {
            chs[i] = DIGITS_UPPER[(int)(num & mask)];
            num >>>= width;
        }
        return new String(chs);
    }

    private static long parse(String text, int bits, int width) {
        int len = bits / width + (bits % width > 0 ? 1 : 0);
        long mask = ~(-1 << width);
        long num = 0L;
        for (int i = Integer.max(text.length() - len, 0); i < text.length(); ++i) {
            char c = text.charAt(i);
            int x = 0;
            if (c >= '0' && c <= '9') {
                x = c - 48;
            } else if (c >= 'A' && c <= 'Z') {
                x = c - 65 + 10;
            } else if (c >= 'a' && c <= 'z') {
                x = c - 97 + 10;
            }
            num <<= width;
            num |= (long)x & mask;
        }
        return num;
    }

    public static String format32Radix(long num, int bits) {
        return Hex.format(num, bits, 5);
    }

    public static String format32Radix(long num) {
        return Hex.format32Radix(num, 64);
    }

    public static String format32Radix(int num) {
        return Hex.format32Radix(num, 32);
    }

    public static String format32Radix(short num) {
        return Hex.format32Radix(num, 16);
    }

    public static String format32Radix(byte num) {
        return Hex.format32Radix(num, 8);
    }

    public static long parse32Radix(String text, int bits) {
        return Hex.parse(text, bits, 5);
    }

    public static long parse32Radix(String text) {
        return Hex.parse32Radix(text, 64);
    }

    public static int parse32RadixAsInt(String text) {
        return (int)Hex.parse32Radix(text, 32);
    }

    public static short parse32RadixAsShort(String text) {
        return (short)Hex.parse32Radix(text, 16);
    }

    public static byte parse32RadixAsByte(String text) {
        return (byte)Hex.parse32Radix(text, 8);
    }

    public static String formatHex(long num, int bits) {
        return Hex.format(num, bits, 4);
    }

    public static String formatHex(long num) {
        return Hex.formatHex(num, 64);
    }

    public static String formatHex(int num) {
        return Hex.formatHex(num, 32);
    }

    public static String formatHex(short num) {
        return Hex.formatHex(num, 16);
    }

    public static String formatHex(byte num) {
        return Hex.formatHex(num, 8);
    }

    public static long parseHex(String text, int bits) {
        return Hex.parse(text, bits, 4);
    }

    public static long parseHex(String text) {
        return Hex.parseHex(text, 64);
    }

    public static int parseHexAsInt(String text) {
        return (int)Hex.parseHex(text, 32);
    }

    public static short parseHexAsShort(String text) {
        return (short)Hex.parseHex(text, 16);
    }

    public static byte parseHexAsByte(String text) {
        return (byte)Hex.parseHex(text, 8);
    }

    public static String formatBin(long num, int bits) {
        return Hex.format(num, bits, 1);
    }

    public static String formatBin(long num) {
        return Hex.formatBin(num, 64);
    }

    public static String formatBin(int num) {
        return Hex.formatBin(num, 32);
    }

    public static String formatBin(short num) {
        return Hex.formatBin(num, 16);
    }

    public static String formatBin(byte num) {
        return Hex.formatBin(num, 8);
    }

    public static long parseBin(String text, int bits) {
        return Hex.parse(text, bits, 1);
    }

    public static long parseBin(String text) {
        return Hex.parseBin(text, 64);
    }

    public static int parseBinAsInt(String text) {
        return (int)Hex.parseBin(text, 32);
    }

    public static short parseBinAsShort(String text) {
        return (short)Hex.parseBin(text, 16);
    }

    public static byte parseBinAsByte(String text) {
        return (byte)Hex.parseBin(text, 8);
    }

    public static String formatOct(long num, int bits) {
        return Hex.format(num, bits, 3);
    }

    public static String formatOct(long num) {
        return Hex.formatOct(num, 64);
    }

    public static String formatOct(int num) {
        return Hex.formatOct(num, 32);
    }

    public static String formatOct(short num) {
        return Hex.formatOct(num, 16);
    }

    public static String formatOct(byte num) {
        return Hex.formatOct(num, 8);
    }

    public static long parseOct(String text, int bits) {
        return Hex.parse(text, bits, 3);
    }

    public static long parseOct(String text) {
        return Hex.parseOct(text, 64);
    }

    public static int parseOctAsInt(String text) {
        return (int)Hex.parseOct(text, 32);
    }

    public static short parseOctAsShort(String text) {
        return (short)Hex.parseOct(text, 16);
    }

    public static byte parseOctAsByte(String text) {
        return (byte)Hex.parseOct(text, 8);
    }

    public static String formatBytes(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Hex.formatHex(b, 8));
        }
        return sb.toString();
    }

    public static byte[] parseBytes(String text) {
        int len = text.length();
        int size = len / 2 + len % 2;
        byte[] bytes = new byte[size];
        int i = len;
        int j = size - 1;
        while (i > 0) {
            String str = text.substring(Integer.max(0, i - 2), i);
            bytes[j] = (byte)Hex.parseHex(str, 8);
            i -= 2;
            --j;
        }
        return bytes;
    }

    static {
        int i;
        DIGITS_UPPER = new char[36];
        for (i = 0; i < 10; ++i) {
            Hex.DIGITS_UPPER[i] = (char)(48 + i);
        }
        for (i = 0; i < 26; ++i) {
            Hex.DIGITS_UPPER[i + 10] = (char)(65 + i);
        }
    }
}

