/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.tuple;

import io.polaris.core.tuple.Ref;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;

public class LazyRef<V>
implements Ref<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile boolean initialized = false;
    private final Supplier<V> supplier;
    private V value;

    public LazyRef(Supplier<V> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() {
        if (!this.initialized) {
            LazyRef lazyRef = this;
            synchronized (lazyRef) {
                if (!this.initialized) {
                    this.value = this.supplier.get();
                    this.initialized = this.value != null;
                }
            }
        }
        return this.value;
    }

    public static <E> LazyRef<E> of(Supplier<E> supplier) {
        return new LazyRef<E>(supplier);
    }

    public String toString() {
        return "LazyRef{supplier=" + this.supplier + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyRef valueRef = (LazyRef)o;
        return Objects.equals(this.supplier, valueRef.supplier);
    }

    public int hashCode() {
        return Objects.hash(this.supplier);
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

