/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.proxy;

import io.polaris.core.asm.generator.AbstractClassGenerator;
import io.polaris.core.asm.internal.AsmConsts;
import io.polaris.core.asm.internal.AsmReflects;
import io.polaris.core.asm.internal.AsmTypes;
import io.polaris.core.asm.internal.Block;
import io.polaris.core.asm.internal.ClassEmitter;
import io.polaris.core.asm.internal.CodeEmitter;
import io.polaris.core.asm.internal.Emitters;
import io.polaris.core.asm.internal.Local;
import io.polaris.core.asm.internal.MethodInfo;
import io.polaris.core.asm.internal.ProcessSwitchCallback;
import io.polaris.core.asm.internal.Signature;
import io.polaris.core.asm.proxy.Interceptor;
import io.polaris.core.asm.proxy.Invoker;
import io.polaris.core.collection.PrimitiveArrays;
import io.polaris.core.err.BytecodeOperationException;
import io.polaris.core.err.InvocationException;
import io.polaris.dependency.org.objectweb.asm.ClassVisitor;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractEnhancer
extends AbstractClassGenerator {
    protected static final String GENERATED$ENHANCED = "GENERATED$ENHANCED";
    protected static final String GENERATED$STATIC_INTERCEPTOR = "GENERATED$STATIC_INTERCEPTOR";
    protected static final String GENERATED$THREAD_INTERCEPTOR = "GENERATED$THREAD_INTERCEPTOR";
    protected static final String GENERATED$TARGET_METHODS = "GENERATED$TARGET_METHODS";
    protected static final String GENERATED$SUPER_INVOKER = "GENERATED$SUPER_INVOKER";
    protected static final String GENERATED$RAW_INVOKER = "GENERATED$RAW_INVOKER";
    protected static final String GENERATED$EMPTY_ARGS = "GENERATED$EMPTY_ARGS";
    protected static final String GENERATED$SUPER_ = "GENERATED$SUPER_";
    protected static final String GENERATED$INTERCEPTORS_MATRIX = "GENERATED$INTERCEPTORS_MATRIX";
    protected static final Type TYPE_ABSTRACT_ENHANCER = Type.getType(AbstractEnhancer.class);
    protected static final Type TYPE_THREAD_LOCAL = Type.getType(ThreadLocal.class);
    protected static final Type TYPE_METHOD = Type.getType(Method.class);
    protected static final Type TYPE_METHOD_ARRAY = Type.getType(Method[].class);
    protected static final Type TYPE_INVOKER = Type.getType(Invoker.class);
    protected static final Type TYPE_INTERCEPTOR_ARRAY = Type.getType(Interceptor[].class);
    protected static final Type TYPE_INTERCEPTOR = Type.getType(Interceptor.class);
    protected static final Type TYPE_INVOCATION_EXCEPTION = Type.getType(InvocationException.class);
    protected static final Type TYPE_INTERCEPTOR_ARRAY_ARRAY = Type.getType(Interceptor[][].class);
    protected static final Signature METHOD_INVOKER__INVOKE = new Signature("invoke", AsmConsts.TYPE_OBJECT, new Type[]{Type.INT_TYPE, AsmConsts.TYPE_OBJECT, AsmConsts.TYPE_OBJECT_ARRAY});
    protected static final Signature GET_DECLARED_METHODS = AsmTypes.parseSignature("java.lang.reflect.Method[] getDeclaredMethods()");
    protected static final Signature GET_DECLARED_CONSTRUCTORS = AsmTypes.parseSignature("java.lang.reflect.Constructor[] getDeclaredConstructors()");
    protected static final Signature FIND_METHODS = AsmTypes.parseSignature("java.lang.reflect.Method[] findMethods(String[], java.lang.reflect.Method[])");
    protected static final Signature FIND_CONSTRUCTORS = AsmTypes.parseSignature("java.lang.reflect.Constructor[] findConstructors(String[], java.lang.reflect.Constructor[])");
    protected static final Signature GENERATED$INVOKE_SUPER = new Signature("GENERATED$INVOKE_SUPER", AsmConsts.TYPE_OBJECT, new Type[]{Type.INT_TYPE, AsmConsts.TYPE_OBJECT, AsmConsts.TYPE_OBJECT_ARRAY});
    protected static final Signature GENERATED$INVOKE_RAW = new Signature("GENERATED$INVOKE_RAW", AsmConsts.TYPE_OBJECT, new Type[]{Type.INT_TYPE, AsmConsts.TYPE_OBJECT, AsmConsts.TYPE_OBJECT_ARRAY});
    protected static final Signature GENERATED$SET_TARGET_METHODS = new Signature("GENERATED$SET_TARGET_METHODS", Type.VOID_TYPE, new Type[]{TYPE_METHOD_ARRAY});
    protected static final Signature GENERATED$DEL_THREAD_INTERCEPTOR = new Signature("GENERATED$DEL_THREAD_INTERCEPTOR", Type.VOID_TYPE, new Type[0]);
    protected static final Signature GENERATED$BIND_INTERCEPTOR = new Signature("GENERATED$BIND_INTERCEPTOR", Type.VOID_TYPE, new Type[]{AsmConsts.TYPE_OBJECT});
    protected static final Signature CSTRUCT_NULL = AsmTypes.parseConstructor("");
    protected static final Signature THREAD_LOCAL_GET = AsmTypes.parseSignature("Object get()");
    protected static final Signature THREAD_LOCAL_SET = AsmTypes.parseSignature("void set(Object)");
    protected static final Signature THREAD_LOCAL_REMOVE = AsmTypes.parseSignature("void remove()");
    protected Class<?> superclass;
    protected boolean withFinal = true;
    protected Class<?>[] interfaces;
    protected Long serialVersion;
    protected Method[] targetMethods;

    public static Method[] findMethods(String[] namesAndDescriptors, Method[] methods) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            map.put(method.getName() + Type.getMethodDescriptor(method), method);
        }
        Method[] result = new Method[namesAndDescriptors.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Method)map.get(namesAndDescriptors[i]);
            if (result[i] != null) continue;
            throw new IllegalArgumentException(namesAndDescriptors[i]);
        }
        return result;
    }

    public static Constructor<?>[] findConstructors(String[] descriptors, Constructor<?>[] constructors) {
        HashMap map = new HashMap();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            map.put(Type.getConstructorDescriptor(constructor), constructor);
        }
        Constructor[] result = new Constructor[descriptors.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Constructor)map.get(descriptors[i]);
            if (result[i] != null) continue;
            throw new IllegalArgumentException(descriptors[i]);
        }
        return result;
    }

    public AbstractEnhancer superclass(Class<?> superclass) {
        this.checkState();
        if (superclass != null && superclass.isInterface()) {
            this.interfaces(new Class[]{superclass});
        } else {
            this.superclass = superclass != null && superclass.equals(Object.class) ? null : superclass;
        }
        return this;
    }

    public AbstractEnhancer withFinal(boolean withFinal) {
        this.checkState();
        this.withFinal = withFinal;
        return this;
    }

    public AbstractEnhancer interfaces(Class<?>[] interfaces) {
        this.checkState();
        this.interfaces = interfaces;
        return this;
    }

    public AbstractEnhancer serialVersionUID(Long serialVersionUID) {
        this.checkState();
        this.serialVersion = serialVersionUID;
        return this;
    }

    public Object create() {
        Class<?> type = this.createClass();
        try {
            this.bindThreadInterceptors(type);
            Object object = AsmReflects.newInstance(type);
            return object;
        }
        finally {
            this.unbindThreadInterceptors(type);
        }
    }

    public Class<?> createClass() {
        Class parent;
        Class clazz = parent = this.superclass == null ? Object.class : this.superclass;
        if (Modifier.isFinal(parent.getModifiers())) {
            throw new IllegalArgumentException("Cannot subclass final class: " + parent.getName());
        }
        if (this.isEditable()) {
            if (this.superclass != null) {
                this.setPackageName(this.superclass.getPackage().getName());
                this.setBaseName(this.superclass.getSimpleName() + "$" + this.getClass().getSimpleName());
            }
            this.setKey(this.generateKey());
        }
        return super.generateClass();
    }

    protected abstract Object generateKey();

    protected abstract void registerStaticInterceptors(Class<?> var1);

    protected abstract void bindThreadInterceptors(Class<?> var1);

    protected void unbindThreadInterceptors(Class<?> type) {
        try {
            Method setter = type.getDeclaredMethod(GENERATED$DEL_THREAD_INTERCEPTOR.getName(), new Class[0]);
            setter.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type + " is not an enhanced class");
        }
        catch (ReflectiveOperationException e) {
            throw new BytecodeOperationException(e);
        }
    }

    protected void registerTargetMethods(Class<?> type) {
        try {
            Method setter = type.getDeclaredMethod(GENERATED$SET_TARGET_METHODS.getName(), Method[].class);
            setter.invoke(null, new Object[]{this.targetMethods});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type + " is not an enhanced class");
        }
        catch (ReflectiveOperationException e) {
            throw new BytecodeOperationException(e);
        }
    }

    @Override
    protected Class<?> generate(ClassLoader classLoader, AbstractClassGenerator.ClassLoaderData data) {
        Class<?> c = super.generate(classLoader, data);
        this.registerTargetMethods(c);
        this.registerStaticInterceptors(c);
        return c;
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        if (this.interfaces != null) {
            return this.interfaces[0].getClassLoader();
        }
        return null;
    }

    @Override
    protected ProtectionDomain getProtectionDomain() {
        if (this.superclass != null) {
            return AsmReflects.getProtectionDomain(this.superclass);
        }
        if (this.interfaces != null) {
            return AsmReflects.getProtectionDomain(this.interfaces[0]);
        }
        return null;
    }

    @Override
    public void generateClass(ClassVisitor cv) throws Exception {
        String className = this.getClassName();
        Class parent = this.superclass == null ? Object.class : this.superclass;
        ArrayList constructors = new ArrayList();
        for (Constructor<?> c : parent.getDeclaredConstructors()) {
            int mod = c.getModifiers();
            if (Modifier.isPrivate(mod)) continue;
            if (Modifier.isPublic(mod) || Modifier.isProtected(mod)) {
                constructors.add(c);
                continue;
            }
            if (!AsmTypes.getPackageName(className).equals(AsmTypes.getPackageName(Type.getType(parent)))) continue;
            constructors.add(c);
        }
        if (constructors.isEmpty()) {
            throw new IllegalArgumentException("no accessible constructors: " + parent.getName());
        }
        Map<String, Method> allMethods = AsmReflects.getAllAccessibleMethods(parent);
        HashMap<String, Method> undeclaredMethods = new HashMap<String, Method>();
        if (this.interfaces != null && this.interfaces.length > 0) {
            for (Class<?> anInterface : this.interfaces) {
                for (Method method : anInterface.getMethods()) {
                    Method old = allMethods.putIfAbsent(method.getName() + Type.getMethodDescriptor(method), method);
                    if (old != null) continue;
                    undeclaredMethods.put(method.getName() + Type.getMethodDescriptor(method), method);
                }
            }
        }
        Iterator<Map.Entry<String, Method>> it = allMethods.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Method> entry = it.next();
            Method method = entry.getValue();
            int mod = method.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
                it.remove();
            }
            if (method.isBridge() || method.isSynthetic()) {
                it.remove();
            }
            if (Modifier.isPublic(mod) || Modifier.isProtected(mod) || AsmTypes.getPackageName(className).equals(AsmTypes.getPackageName(Type.getType(method.getDeclaringClass())))) continue;
            it.remove();
        }
        this.targetMethods = allMethods.values().toArray(new Method[0]);
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (int i = 0; i < this.targetMethods.length; ++i) {
            Method method = this.targetMethods[i];
            int mod = method.getModifiers();
            int modifiers = mod & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
            if (this.withFinal) {
                modifiers |= 0x10;
            }
            methods.add(AsmReflects.getMethodInfo(method, modifiers));
        }
        this.saveTargetMethods(this.targetMethods);
        ClassEmitter ce = new ClassEmitter(cv);
        ce.begin_class(52, 1, className, Type.getType(parent), AsmTypes.getTypes(this.interfaces), "<generated>");
        ce.declare_field(26, GENERATED$ENHANCED, AsmConsts.TYPE_CLASS, null);
        if (this.serialVersion != null) {
            ce.declare_field(26, "serialVersionUID", Type.LONG_TYPE, this.serialVersion);
        }
        CodeEmitter e = ce.getStaticHook();
        e.push(Type.getType(parent));
        e.putstatic(ce.getClassType(), GENERATED$ENHANCED, AsmConsts.TYPE_CLASS);
        this.emitStandardFields(ce);
        this.emitSpecialFields(ce);
        this.emitStaticBlock(ce, constructors, methods);
        this.emitStaticSetTargetMethods(ce);
        this.emitStaticSetStaticInterceptor(ce);
        this.emitStaticSetThreadInterceptor(ce);
        this.emitStaticDelThreadInterceptor(ce);
        this.emitStaticBindInterceptor(ce);
        this.emitStaticInvokeRaw(ce, methods, undeclaredMethods);
        this.emitStaticInvokeSuper(ce, methods, undeclaredMethods);
        this.emitConstructors(ce, constructors);
        this.emitMethods(ce, methods, undeclaredMethods);
        this.emitSuperMethods(ce, methods, undeclaredMethods);
        this.emitSpecialMethod(ce, methods, undeclaredMethods);
        ce.end_class();
    }

    protected void saveTargetMethods(Method[] targetMethods) {
    }

    protected void emitStandardFields(ClassEmitter ce) {
        ce.declare_field(10, GENERATED$TARGET_METHODS, TYPE_METHOD_ARRAY, null);
        ce.declare_field(26, GENERATED$THREAD_INTERCEPTOR, TYPE_THREAD_LOCAL, null);
        ce.declare_field(26, GENERATED$SUPER_INVOKER, TYPE_INVOKER, null);
        ce.declare_field(26, GENERATED$RAW_INVOKER, TYPE_INVOKER, null);
        ce.declare_field(26, GENERATED$EMPTY_ARGS, AsmConsts.TYPE_OBJECT_ARRAY, null);
    }

    protected void emitSpecialFields(ClassEmitter ce) {
    }

    protected void emitStaticBlock(ClassEmitter ce, List<Constructor<?>> constructors, List<MethodInfo> methods) {
        Type thisType = ce.getClassType();
        CodeEmitter se = ce.getStaticHook();
        se.new_instance(TYPE_THREAD_LOCAL);
        se.dup();
        se.invoke_constructor(TYPE_THREAD_LOCAL, CSTRUCT_NULL);
        se.putfield(GENERATED$THREAD_INTERCEPTOR);
        se.push(0);
        se.newarray(AsmConsts.TYPE_OBJECT);
        se.putfield(GENERATED$EMPTY_ARGS);
        se.invoke_lambda(TYPE_INVOKER, METHOD_INVOKER__INVOKE, thisType, GENERATED$INVOKE_RAW);
        se.putstatic(thisType, GENERATED$RAW_INVOKER, TYPE_INVOKER);
        se.invoke_lambda(TYPE_INVOKER, METHOD_INVOKER__INVOKE, thisType, GENERATED$INVOKE_SUPER);
        se.putstatic(thisType, GENERATED$SUPER_INVOKER, TYPE_INVOKER);
    }

    protected void emitStaticInvokeSuper(ClassEmitter ce, final List<MethodInfo> methods, Map<String, Method> undeclaredMethods) {
        final Type thisType = ce.getClassType();
        final CodeEmitter e = ce.begin_method(26, GENERATED$INVOKE_SUPER, new Type[]{Type.getType(InvocationTargetException.class)});
        e.load_arg(1);
        e.checkcast_this();
        final Local target = e.make_local();
        e.store_local(target);
        e.load_arg(0);
        final Label illegalArg = e.make_label();
        Block block = e.begin_block();
        e.process_switch(PrimitiveArrays.range(methods.size()), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, Label end) {
                MethodInfo method = (MethodInfo)methods.get(key);
                Type[] types = method.getSignature().getArgumentTypes();
                e.load_local(target);
                for (int i = 0; i < types.length; ++i) {
                    e.load_arg(2);
                    e.aaload(i);
                    e.unbox(types[i]);
                }
                e.invoke_virtual(thisType, new Signature(AbstractEnhancer.GENERATED$SUPER_ + method.getSignature().getName(), method.getSignature().getDescriptor()));
                e.box(method.getSignature().getReturnType());
                e.return_value();
            }

            @Override
            public void processDefault() {
                e.goTo(illegalArg);
            }
        });
        block.end();
        Emitters.wrap_throwable(block, Type.getType(InvocationTargetException.class));
        e.mark(illegalArg);
        e.throw_exception(Type.getType(IllegalArgumentException.class), "Cannot find matching method");
        e.end_method();
    }

    protected void emitStaticInvokeRaw(ClassEmitter ce, final List<MethodInfo> methods, final Map<String, Method> undeclaredMethods) {
        final CodeEmitter e = ce.begin_method(26, GENERATED$INVOKE_RAW, new Type[]{Type.getType(InvocationTargetException.class)});
        e.load_arg(0);
        final Label illegalArg = e.make_label();
        Block block = e.begin_block();
        e.process_switch(PrimitiveArrays.range(methods.size()), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, Label end) {
                MethodInfo method = (MethodInfo)methods.get(key);
                Type[] types = method.getSignature().getArgumentTypes();
                e.load_arg(1);
                e.checkcast(method.getClassInfo().getType());
                for (int i = 0; i < types.length; ++i) {
                    e.load_arg(2);
                    e.aaload(i);
                    e.unbox(types[i]);
                }
                if (undeclaredMethods.containsKey(method.getSignature().getName() + method.getSignature().getDescriptor())) {
                    e.invoke_interface(method.getClassInfo().getType(), method.getSignature());
                } else {
                    e.invoke_virtual(method.getClassInfo().getType(), method.getSignature());
                }
                e.box(method.getSignature().getReturnType());
                e.return_value();
            }

            @Override
            public void processDefault() {
                e.goTo(illegalArg);
            }
        });
        block.end();
        Emitters.wrap_throwable(block, Type.getType(InvocationTargetException.class));
        e.mark(illegalArg);
        e.throw_exception(Type.getType(IllegalArgumentException.class), "Cannot find matching method");
        e.end_method();
    }

    protected void emitStaticSetTargetMethods(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(9, GENERATED$SET_TARGET_METHODS, null);
        e.load_arg(0);
        e.putfield(GENERATED$TARGET_METHODS);
        e.return_value();
        e.end_method();
    }

    protected void emitStaticSetStaticInterceptor(ClassEmitter ce) {
        Signature signature = this.getSetStaticInterceptorSignature();
        CodeEmitter e = ce.begin_method(9, signature, null);
        e.load_arg(0);
        e.putfield(GENERATED$STATIC_INTERCEPTOR);
        e.return_value();
        e.end_method();
    }

    protected abstract Signature getSetStaticInterceptorSignature();

    protected void emitStaticSetThreadInterceptor(ClassEmitter ce) {
        Signature signature = this.getSetThreadInterceptorSignature();
        CodeEmitter e = ce.begin_method(9, signature, null);
        e.getfield(GENERATED$THREAD_INTERCEPTOR);
        e.load_arg(0);
        e.invoke_virtual(TYPE_THREAD_LOCAL, THREAD_LOCAL_SET);
        e.return_value();
        e.end_method();
    }

    protected abstract Signature getSetThreadInterceptorSignature();

    private void emitStaticDelThreadInterceptor(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(9, GENERATED$DEL_THREAD_INTERCEPTOR, null);
        e.getfield(GENERATED$THREAD_INTERCEPTOR);
        e.invoke_virtual(TYPE_THREAD_LOCAL, THREAD_LOCAL_REMOVE);
        e.return_value();
        e.end_method();
    }

    protected abstract void emitStaticBindInterceptor(ClassEmitter var1);

    protected void emitConstructors(ClassEmitter ce, List<Constructor<?>> constructors) {
        for (Constructor<?> constructor : constructors) {
            MethodInfo methodInfo = AsmReflects.getMethodInfo(constructor);
            CodeEmitter e = Emitters.begin_method(ce, methodInfo, 1);
            e.load_this();
            e.dup();
            e.load_args();
            Signature sig = methodInfo.getSignature();
            e.super_invoke_constructor(sig);
            e.invoke_static_this(GENERATED$BIND_INTERCEPTOR);
            e.return_value();
            e.end_method();
        }
    }

    protected abstract void emitMethods(ClassEmitter var1, List<MethodInfo> var2, Map<String, Method> var3);

    protected void emitSuperMethods(ClassEmitter ce, List<MethodInfo> methods, Map<String, Method> undeclaredMethods) {
        Type thisType = ce.getClassType();
        for (int i = 0; i < methods.size(); ++i) {
            MethodInfo method = methods.get(i);
            CodeEmitter e = ce.begin_method(0x12 | method.getModifiers() & 0xFFFFFFFE & 0xFFFFFFFB, new Signature(GENERATED$SUPER_ + method.getSignature().getName(), method.getSignature().getDescriptor()), method.getExceptionTypes());
            e.load_this();
            e.load_args();
            Method undeclaredMethod = undeclaredMethods.get(method.getSignature().getName() + method.getSignature().getDescriptor());
            if (undeclaredMethod != null) {
                if (undeclaredMethod.isDefault()) {
                    e.super_invoke(method.getSignature());
                } else {
                    Type returnType = method.getSignature().getReturnType();
                    e.zero_or_null(returnType);
                }
            } else {
                e.super_invoke(method.getSignature());
            }
            e.return_value();
            e.end_method();
        }
    }

    protected void emitSpecialMethod(ClassEmitter ce, List<MethodInfo> methods, Map<String, Method> undeclaredMethods) {
    }
}

