/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.internal.AsmUtils;
import io.polaris.core.asm.reflect.AccessClassLoader;
import io.polaris.core.asm.reflect.AccessClassPool;
import io.polaris.core.asm.reflect.BeanPropertyInfo;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.SerializableConsumerWithArgs4;
import io.polaris.core.reflect.SerializableTriFunction;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public abstract class BeanAccess<T> {
    private static ILogger log = ILoggers.of(BeanAccess.class);
    private static final AccessClassPool<Class<?>, BeanAccess> pool = new AccessClassPool();
    private Map<String, BeanPropertyInfo> properties;
    private Map<String, Integer> setterIndices;
    private Map<String, Integer> getterIndices;
    private Map<String, Integer> fieldIndices;

    protected BeanAccess() {
    }

    public Object getIndexProperty(Object o, int methodIndex) {
        throw new IllegalArgumentException("Method not found");
    }

    public void setIndexProperty(Object o, int methodIndex, Object val) {
        throw new IllegalArgumentException("Method not found");
    }

    public Object getIndexField(Object o, int fieldIndex) {
        throw new IllegalArgumentException("Field not found");
    }

    public void setIndexField(Object o, int methodIndex, Object val) {
        throw new IllegalArgumentException("Field not found");
    }

    public Map<String, BeanPropertyInfo> properties() {
        return this.properties;
    }

    public boolean containsAny(String property) {
        return this.properties.containsKey(property);
    }

    public Set<String> allPropertyNames() {
        return this.properties.keySet();
    }

    public Type propertyGenericType(String property) {
        BeanPropertyInfo info = this.properties.get(property);
        return info == null ? null : info.getPropertyGenericType();
    }

    public Type propertyType(String property) {
        BeanPropertyInfo info = this.properties.get(property);
        return info == null ? null : info.getPropertyType();
    }

    public boolean containsSetterOrField(String key) {
        BeanPropertyInfo info = this.properties.get(key);
        if (info != null) {
            return info.getField() != null || info.getWriteMethod() != null;
        }
        return false;
    }

    public boolean containsGetterOrField(String key) {
        BeanPropertyInfo info = this.properties.get(key);
        if (info != null) {
            return info.getField() != null || info.getReadMethod() != null;
        }
        return false;
    }

    public Object getPropertyOrField(Object o, String key) {
        int i = this.getGetterIndex(key);
        if (i >= 0) {
            return this.getIndexProperty(o, i);
        }
        i = this.getFieldIndex(key);
        if (i >= 0) {
            return this.getIndexField(o, i);
        }
        return null;
    }

    public boolean setPropertyOrField(Object o, String key, Object val) {
        int i = this.getSetterIndex(key);
        if (i >= 0) {
            this.setIndexProperty(o, i, val);
            return true;
        }
        i = this.getFieldIndex(key);
        if (i >= 0) {
            this.setIndexField(o, i, val);
            return true;
        }
        return false;
    }

    public boolean setPropertyOrField(Object o, String key, Object val, BiFunction<Type, Object, Object> converter) {
        BeanPropertyInfo info = this.properties.get(key);
        if (info == null) {
            return false;
        }
        Type type = info.getPropertyGenericType();
        if (info.getField() != null) {
            this.setField(o, key, converter.apply(type, val));
            return true;
        }
        if (info.getWriteMethod() != null) {
            this.setProperty(o, key, converter.apply(type, val));
            return true;
        }
        return false;
    }

    public boolean containsSetter(String property) {
        return this.setterIndices.containsKey(property);
    }

    public Map<String, Integer> setterIndices() {
        return this.setterIndices;
    }

    public Set<String> setterPropertyNames() {
        return this.setterIndices.keySet();
    }

    public int getSetterIndex(String property) {
        Integer index = this.setterIndices.get(property);
        return index == null ? -1 : index;
    }

    public void setProperty(Object o, String property, Object val) {
        int index = this.getSetterIndex(property);
        if (index == -1) {
            throw new IllegalArgumentException("Method not found");
        }
        this.setIndexProperty(o, index, val);
    }

    public void setPropertyOrNoop(Object o, String property, Object val) {
        int index = this.getSetterIndex(property);
        if (index == -1) {
            return;
        }
        this.setIndexProperty(o, index, val);
    }

    public boolean containsGetter(String property) {
        return this.getterIndices.containsKey(property);
    }

    public Map<String, Integer> getterIndices() {
        return this.getterIndices;
    }

    public Set<String> getterPropertyNames() {
        return this.getterIndices.keySet();
    }

    public int getGetterIndex(String property) {
        Integer index = this.getterIndices.get(property);
        return index == null ? -1 : index;
    }

    public Object getProperty(Object o, String property) {
        int index = this.getGetterIndex(property);
        if (index == -1) {
            throw new IllegalArgumentException("Method not found");
        }
        return this.getIndexProperty(o, index);
    }

    public Object getPropertyOrNoop(Object o, String property) {
        int index = this.getSetterIndex(property);
        if (index == -1) {
            return null;
        }
        return this.getIndexProperty(o, index);
    }

    public boolean containsField(String property) {
        return this.fieldIndices.containsKey(property);
    }

    public Map<String, Integer> fieldIndices() {
        return this.fieldIndices;
    }

    public Set<String> fieldNames() {
        return this.fieldIndices.keySet();
    }

    public int getFieldIndex(String property) {
        Integer index = this.fieldIndices.get(property);
        return index == null ? -1 : index;
    }

    public void setField(Object o, String property, Object val) {
        int index = this.getFieldIndex(property);
        if (index == -1) {
            throw new IllegalArgumentException("Field not found");
        }
        this.setIndexField(o, index, val);
    }

    public Object getField(Object o, String property) {
        int index = this.getFieldIndex(property);
        if (index == -1) {
            throw new IllegalArgumentException("Field not found");
        }
        return this.getIndexField(o, index);
    }

    public void setFieldOrNoop(Object o, String property, Object val) {
        int index = this.getFieldIndex(property);
        if (index == -1) {
            return;
        }
        this.setIndexField(o, index, val);
    }

    public Object getFieldOrNoop(Object o, String property) {
        int index = this.getFieldIndex(property);
        if (index == -1) {
            return null;
        }
        return this.getIndexField(o, index);
    }

    public static <T> BeanAccess<T> get(Class<T> type) {
        return pool.computeIfAbsent(type, BeanAccess::create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> BeanAccess<T> create(Class<T> type) {
        BeanAccess access;
        Class accessClass;
        AccessClassLoader loader;
        BeanPropertyInfo.Classification classification = BeanPropertyInfo.classify(type);
        String accessClassName = AccessClassLoader.buildAccessClassName(type, BeanAccess.class);
        AccessClassLoader accessClassLoader = loader = AccessClassLoader.get(type);
        synchronized (accessClassLoader) {
            accessClass = loader.loadAccessClass(accessClassName);
            if (accessClass == null) {
                accessClass = BeanAccess.buildAccessClass(loader, accessClassName, type, classification);
            }
        }
        try {
            int i;
            access = (BeanAccess)accessClass.newInstance();
            access.properties = Collections.unmodifiableMap(classification.properties);
            HashMap<String, Integer> setterIndices = new HashMap<String, Integer>();
            for (i = 0; i < classification.setters.size(); ++i) {
                setterIndices.put(classification.setters.get(i).getPropertyName(), i);
            }
            access.setterIndices = Collections.unmodifiableMap(setterIndices);
            HashMap<String, Integer> getterIndices = new HashMap<String, Integer>();
            for (i = 0; i < classification.getters.size(); ++i) {
                getterIndices.put(classification.getters.get(i).getPropertyName(), i);
            }
            access.getterIndices = Collections.unmodifiableMap(getterIndices);
            HashMap<String, Integer> fieldIndices = new HashMap<String, Integer>();
            for (i = 0; i < classification.fields.size(); ++i) {
                fieldIndices.put(classification.fields.get(i).getPropertyName(), i);
            }
            access.fieldIndices = Collections.unmodifiableMap(fieldIndices);
        }
        catch (Throwable t) {
            throw new IllegalStateException("\u521b\u5efa\u8bbf\u95ee\u7c7b\u5931\u8d25: " + accessClassName, t);
        }
        return access;
    }

    private static <T> Class buildAccessClass(AccessClassLoader loader, String accessClassName, Class<T> type, BeanPropertyInfo.Classification classification) {
        String accessClassNameInternal = accessClassName.replace('.', '/');
        String classNameInternal = type.getName().replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        String superClassNameInternal = BeanAccess.class.getName().replace('.', '/');
        cw.visit(52, 33, accessClassNameInternal, "L" + superClassNameInternal + "<L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";>;", superClassNameInternal, null);
        cw.visitInnerClass("java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/MethodHandles", "Lookup", 25);
        AsmUtils.insertDefaultConstructor(cw, superClassNameInternal);
        BeanAccess.insertSetterInvokers(cw, accessClassNameInternal, type, classification.setters);
        BeanAccess.insertGetterInvokers(cw, accessClassNameInternal, type, classification.getters);
        BeanAccess.insertFieldInvokers(cw, accessClassNameInternal, type, classification.fields);
        cw.visitEnd();
        byte[] byteArray = cw.toByteArray();
        return loader.defineAccessClass(accessClassName, byteArray);
    }

    private static <T> void insertSetterInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type, List<BeanPropertyInfo> setters) {
        if (setters.isEmpty()) {
            return;
        }
        SerializableConsumerWithArgs4<BeanAccess, Object, Integer, Object> setIndexProperty = BeanAccess::setIndexProperty;
        MethodVisitor methodVisitor = cw.visitMethod(132, setIndexProperty.serialized().getImplMethodName(), "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 2);
        Label[] labels = AsmUtils.newLabels(setters.size());
        Label labelDefault = new Label();
        Label labelBreak = new Label();
        methodVisitor.visitTableSwitchInsn(0, setters.size() - 1, labelDefault, labels);
        for (int idxName = 0; idxName < setters.size(); ++idxName) {
            methodVisitor.visitLabel(labels[idxName]);
            BeanPropertyInfo info = setters.get(idxName);
            Method method = info.getWriteMethod();
            String methodName = method.getName();
            boolean hasThrows = method.getExceptionTypes().length > 0;
            Class<?>[] parameterTypes = method.getParameterTypes();
            Label labelStart = new Label();
            Label labelEnd = new Label();
            Label labelCatch = new Label();
            if (hasThrows) {
                methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                methodVisitor.visitLabel(labelStart);
            }
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
            if (Modifier.isStatic(method.getModifiers())) {
                methodVisitor.visitInsn(87);
            }
            methodVisitor.visitVarInsn(25, 3);
            Class<?> parameterType = parameterTypes[0];
            io.polaris.dependency.org.objectweb.asm.Type paramType = io.polaris.dependency.org.objectweb.asm.Type.getType(parameterType);
            AsmUtils.autoUnBoxing(methodVisitor, paramType);
            Class<?> declaringClass = method.getDeclaringClass();
            boolean isInterface = declaringClass.isInterface();
            int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : 182);
            methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass), methodName, io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(method), isInterface);
            Class<?> returnType = method.getReturnType();
            AsmUtils.autoBoxing(methodVisitor, returnType);
            methodVisitor.visitJumpInsn(167, labelBreak);
            if (hasThrows) {
                methodVisitor.visitLabel(labelEnd);
            }
            if (!hasThrows) continue;
            methodVisitor.visitLabel(labelCatch);
            methodVisitor.visitVarInsn(58, 4);
            methodVisitor.visitTypeInsn(187, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(IllegalArgumentException.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitMethodInsn(183, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(IllegalArgumentException.class), "<init>", "(Ljava/lang/Throwable;)V", false);
            methodVisitor.visitInsn(191);
        }
        methodVisitor.visitLabel(labelDefault);
        methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Method not found");
        methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(labelBreak);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static <T> void insertGetterInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type, List<BeanPropertyInfo> getters) {
        if (getters.isEmpty()) {
            return;
        }
        SerializableTriFunction<BeanAccess, Object, Integer, Object> getIndexProperty = BeanAccess::getIndexProperty;
        MethodVisitor methodVisitor = cw.visitMethod(132, getIndexProperty.serialized().getImplMethodName(), "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 2);
        Label[] labels = AsmUtils.newLabels(getters.size());
        Label labelDefault = new Label();
        Label labelBreak = new Label();
        methodVisitor.visitTableSwitchInsn(0, getters.size() - 1, labelDefault, labels);
        for (int idxName = 0; idxName < getters.size(); ++idxName) {
            Class<?> declaringClass;
            boolean isInterface;
            methodVisitor.visitLabel(labels[idxName]);
            BeanPropertyInfo info = getters.get(idxName);
            Method method = info.getReadMethod();
            String methodName = method.getName();
            boolean hasThrows = method.getExceptionTypes().length > 0;
            Label labelStart = new Label();
            Label labelEnd = new Label();
            Label labelCatch = new Label();
            if (hasThrows) {
                methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                methodVisitor.visitLabel(labelStart);
            }
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
            if (Modifier.isStatic(method.getModifiers())) {
                methodVisitor.visitInsn(87);
            }
            int invokeOpcode = (isInterface = (declaringClass = method.getDeclaringClass()).isInterface()) ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : 182);
            methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass), methodName, io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(method), isInterface);
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(Void.TYPE)) {
                methodVisitor.visitInsn(1);
            } else {
                AsmUtils.autoBoxing(methodVisitor, returnType);
            }
            if (hasThrows) {
                methodVisitor.visitLabel(labelEnd);
            }
            methodVisitor.visitInsn(176);
            if (!hasThrows) continue;
            methodVisitor.visitLabel(labelCatch);
            methodVisitor.visitVarInsn(58, 3);
            methodVisitor.visitTypeInsn(187, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(IllegalArgumentException.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitMethodInsn(183, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(IllegalArgumentException.class), "<init>", "(Ljava/lang/Throwable;)V", false);
            methodVisitor.visitInsn(191);
        }
        methodVisitor.visitLabel(labelDefault);
        methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Method not found");
        methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static <T> void insertFieldInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type, List<BeanPropertyInfo> fields) {
        if (fields.isEmpty()) {
            return;
        }
        SerializableTriFunction<BeanAccess<?>, Object, Integer, Object> getIndexField = BeanAccess::getIndexField;
        SerializableConsumerWithArgs4<BeanAccess<?>, Object, Integer, Object> setIndexField = BeanAccess::setIndexField;
        BeanAccess.insertStdFieldInvoker(cw, type, fields, getIndexField, setIndexField);
    }

    private static <T> void insertStdFieldInvoker(ClassWriter cw, Class<T> type, List<BeanPropertyInfo> fields, SerializableTriFunction<BeanAccess<?>, Object, Integer, Object> getter, SerializableConsumerWithArgs4<BeanAccess<?>, Object, Integer, Object> setter) {
        io.polaris.dependency.org.objectweb.asm.Type fieldType;
        String fieldName;
        Field field;
        BeanPropertyInfo info;
        int idxField;
        MethodVisitor methodVisitor = cw.visitMethod(4, getter.serialized().getImplMethodName(), "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 2);
        Label[] labels = AsmUtils.newLabels(fields.size());
        Label labelDefault = new Label();
        methodVisitor.visitTableSwitchInsn(0, fields.size() - 1, labelDefault, labels);
        for (idxField = 0; idxField < fields.size(); ++idxField) {
            methodVisitor.visitLabel(labels[idxField]);
            info = fields.get(idxField);
            field = info.getField();
            fieldName = field.getName();
            fieldType = io.polaris.dependency.org.objectweb.asm.Type.getType(field.getType());
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
            if (Modifier.isStatic(field.getModifiers())) {
                methodVisitor.visitInsn(87);
                methodVisitor.visitFieldInsn(178, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(field.getDeclaringClass()), fieldName, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(field.getType()));
            } else {
                methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type), fieldName, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(field.getType()));
            }
            AsmUtils.autoBoxing(methodVisitor, fieldType);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitLabel(labelDefault);
        methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Field not found");
        methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4, setter.serialized().getImplMethodName(), "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 2);
        labels = AsmUtils.newLabels(fields.size());
        labelDefault = new Label();
        methodVisitor.visitTableSwitchInsn(0, fields.size() - 1, labelDefault, labels);
        for (idxField = 0; idxField < fields.size(); ++idxField) {
            methodVisitor.visitLabel(labels[idxField]);
            info = fields.get(idxField);
            field = info.getField();
            fieldName = field.getName();
            fieldType = io.polaris.dependency.org.objectweb.asm.Type.getType(field.getType());
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
            if (Modifier.isStatic(field.getModifiers())) {
                methodVisitor.visitInsn(87);
            }
            methodVisitor.visitVarInsn(25, 3);
            AsmUtils.autoUnBoxing(methodVisitor, fieldType);
            if (Modifier.isStatic(field.getModifiers())) {
                methodVisitor.visitFieldInsn(179, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(field.getDeclaringClass()), fieldName, fieldType.getDescriptor());
            } else {
                methodVisitor.visitFieldInsn(181, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(field.getDeclaringClass()), fieldName, fieldType.getDescriptor());
            }
            methodVisitor.visitInsn(177);
        }
        methodVisitor.visitLabel(labelDefault);
        methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Field not found");
        methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }
}

