/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.internal.AsmUtils;
import io.polaris.core.asm.reflect.AccessClassLoader;
import io.polaris.core.asm.reflect.BeanCopier;
import io.polaris.core.asm.reflect.BeanPropertyInfo;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.SerializableBiFunction;
import io.polaris.core.reflect.SerializableConsumer;
import io.polaris.core.reflect.SerializableTriConsumer;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;

public abstract class BeanDirectCopier<S, T> {
    private static ILogger log = ILoggers.of(BeanCopier.class);
    private static final String CLASS_NAME_PREFIX = "Direct$";
    public static final String FIELD_PREFIX_TYPE = "type_";
    public static final String FIELD_PREFIX_CLASS = "class_";
    protected Class<T> targetType;
    protected BeanCopier<S> beanCopier;
    protected Map<String, BeanPropertyInfo> properties;

    protected void copy(S source, T target) {
    }

    protected abstract void initTypeFields();

    protected final void resolveCopyError(String propertyName, Throwable e) {
        if (log.isDebugEnabled()) {
            log.debug("\u590d\u5236\u5c5e\u6027[" + propertyName + "]\u5931\u8d25", e);
        }
    }

    protected final void resolveCopyError(String propertyName, Throwable e, CopyOptions options) {
        String msg = "\u590d\u5236\u5c5e\u6027[" + propertyName + "]\u5931\u8d25";
        if (options.ignoreError()) {
            log.warn(msg + ": " + e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug(msg, e);
            }
        } else {
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected final Type getPropertyGenericType(String propertyName) {
        return this.properties.get(propertyName).getPropertyGenericType();
    }

    protected final Class<?> getPropertyType(String propertyName) {
        return this.properties.get(propertyName).getPropertyType();
    }

    protected final Object convert(Type type, Object value, BiFunction<Type, Object, Object> converter) {
        if (value == null) {
            return null;
        }
        if (JavaType.of(type).isInstance(value)) {
            return value;
        }
        if (converter == null) {
            return null;
        }
        return converter.apply(type, value);
    }

    static <S, T> BeanDirectCopier<S, T> create(BeanCopier<S> beanCopier, Class<T> targetType) {
        BeanPropertyInfo.Classification classification = BeanPropertyInfo.classify(targetType);
        String accessClassName = beanCopier.getClass().getName() + CLASS_NAME_PREFIX + targetType.getName().replace("_", "__").replace('.', '_');
        AccessClassLoader loader = AccessClassLoader.get(targetType);
        Class accessClass = loader.loadOrDefineClass(accessClassName, () -> BeanDirectCopier.buildFastCopierClass(loader, beanCopier, accessClassName, targetType, classification));
        try {
            BeanDirectCopier access = (BeanDirectCopier)accessClass.newInstance();
            access.targetType = targetType;
            access.beanCopier = beanCopier;
            access.properties = Collections.unmodifiableMap(classification.properties);
            access.initTypeFields();
            return access;
        }
        catch (Throwable t) {
            throw new IllegalStateException("\u521b\u5efa\u8bbf\u95ee\u7c7b\u5931\u8d25: " + accessClassName, t);
        }
    }

    private static <S, T> byte[] buildFastCopierClass(AccessClassLoader loader, BeanCopier<S> beanCopier, String accessClassName, Class<T> type, BeanPropertyInfo.Classification classification) {
        String accessClassNameInternal = accessClassName.replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        String superClassNameInternal = io.polaris.dependency.org.objectweb.asm.Type.getInternalName(BeanDirectCopier.class);
        cw.visit(52, 33, accessClassNameInternal, "L" + superClassNameInternal + "<L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(beanCopier.sourceType) + ";L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";>;", superClassNameInternal, null);
        cw.visitInnerClass("java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/MethodHandles", "Lookup", 25);
        AsmUtils.insertDefaultConstructor(cw, superClassNameInternal);
        BeanDirectCopier.insertInitTypeFields(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanDirectCopier.insertMethodCopy(cw, beanCopier, superClassNameInternal, accessClassNameInternal, type, classification);
        cw.visitEnd();
        byte[] byteArray = cw.toByteArray();
        return byteArray;
    }

    private static <T> void insertInitTypeFields(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableConsumer init = BeanDirectCopier::initTypeFields;
        SerializableBiFunction getPropertyGenericType = BeanDirectCopier::getPropertyGenericType;
        SerializableBiFunction getPropertyType = BeanDirectCopier::getPropertyType;
        BeanCopier.insertInitTypes(cw, superClassNameInternal, accessClassNameInternal, classification, init.serialized().getImplMethodName(), getPropertyGenericType.serialized().getImplMethodName(), getPropertyType.serialized().getImplMethodName());
    }

    private static <S, T> void insertMethodCopy(ClassWriter cw, BeanCopier<S> beanCopier, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableTriConsumer<BeanDirectCopier, String, Throwable> logCopyError = BeanDirectCopier::resolveCopyError;
        SerializableTriConsumer<BeanDirectCopier, Object, Object> copy = BeanDirectCopier::copy;
        String copyName = copy.serialized().getImplMethodName();
        MethodVisitor methodVisitor = cw.visitMethod(1, copyName, "(L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(beanCopier.sourceType) + ";L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";)V", "(L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(beanCopier.sourceType) + ";L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";)V", null);
        methodVisitor.visitCode();
        classification.properties.forEach((name, targetInfo) -> {
            BeanPropertyInfo sourceInfo = beanCopier.properties.get(name);
            if (sourceInfo == null) {
                return;
            }
            if (targetInfo.getPropertyType() != sourceInfo.getPropertyType()) {
                return;
            }
            if (sourceInfo.getField() != null && targetInfo.getField() != null) {
                BeanDirectCopier.insertCodeFieldToField(methodVisitor, sourceInfo, targetInfo);
            } else if (sourceInfo.getReadMethod() != null && targetInfo.getField() != null) {
                BeanDirectCopier.insertCodeMethodToField(methodVisitor, sourceInfo, targetInfo);
            } else if (sourceInfo.getField() != null && targetInfo.getWriteMethod() != null) {
                BeanDirectCopier.insertCodeFieldToMethod(methodVisitor, sourceInfo, targetInfo);
            } else if (sourceInfo.getReadMethod() != null && targetInfo.getWriteMethod() != null) {
                BeanDirectCopier.insertCodeMethodToMethod(methodVisitor, sourceInfo, targetInfo);
            }
        });
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4164, "copy", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(beanCopier.sourceType));
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
        methodVisitor.visitMethodInsn(182, accessClassNameInternal, "copy", "(L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(beanCopier.sourceType) + ";L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
    }

    private static void insertCodeFieldToField(MethodVisitor methodVisitor, BeanPropertyInfo sourceInfo, BeanPropertyInfo targetInfo) {
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(sourceInfo.getField().getDeclaringClass()), sourceInfo.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(sourceInfo.getField().getType()));
        AsmUtils.storeVar(methodVisitor, sourceInfo.getField().getType(), 3);
        Label labelIf = null;
        if (Types.isPrimitive(sourceInfo.getField().getType())) {
            methodVisitor.visitVarInsn(25, 2);
            AsmUtils.loadVar(methodVisitor, sourceInfo.getField().getType(), 3);
        } else {
            AsmUtils.loadVar(methodVisitor, sourceInfo.getField().getType(), 3);
            labelIf = new Label();
            methodVisitor.visitJumpInsn(198, labelIf);
            methodVisitor.visitVarInsn(25, 2);
            AsmUtils.loadVar(methodVisitor, sourceInfo.getField().getType(), 3);
        }
        methodVisitor.visitFieldInsn(181, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(targetInfo.getField().getDeclaringClass()), targetInfo.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(targetInfo.getField().getType()));
        if (labelIf != null) {
            methodVisitor.visitLabel(labelIf);
        }
    }

    private static void insertCodeMethodToField(MethodVisitor methodVisitor, BeanPropertyInfo sourceInfo, BeanPropertyInfo targetInfo) {
        SerializableTriConsumer<BeanDirectCopier, String, Throwable> logCopyError = BeanDirectCopier::resolveCopyError;
        Method readMethod = sourceInfo.getReadMethod();
        boolean hasThrows = readMethod.getExceptionTypes().length > 0;
        Label labelStart = new Label();
        Label labelEnd = new Label();
        Label labelCatch = new Label();
        if (hasThrows) {
            methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
            methodVisitor.visitLabel(labelStart);
        }
        methodVisitor.visitVarInsn(25, 1);
        boolean isInterface = readMethod.getDeclaringClass().isInterface();
        int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(readMethod.getModifiers()) ? 184 : 182);
        methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(readMethod.getDeclaringClass()), readMethod.getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(readMethod), isInterface);
        AsmUtils.storeVar(methodVisitor, readMethod.getReturnType(), 3);
        Label labelIf = null;
        if (Types.isPrimitive(readMethod.getReturnType())) {
            methodVisitor.visitVarInsn(25, 2);
            AsmUtils.loadVar(methodVisitor, readMethod.getReturnType(), 3);
        } else {
            AsmUtils.loadVar(methodVisitor, readMethod.getReturnType(), 3);
            labelIf = new Label();
            methodVisitor.visitJumpInsn(198, labelIf);
            methodVisitor.visitVarInsn(25, 2);
            AsmUtils.loadVar(methodVisitor, readMethod.getReturnType(), 3);
        }
        methodVisitor.visitFieldInsn(181, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(targetInfo.getField().getDeclaringClass()), targetInfo.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(targetInfo.getField().getType()));
        if (labelIf != null) {
            methodVisitor.visitLabel(labelIf);
        }
        methodVisitor.visitLabel(labelEnd);
        Label labelFinal = new Label();
        methodVisitor.visitJumpInsn(167, labelFinal);
        methodVisitor.visitLabel(labelCatch);
        methodVisitor.visitVarInsn(58, 3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn(targetInfo.getPropertyName());
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(183, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(BeanDirectCopier.class), logCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
        methodVisitor.visitLabel(labelFinal);
    }

    private static void insertCodeMethodToMethod(MethodVisitor methodVisitor, BeanPropertyInfo sourceInfo, BeanPropertyInfo targetInfo) {
        SerializableTriConsumer<BeanDirectCopier, String, Throwable> logCopyError = BeanDirectCopier::resolveCopyError;
        Method readMethod = sourceInfo.getReadMethod();
        Method writeMethod = targetInfo.getWriteMethod();
        boolean hasThrows = readMethod.getExceptionTypes().length > 0 || writeMethod.getExceptionTypes().length > 0;
        Label labelStart = new Label();
        Label labelEnd = new Label();
        Label labelCatch = new Label();
        if (hasThrows) {
            methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
            methodVisitor.visitLabel(labelStart);
        }
        methodVisitor.visitVarInsn(25, 1);
        boolean isInterface = readMethod.getDeclaringClass().isInterface();
        int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(readMethod.getModifiers()) ? 184 : 182);
        methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(readMethod.getDeclaringClass()), readMethod.getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(readMethod), isInterface);
        AsmUtils.storeVar(methodVisitor, readMethod.getReturnType(), 3);
        Label labelIf = null;
        if (Types.isPrimitive(readMethod.getReturnType())) {
            methodVisitor.visitVarInsn(25, 2);
            AsmUtils.loadVar(methodVisitor, readMethod.getReturnType(), 3);
        } else {
            AsmUtils.loadVar(methodVisitor, readMethod.getReturnType(), 3);
            labelIf = new Label();
            methodVisitor.visitJumpInsn(198, labelIf);
            methodVisitor.visitVarInsn(25, 2);
            AsmUtils.loadVar(methodVisitor, readMethod.getReturnType(), 3);
        }
        isInterface = writeMethod.getDeclaringClass().isInterface();
        invokeOpcode = isInterface ? 185 : (Modifier.isStatic(writeMethod.getModifiers()) ? 184 : 182);
        methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(writeMethod.getDeclaringClass()), writeMethod.getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(writeMethod));
        if (labelIf != null) {
            methodVisitor.visitLabel(labelIf);
        }
        methodVisitor.visitLabel(labelEnd);
        Label labelFinal = new Label();
        methodVisitor.visitJumpInsn(167, labelFinal);
        methodVisitor.visitLabel(labelCatch);
        methodVisitor.visitVarInsn(58, 3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn(targetInfo.getPropertyName());
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(183, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(BeanDirectCopier.class), logCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
        methodVisitor.visitLabel(labelFinal);
    }

    private static void insertCodeFieldToMethod(MethodVisitor methodVisitor, BeanPropertyInfo sourceInfo, BeanPropertyInfo targetInfo) {
        SerializableTriConsumer<BeanDirectCopier, String, Throwable> logCopyError = BeanDirectCopier::resolveCopyError;
        Method writeMethod = targetInfo.getWriteMethod();
        boolean hasThrows = writeMethod.getExceptionTypes().length > 0;
        Label labelStart = new Label();
        Label labelEnd = new Label();
        Label labelCatch = new Label();
        if (hasThrows) {
            methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
            methodVisitor.visitLabel(labelStart);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(sourceInfo.getField().getDeclaringClass()), sourceInfo.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(sourceInfo.getField().getType()));
        AsmUtils.storeVar(methodVisitor, sourceInfo.getField().getType(), 3);
        Label labelIf = null;
        if (Types.isPrimitive(sourceInfo.getField().getType())) {
            methodVisitor.visitVarInsn(25, 2);
            AsmUtils.loadVar(methodVisitor, sourceInfo.getField().getType(), 3);
        } else {
            AsmUtils.loadVar(methodVisitor, sourceInfo.getField().getType(), 3);
            labelIf = new Label();
            methodVisitor.visitJumpInsn(198, labelIf);
            methodVisitor.visitVarInsn(25, 2);
            AsmUtils.loadVar(methodVisitor, sourceInfo.getField().getType(), 3);
        }
        boolean isInterface = writeMethod.getDeclaringClass().isInterface();
        int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(writeMethod.getModifiers()) ? 184 : 182);
        methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(writeMethod.getDeclaringClass()), writeMethod.getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(writeMethod));
        if (labelIf != null) {
            methodVisitor.visitLabel(labelIf);
        }
        methodVisitor.visitLabel(labelEnd);
        Label labelFinal = new Label();
        methodVisitor.visitJumpInsn(167, labelFinal);
        methodVisitor.visitLabel(labelCatch);
        methodVisitor.visitVarInsn(58, 3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn(targetInfo.getPropertyName());
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(183, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(BeanDirectCopier.class), logCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
        methodVisitor.visitLabel(labelFinal);
    }
}

