/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.internal.AsmUtils;
import io.polaris.core.asm.reflect.AccessClassLoader;
import io.polaris.core.asm.reflect.AccessClassPool;
import io.polaris.core.asm.reflect.BeanPropertyInfo;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.SerializableFunction;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.Handle;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class BeanLambdaAccess<T> {
    private static final AccessClassPool<Class, BeanLambdaAccess> pool = new AccessClassPool();
    private static ILogger log = ILoggers.of(BeanLambdaAccess.class);
    private Map<String, BeanPropertyInfo> properties;
    private Map<String, Function<Object, Object>> propertyGetters = Collections.unmodifiableMap(this.buildPropertyGetters());
    private Map<String, BiConsumer<Object, Object>> propertySetters = Collections.unmodifiableMap(this.buildPropertySetters());
    private Map<String, Function<Object, Object>> fieldGetters = Collections.unmodifiableMap(this.buildFieldGetters());
    private Map<String, BiConsumer<Object, Object>> fieldSetters = Collections.unmodifiableMap(this.buildFieldSetters());

    protected BeanLambdaAccess() {
    }

    protected Map<String, Function<Object, Object>> buildPropertyGetters() {
        return Collections.emptyMap();
    }

    protected Map<String, BiConsumer<Object, Object>> buildPropertySetters() {
        return Collections.emptyMap();
    }

    protected Map<String, Function<Object, Object>> buildFieldGetters() {
        return Collections.emptyMap();
    }

    protected Map<String, BiConsumer<Object, Object>> buildFieldSetters() {
        return Collections.emptyMap();
    }

    public Map<String, BeanPropertyInfo> properties() {
        return this.properties;
    }

    public boolean containsAny(String property) {
        return this.properties.containsKey(property);
    }

    public Set<String> allPropertyNames() {
        return this.properties.keySet();
    }

    public Type propertyGenericType(String property) {
        BeanPropertyInfo info = this.properties.get(property);
        return info == null ? null : info.getPropertyGenericType();
    }

    public Type propertyType(String property) {
        BeanPropertyInfo info = this.properties.get(property);
        return info == null ? null : info.getPropertyType();
    }

    public boolean containsSetterOrField(String key) {
        BeanPropertyInfo info = this.properties.get(key);
        if (info != null) {
            return info.getField() != null || info.getWriteMethod() != null;
        }
        return false;
    }

    public boolean containsGetterOrField(String key) {
        BeanPropertyInfo info = this.properties.get(key);
        if (info != null) {
            return info.getField() != null || info.getReadMethod() != null;
        }
        return false;
    }

    public boolean setPropertyOrField(Object o, String key, Object val) {
        BiConsumer<Object, Object> setter = this.getSetter(key);
        if (setter != null) {
            setter.accept(o, val);
            return true;
        }
        setter = this.getFieldSetter(key);
        if (setter != null) {
            setter.accept(o, val);
            return true;
        }
        return false;
    }

    public boolean setPropertyOrField(Object o, String key, Object val, BiFunction<Type, Object, Object> converter) {
        BeanPropertyInfo info = this.properties.get(key);
        if (info == null) {
            return false;
        }
        Type type = info.getPropertyGenericType();
        if (info.getField() != null) {
            this.setField(o, key, converter.apply(type, val));
            return true;
        }
        if (info.getWriteMethod() != null) {
            this.setProperty(o, key, converter.apply(type, val));
            return true;
        }
        return false;
    }

    public boolean containsSetter(String property) {
        return this.propertySetters.containsKey(property);
    }

    public Map<String, BiConsumer<Object, Object>> propertySetters() {
        return this.propertySetters;
    }

    public Set<String> setterPropertyNames() {
        return this.propertySetters.keySet();
    }

    public BiConsumer<Object, Object> getSetter(String property) {
        return this.propertySetters.get(property);
    }

    public void setProperty(Object o, String property, Object val) {
        BiConsumer<Object, Object> consumer = this.getSetter(property);
        if (consumer == null) {
            throw new IllegalArgumentException("Method not found");
        }
        consumer.accept(o, val);
    }

    public void setPropertyOrNoop(Object o, String property, Object val) {
        BiConsumer<Object, Object> consumer = this.getSetter(property);
        if (consumer == null) {
            return;
        }
        consumer.accept(o, val);
    }

    public boolean containsGetter(String property) {
        return this.propertyGetters.containsKey(property);
    }

    public Map<String, Function<Object, Object>> propertyGetters() {
        return this.propertyGetters;
    }

    public Set<String> getterPropertyNames() {
        return this.propertyGetters.keySet();
    }

    public Function<Object, Object> getGetter(String property) {
        return this.propertyGetters.get(property);
    }

    public Object getProperty(Object o, String property) {
        Function<Object, Object> function = this.getGetter(property);
        if (function == null) {
            throw new IllegalArgumentException("Method not found");
        }
        return function.apply(o);
    }

    public Object getPropertyOrNoop(Object o, String property) {
        Function<Object, Object> function = this.getGetter(property);
        if (function == null) {
            return null;
        }
        return function.apply(o);
    }

    public boolean containsField(String property) {
        return this.fieldGetters.containsKey(property);
    }

    public Map<String, Function<Object, Object>> fieldGetters() {
        return this.fieldGetters;
    }

    public Map<String, BiConsumer<Object, Object>> fieldSetters() {
        return this.fieldSetters;
    }

    public Set<String> fieldNames() {
        return this.fieldGetters.keySet();
    }

    public BiConsumer<Object, Object> getFieldSetter(String property) {
        return this.fieldSetters.get(property);
    }

    public Function<Object, Object> getFieldGetter(String property) {
        return this.fieldGetters.get(property);
    }

    public void setField(Object o, String property, Object val) {
        BiConsumer<Object, Object> consumer = this.getFieldSetter(property);
        if (consumer == null) {
            throw new IllegalArgumentException("Field not found");
        }
        consumer.accept(o, val);
    }

    public Object getField(Object o, String property) {
        Function<Object, Object> function = this.getFieldGetter(property);
        if (function == null) {
            throw new IllegalArgumentException("Field not found");
        }
        return function.apply(o);
    }

    public void setFieldOrNoop(Object o, String property, Object val) {
        BiConsumer<Object, Object> consumer = this.getFieldSetter(property);
        if (consumer == null) {
            return;
        }
        consumer.accept(o, val);
    }

    public Object getFieldOrNoop(Object o, String property) {
        Function<Object, Object> function = this.getFieldGetter(property);
        if (function == null) {
            return null;
        }
        return function.apply(o);
    }

    public static <T> BeanLambdaAccess<T> get(Class<T> type) {
        return pool.computeIfAbsent(type, BeanLambdaAccess::create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> BeanLambdaAccess<T> create(Class<T> type) {
        BeanLambdaAccess access;
        Class accessClass;
        AccessClassLoader loader;
        BeanPropertyInfo.Classification classification = BeanPropertyInfo.classify(type);
        String accessClassName = AccessClassLoader.buildAccessClassName(type, BeanLambdaAccess.class);
        AccessClassLoader accessClassLoader = loader = AccessClassLoader.get(type);
        synchronized (accessClassLoader) {
            accessClass = loader.loadAccessClass(accessClassName);
            if (accessClass == null) {
                accessClass = BeanLambdaAccess.buildAccessClass(loader, accessClassName, type, classification);
            }
        }
        try {
            access = (BeanLambdaAccess)accessClass.newInstance();
            access.properties = Collections.unmodifiableMap(classification.properties);
        }
        catch (Throwable t) {
            throw new IllegalStateException("\u521b\u5efa\u8bbf\u95ee\u7c7b\u5931\u8d25: " + accessClassName, t);
        }
        return access;
    }

    private static <T> Class buildAccessClass(AccessClassLoader loader, String accessClassName, Class<T> type, BeanPropertyInfo.Classification classification) {
        String accessClassNameInternal = accessClassName.replace('.', '/');
        String classNameInternal = type.getName().replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        String superClassNameInternal = BeanLambdaAccess.class.getName().replace('.', '/');
        cw.visit(52, 33, accessClassNameInternal, "L" + superClassNameInternal + "<L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";>;", superClassNameInternal, null);
        cw.visitInnerClass("java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/MethodHandles", "Lookup", 25);
        AsmUtils.insertDefaultConstructor(cw, superClassNameInternal);
        BeanLambdaAccess.insertSetterInvokers(cw, accessClassNameInternal, type, classification.setters);
        BeanLambdaAccess.insertGetterInvokers(cw, accessClassNameInternal, type, classification.getters);
        BeanLambdaAccess.insertFieldSetterInvokers(cw, accessClassNameInternal, type, classification.fields);
        BeanLambdaAccess.insertFieldGetterInvokers(cw, accessClassNameInternal, type, classification.fields);
        cw.visitEnd();
        byte[] byteArray = cw.toByteArray();
        return loader.defineAccessClass(accessClassName, byteArray);
    }

    private static <T> void insertSetterInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type, List<BeanPropertyInfo> setters) {
        if (setters.isEmpty()) {
            return;
        }
        SerializableFunction buildPropertySetters = BeanLambdaAccess::buildPropertySetters;
        String lambdaPrefixOfMethods = "lambda$" + buildPropertySetters.serialized().getImplMethodName() + "$";
        MethodVisitor methodVisitor = cw.visitMethod(4, buildPropertySetters.serialized().getImplMethodName(), "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/util/function/BiConsumer<Ljava/lang/Object;Ljava/lang/Object;>;>;", null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        for (int i = 0; i < setters.size(); ++i) {
            BeanPropertyInfo info = setters.get(i);
            Method method = info.getWriteMethod();
            String name = info.getPropertyName();
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            String lambdaName = lambdaPrefixOfMethods + methodName + "$" + i;
            methodVisitor.visitInvokeDynamicInsn("accept", "()Ljava/util/function/BiConsumer;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), io.polaris.dependency.org.objectweb.asm.Type.getType("(Ljava/lang/Object;Ljava/lang/Object;)V"), new Handle(6, accessClassNameInternal, lambdaName, "(Ljava/lang/Object;Ljava/lang/Object;)V", false), io.polaris.dependency.org.objectweb.asm.Type.getType("(Ljava/lang/Object;Ljava/lang/Object;)V"));
            methodVisitor.visitVarInsn(58, 2);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(name);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            methodVisitor.visitInsn(87);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        for (int i = 0; i < setters.size(); ++i) {
            BeanPropertyInfo info = setters.get(i);
            Method method = info.getWriteMethod();
            String name = info.getPropertyName();
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            String lambdaName = lambdaPrefixOfMethods + methodName + "$" + i;
            boolean hasThrows = method.getExceptionTypes().length > 0;
            MethodVisitor mv = cw.visitMethod(4106, lambdaName, "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
            mv.visitCode();
            Label labelStart = new Label();
            Label labelEnd = new Label();
            Label labelCatch = new Label();
            if (hasThrows) {
                mv.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                mv.visitLabel(labelStart);
            }
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
            if (Modifier.isStatic(method.getModifiers())) {
                mv.visitInsn(87);
            }
            mv.visitVarInsn(25, 1);
            Class<?> parameterType = parameterTypes[0];
            io.polaris.dependency.org.objectweb.asm.Type paramType = io.polaris.dependency.org.objectweb.asm.Type.getType(parameterType);
            AsmUtils.autoUnBoxing(mv, paramType);
            Class<?> declaringClass = method.getDeclaringClass();
            boolean isInterface = declaringClass.isInterface();
            int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : 182);
            mv.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass), methodName, io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(method), isInterface);
            Class<?> returnType = method.getReturnType();
            AsmUtils.autoBoxing(mv, returnType);
            if (hasThrows) {
                mv.visitLabel(labelEnd);
            }
            mv.visitInsn(177);
            if (hasThrows) {
                mv.visitLabel(labelCatch);
                mv.visitVarInsn(58, 2);
                mv.visitTypeInsn(187, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(IllegalArgumentException.class));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(IllegalArgumentException.class), "<init>", "(Ljava/lang/Throwable;)V", false);
                mv.visitInsn(191);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private static <T> void insertGetterInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type, List<BeanPropertyInfo> getters) {
        if (getters.isEmpty()) {
            return;
        }
        SerializableFunction buildPropertyGetters = BeanLambdaAccess::buildPropertyGetters;
        String lambdaPrefixOfMethods = "lambda$" + buildPropertyGetters.serialized().getImplMethodName() + "$";
        MethodVisitor methodVisitor = cw.visitMethod(4, buildPropertyGetters.serialized().getImplMethodName(), "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/util/function/Function<Ljava/lang/Object;Ljava/lang/Object;>;>;", null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        for (int i = 0; i < getters.size(); ++i) {
            BeanPropertyInfo info = getters.get(i);
            Method method = info.getReadMethod();
            String name = info.getPropertyName();
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            String lambdaName = lambdaPrefixOfMethods + methodName + "$" + i;
            methodVisitor.visitInvokeDynamicInsn("apply", "()Ljava/util/function/Function;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), io.polaris.dependency.org.objectweb.asm.Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, accessClassNameInternal, lambdaName, "(Ljava/lang/Object;)Ljava/lang/Object;", false), io.polaris.dependency.org.objectweb.asm.Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"));
            methodVisitor.visitVarInsn(58, 2);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(name);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            methodVisitor.visitInsn(87);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        for (int i = 0; i < getters.size(); ++i) {
            Class<?> declaringClass;
            boolean isInterface;
            BeanPropertyInfo info = getters.get(i);
            Method method = info.getReadMethod();
            String name = info.getPropertyName();
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            String lambdaName = lambdaPrefixOfMethods + methodName + "$" + i;
            boolean hasThrows = method.getExceptionTypes().length > 0;
            MethodVisitor mv = cw.visitMethod(4106, lambdaName, "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            Label labelStart = new Label();
            Label labelEnd = new Label();
            Label labelCatch = new Label();
            if (hasThrows) {
                mv.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                mv.visitLabel(labelStart);
            }
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
            if (Modifier.isStatic(method.getModifiers())) {
                mv.visitInsn(87);
            }
            int invokeOpcode = (isInterface = (declaringClass = method.getDeclaringClass()).isInterface()) ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : 182);
            mv.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass), methodName, io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(method), isInterface);
            Class<?> returnType = method.getReturnType();
            AsmUtils.autoBoxingForReturn(mv, returnType);
            if (hasThrows) {
                mv.visitLabel(labelEnd);
            }
            mv.visitInsn(176);
            if (hasThrows) {
                mv.visitLabel(labelCatch);
                mv.visitVarInsn(58, 2);
                mv.visitTypeInsn(187, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(IllegalArgumentException.class));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(IllegalArgumentException.class), "<init>", "(Ljava/lang/Throwable;)V", false);
                mv.visitInsn(191);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private static <T> void insertFieldSetterInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type, List<BeanPropertyInfo> fields) {
        if (fields.isEmpty()) {
            return;
        }
        SerializableFunction buildFieldSetters = BeanLambdaAccess::buildFieldSetters;
        BeanLambdaAccess._insertFieldSetterInvokers(cw, accessClassNameInternal, type, fields, buildFieldSetters);
    }

    private static <T> void insertFieldGetterInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type, List<BeanPropertyInfo> fields) {
        if (fields.isEmpty()) {
            return;
        }
        SerializableFunction buildFieldGetters = BeanLambdaAccess::buildFieldGetters;
        BeanLambdaAccess._insertFieldGetterInvokers(cw, accessClassNameInternal, type, fields, buildFieldGetters);
    }

    private static <T> void _insertFieldSetterInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type, List<BeanPropertyInfo> fields, SerializableFunction<BeanLambdaAccess, Map<String, BiConsumer<Object, Object>>> func) {
        String lambdaPrefixOfMethods = "lambda$" + func.serialized().getImplMethodName() + "$";
        MethodVisitor methodVisitor = cw.visitMethod(4, func.serialized().getImplMethodName(), "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/util/function/BiConsumer<Ljava/lang/Object;Ljava/lang/Object;>;>;", null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        for (int i = 0; i < fields.size(); ++i) {
            BeanPropertyInfo info = fields.get(i);
            Field field = info.getField();
            String name = field.getName();
            Class<?> fieldType = field.getType();
            String lambdaName = lambdaPrefixOfMethods + name + "$" + i;
            methodVisitor.visitInvokeDynamicInsn("accept", "()Ljava/util/function/BiConsumer;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), io.polaris.dependency.org.objectweb.asm.Type.getType("(Ljava/lang/Object;Ljava/lang/Object;)V"), new Handle(6, accessClassNameInternal, lambdaName, "(Ljava/lang/Object;Ljava/lang/Object;)V", false), io.polaris.dependency.org.objectweb.asm.Type.getType("(Ljava/lang/Object;Ljava/lang/Object;)V"));
            methodVisitor.visitVarInsn(58, 2);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(name);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            methodVisitor.visitInsn(87);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        for (int i = 0; i < fields.size(); ++i) {
            BeanPropertyInfo info = fields.get(i);
            Field field = info.getField();
            String name = field.getName();
            String lambdaName = lambdaPrefixOfMethods + name + "$" + i;
            MethodVisitor mv = cw.visitMethod(4106, lambdaName, "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
            if (Modifier.isStatic(field.getModifiers())) {
                mv.visitInsn(87);
            }
            mv.visitVarInsn(25, 1);
            io.polaris.dependency.org.objectweb.asm.Type fieldType = io.polaris.dependency.org.objectweb.asm.Type.getType(field.getType());
            AsmUtils.autoUnBoxing(mv, fieldType);
            if (Modifier.isStatic(field.getModifiers())) {
                mv.visitFieldInsn(179, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(field.getDeclaringClass()), name, fieldType.getDescriptor());
            } else {
                mv.visitFieldInsn(181, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(field.getDeclaringClass()), name, fieldType.getDescriptor());
            }
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
    }

    private static <T> void _insertFieldGetterInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type, List<BeanPropertyInfo> fields, SerializableFunction<BeanLambdaAccess, Map<String, Function<Object, Object>>> func) {
        String lambdaPrefixOfMethods = "lambda$" + func.serialized().getImplMethodName() + "$";
        MethodVisitor methodVisitor = cw.visitMethod(4, func.serialized().getImplMethodName(), "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/util/function/Function<Ljava/lang/Object;Ljava/lang/Object;>;>;", null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        for (int i = 0; i < fields.size(); ++i) {
            BeanPropertyInfo info = fields.get(i);
            Field field = info.getField();
            String name = field.getName();
            String lambdaName = lambdaPrefixOfMethods + name + "$" + i;
            methodVisitor.visitInvokeDynamicInsn("apply", "()Ljava/util/function/Function;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), io.polaris.dependency.org.objectweb.asm.Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, accessClassNameInternal, lambdaName, "(Ljava/lang/Object;)Ljava/lang/Object;", false), io.polaris.dependency.org.objectweb.asm.Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"));
            methodVisitor.visitVarInsn(58, 2);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(name);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            methodVisitor.visitInsn(87);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        for (int i = 0; i < fields.size(); ++i) {
            BeanPropertyInfo info = fields.get(i);
            Field field = info.getField();
            String name = field.getName();
            String lambdaName = lambdaPrefixOfMethods + name + "$" + i;
            MethodVisitor mv = cw.visitMethod(4106, lambdaName, "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
            if (Modifier.isStatic(field.getModifiers())) {
                mv.visitInsn(87);
                mv.visitFieldInsn(178, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(field.getDeclaringClass()), name, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(field.getType()));
            } else {
                mv.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type), name, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(field.getType()));
            }
            io.polaris.dependency.org.objectweb.asm.Type fieldType = io.polaris.dependency.org.objectweb.asm.Type.getType(field.getType());
            AsmUtils.autoBoxing(mv, fieldType);
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }
}

