/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.internal.AsmUtils;
import io.polaris.core.asm.reflect.AccessClassLoader;
import io.polaris.core.asm.reflect.BeanCopier;
import io.polaris.core.asm.reflect.BeanPropertyInfo;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.map.Maps;
import io.polaris.core.reflect.SerializableBiFunction;
import io.polaris.core.reflect.SerializableConsumer;
import io.polaris.core.reflect.SerializableConsumerWithArgs4;
import io.polaris.core.reflect.SerializableConsumerWithArgs5;
import io.polaris.core.reflect.SerializableFunction;
import io.polaris.core.reflect.SerializableTriFunction;
import io.polaris.core.string.StringCases;
import io.polaris.core.tuple.Tuple2;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class BeanOptionsCopier<S, T> {
    private static ILogger log = ILoggers.of(BeanOptionsCopier.class);
    private static final String CLASS_NAME_PREFIX = "Options$";
    public static final String FIELD_PREFIX_TYPE = "type_";
    public static final String FIELD_PREFIX_CLASS = "class_";
    protected Class<T> targetType;
    protected BeanCopier<S> beanCopier;
    protected Map<String, BeanPropertyInfo> properties;

    protected final void copy(S source, T target, CopyOptions options) {
        LinkedHashSet<String> targetKeys = new LinkedHashSet<String>(this.properties.keySet());
        if (!targetKeys.isEmpty()) {
            this.copySameKeys(source, target, options, targetKeys);
        }
        if (options.ignoreCapitalize() && !targetKeys.isEmpty()) {
            this.copyCapitalizeKeys(source, target, options, targetKeys);
        }
        if (options.enableUnderlineToCamelCase() && !targetKeys.isEmpty()) {
            this.copyUnderlineToCamelKeys(source, target, options, targetKeys);
        }
        if (options.enableCamelToUnderlineCase() && !targetKeys.isEmpty()) {
            this.copyCamelToUnderlineKeys(source, target, options, targetKeys);
        }
        if (options.ignoreCase() && !targetKeys.isEmpty()) {
            this.copySameKeysIgnoreCase(source, target, options, targetKeys);
            if (options.enableUnderlineToCamelCase() && !targetKeys.isEmpty()) {
                this.copyUnderlineToCamelKeysIgnoreCase(source, target, options, targetKeys);
            }
            if (options.enableCamelToUnderlineCase() && !targetKeys.isEmpty()) {
                this.copyCamelToUnderlineKeysIgnoreCase(source, target, options, targetKeys);
            }
        }
    }

    protected abstract void initTypeFields();

    protected abstract void copySameKeys(S var1, T var2, CopyOptions var3, Set<String> var4);

    protected abstract void copyCapitalizeKeys(S var1, T var2, CopyOptions var3, Set<String> var4);

    protected abstract void copyUnderlineToCamelKeys(S var1, T var2, CopyOptions var3, Set<String> var4);

    protected abstract void copyCamelToUnderlineKeys(S var1, T var2, CopyOptions var3, Set<String> var4);

    protected abstract void copySameKeysIgnoreCase(S var1, T var2, CopyOptions var3, Set<String> var4);

    protected abstract void copyUnderlineToCamelKeysIgnoreCase(S var1, T var2, CopyOptions var3, Set<String> var4);

    protected abstract void copyCamelToUnderlineKeysIgnoreCase(S var1, T var2, CopyOptions var3, Set<String> var4);

    protected final void resolveCopyError(String propertyName, Throwable e, CopyOptions options) {
        String msg = "\u590d\u5236\u5c5e\u6027[" + propertyName + "]\u5931\u8d25";
        if (options.ignoreError()) {
            log.warn(msg + ": " + e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug(msg, e);
            }
        } else {
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected final Type getPropertyGenericType(String propertyName) {
        return this.properties.get(propertyName).getPropertyGenericType();
    }

    protected final Class<?> getPropertyType(String propertyName) {
        return this.properties.get(propertyName).getPropertyType();
    }

    static List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> buildCustomKeyMapping(Map<String, BeanPropertyInfo> sourceProperties, Map<String, BeanPropertyInfo> targetProperties, Function<String, String> mapper, boolean ignoreCase) {
        ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> list = new ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>>(sourceProperties.size());
        for (Map.Entry<String, BeanPropertyInfo> entry : sourceProperties.entrySet()) {
            String key = entry.getKey();
            String mapKey = mapper.apply(key);
            if (mapKey == null) continue;
            BeanPropertyInfo targetInfo = targetProperties.get(mapKey);
            BeanPropertyInfo sourceInfo = entry.getValue();
            if (targetInfo == null || !sourceInfo.hasGetter() || !targetInfo.hasSetter() || ignoreCase && key.equals(sourceInfo.getPropertyName())) continue;
            list.add(Tuple2.of(sourceInfo, targetInfo));
        }
        return list;
    }

    static List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> buildSameKeyMapping(Map<String, BeanPropertyInfo> sourceProperties, Map<String, BeanPropertyInfo> targetProperties, boolean ignoreCase) {
        ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> list = new ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>>(targetProperties.size());
        for (Map.Entry<String, BeanPropertyInfo> entry : targetProperties.entrySet()) {
            String key = entry.getKey();
            BeanPropertyInfo sourceInfo = sourceProperties.get(key);
            BeanPropertyInfo targetInfo = entry.getValue();
            if (sourceInfo == null || !sourceInfo.hasGetter() || !targetInfo.hasSetter() || ignoreCase && key.equals(sourceInfo.getPropertyName())) continue;
            list.add(Tuple2.of(sourceInfo, targetInfo));
        }
        return list;
    }

    static List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> buildCapitalizeKeyMapping(Map<String, BeanPropertyInfo> sourceProperties, Map<String, BeanPropertyInfo> targetProperties) {
        ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> list = new ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>>(targetProperties.size());
        for (Map.Entry<String, BeanPropertyInfo> entry : targetProperties.entrySet()) {
            String key = entry.getKey();
            if (key.length() <= 1) continue;
            String mapKey = Character.isUpperCase(key.charAt(0)) ? Character.toLowerCase(key.charAt(0)) + key.substring(1) : Character.toUpperCase(key.charAt(0)) + key.substring(1);
            BeanPropertyInfo sourceInfo = sourceProperties.get(mapKey);
            BeanPropertyInfo targetInfo = entry.getValue();
            if (sourceInfo == null || !sourceInfo.hasGetter() || !targetInfo.hasSetter()) continue;
            list.add(Tuple2.of(sourceInfo, targetInfo));
        }
        return list;
    }

    static List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> buildUnderlineToCamelKeyMapping(Map<String, BeanPropertyInfo> sourceProperties, Map<String, BeanPropertyInfo> targetProperties, boolean ignoreCase) {
        ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> list = new ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>>(targetProperties.size());
        for (Map.Entry<String, BeanPropertyInfo> entry : targetProperties.entrySet()) {
            String mapKey;
            String key = entry.getKey();
            if (key.equals(mapKey = StringCases.camelToUnderlineCase(key))) continue;
            BeanPropertyInfo sourceInfo = sourceProperties.get(mapKey);
            BeanPropertyInfo targetInfo = entry.getValue();
            if (sourceInfo == null || !sourceInfo.hasGetter() || !targetInfo.hasSetter() || ignoreCase && targetProperties.containsKey(mapKey)) continue;
            list.add(Tuple2.of(sourceInfo, targetInfo));
        }
        return list;
    }

    static List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> buildCamelToUnderlineKeyMapping(Map<String, BeanPropertyInfo> sourceProperties, Map<String, BeanPropertyInfo> targetProperties, boolean ignoreCase) {
        ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> list = new ArrayList<Tuple2<BeanPropertyInfo, BeanPropertyInfo>>(targetProperties.size());
        for (Map.Entry<String, BeanPropertyInfo> entry : targetProperties.entrySet()) {
            String key = entry.getKey();
            if (key.indexOf(95) < 0) continue;
            String mapKey = StringCases.underlineToCamelCase(key);
            BeanPropertyInfo sourceInfo = sourceProperties.get(mapKey);
            BeanPropertyInfo targetInfo = entry.getValue();
            if (sourceInfo == null || !sourceInfo.hasGetter() || !targetInfo.hasSetter() || ignoreCase && targetProperties.containsKey(mapKey)) continue;
            list.add(Tuple2.of(sourceInfo, targetInfo));
        }
        return list;
    }

    static <S, T> BeanOptionsCopier<S, T> create(BeanCopier<S> beanCopier, Class<T> targetType) {
        BeanPropertyInfo.Classification classification = BeanPropertyInfo.classify(targetType);
        String accessClassName = beanCopier.getClass().getName() + CLASS_NAME_PREFIX + targetType.getName().replace("_", "__").replace('.', '_');
        AccessClassLoader loader = AccessClassLoader.get(targetType);
        Class accessClass = loader.loadOrDefineClass(accessClassName, () -> BeanOptionsCopier.buildOptionsCopierClass(loader, beanCopier, accessClassName, targetType, classification));
        try {
            BeanOptionsCopier access = (BeanOptionsCopier)accessClass.newInstance();
            access.targetType = targetType;
            access.beanCopier = beanCopier;
            access.properties = Collections.unmodifiableMap(classification.properties);
            access.initTypeFields();
            return access;
        }
        catch (Throwable t) {
            throw new IllegalStateException("\u521b\u5efa\u8bbf\u95ee\u7c7b\u5931\u8d25: " + accessClassName, t);
        }
    }

    private static <S, T> byte[] buildOptionsCopierClass(AccessClassLoader loader, BeanCopier<S> beanCopier, String accessClassName, Class<T> type, BeanPropertyInfo.Classification classification) {
        Map<String, BeanPropertyInfo> targetProperties = classification.properties;
        Map<String, BeanPropertyInfo> sourceProperties = beanCopier.properties;
        Map<String, BeanPropertyInfo> sourceUpperProperties = Maps.newUpperCaseLinkedHashMap();
        sourceUpperProperties.putAll(sourceProperties);
        List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> sameKeyMapping = BeanOptionsCopier.buildSameKeyMapping(sourceProperties, targetProperties, false);
        List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> capitalizeKeyMapping = BeanOptionsCopier.buildCapitalizeKeyMapping(sourceProperties, targetProperties);
        List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> underlineToCamelKeyMapping = BeanOptionsCopier.buildUnderlineToCamelKeyMapping(sourceProperties, targetProperties, false);
        List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> camelToUnderlineKeyMapping = BeanOptionsCopier.buildCamelToUnderlineKeyMapping(sourceProperties, targetProperties, false);
        List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> sameKeyMappingIgnoreCase = BeanOptionsCopier.buildSameKeyMapping(sourceUpperProperties, targetProperties, true);
        List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> underlineToCamelKeyMappingIgnoreCase = BeanOptionsCopier.buildUnderlineToCamelKeyMapping(sourceUpperProperties, targetProperties, true);
        List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> camelToUnderlineKeyMappingIgnoreCase = BeanOptionsCopier.buildCamelToUnderlineKeyMapping(sourceUpperProperties, targetProperties, true);
        String accessClassNameInternal = accessClassName.replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        String superClassNameInternal = io.polaris.dependency.org.objectweb.asm.Type.getInternalName(BeanOptionsCopier.class);
        cw.visit(52, 33, accessClassNameInternal, "L" + superClassNameInternal + "<L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(beanCopier.sourceType) + ";L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";>;", superClassNameInternal, null);
        cw.visitInnerClass("java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/MethodHandles", "Lookup", 25);
        AsmUtils.insertDefaultConstructor(cw, superClassNameInternal);
        BeanOptionsCopier.insertInitTypeFields(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanOptionsCopier.insertCopyKeysMethod(cw, beanCopier, superClassNameInternal, accessClassNameInternal, type, sameKeyMapping, BeanOptionsCopier::copySameKeys);
        BeanOptionsCopier.insertCopyKeysMethod(cw, beanCopier, superClassNameInternal, accessClassNameInternal, type, capitalizeKeyMapping, BeanOptionsCopier::copyCapitalizeKeys);
        BeanOptionsCopier.insertCopyKeysMethod(cw, beanCopier, superClassNameInternal, accessClassNameInternal, type, underlineToCamelKeyMapping, BeanOptionsCopier::copyUnderlineToCamelKeys);
        BeanOptionsCopier.insertCopyKeysMethod(cw, beanCopier, superClassNameInternal, accessClassNameInternal, type, camelToUnderlineKeyMapping, BeanOptionsCopier::copyCamelToUnderlineKeys);
        BeanOptionsCopier.insertCopyKeysMethod(cw, beanCopier, superClassNameInternal, accessClassNameInternal, type, sameKeyMappingIgnoreCase, BeanOptionsCopier::copySameKeysIgnoreCase);
        BeanOptionsCopier.insertCopyKeysMethod(cw, beanCopier, superClassNameInternal, accessClassNameInternal, type, underlineToCamelKeyMappingIgnoreCase, BeanOptionsCopier::copyUnderlineToCamelKeysIgnoreCase);
        BeanOptionsCopier.insertCopyKeysMethod(cw, beanCopier, superClassNameInternal, accessClassNameInternal, type, camelToUnderlineKeyMappingIgnoreCase, BeanOptionsCopier::copyCamelToUnderlineKeysIgnoreCase);
        cw.visitEnd();
        byte[] byteArray = cw.toByteArray();
        return byteArray;
    }

    private static <T> void insertInitTypeFields(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableConsumer init = BeanOptionsCopier::initTypeFields;
        SerializableBiFunction getPropertyGenericType = BeanOptionsCopier::getPropertyGenericType;
        SerializableBiFunction getPropertyType = BeanOptionsCopier::getPropertyType;
        BeanCopier.insertInitTypes(cw, superClassNameInternal, accessClassNameInternal, classification, init.serialized().getImplMethodName(), getPropertyGenericType.serialized().getImplMethodName(), getPropertyType.serialized().getImplMethodName());
    }

    private static <S, T> void insertCopyKeysMethod(ClassWriter cw, BeanCopier<S> beanCopier, String superClassNameInternal, String accessClassNameInternal, Class<T> type, List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> keyMapping, SerializableConsumerWithArgs5<BeanOptionsCopier, Object, Object, CopyOptions, Set<String>> copyKeysMethod) {
        String copyKeysMethodName = copyKeysMethod.serialized().getImplMethodName();
        keyMapping.forEach(tuple -> BeanOptionsCopier.insertCopyKeysSubMethod(cw, beanCopier, superClassNameInternal, accessClassNameInternal, type, (BeanPropertyInfo)tuple.getFirst(), (BeanPropertyInfo)tuple.getSecond(), copyKeysMethod));
        MethodVisitor methodVisitor = cw.visitMethod(4, copyKeysMethodName, "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(beanCopier.sourceType) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(Set.class) + ")V", "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(beanCopier.sourceType) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set<Ljava/lang/String;>;)V", null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        keyMapping.forEach(tuple -> {
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitMethodInsn(185, "java/util/Set", "isEmpty", "()Z", true);
            methodVisitor.visitJumpInsn(154, label0);
            String subMethodName = copyKeysMethodName + "$" + ((BeanPropertyInfo)tuple.getFirst()).getPropertyName() + "$" + ((BeanPropertyInfo)tuple.getSecond()).getPropertyName();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitMethodInsn(182, accessClassNameInternal, subMethodName, "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(beanCopier.sourceType) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(Set.class) + ")V", false);
        });
        methodVisitor.visitLabel(label0);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(4, 8);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4164, copyKeysMethodName, "(Ljava/lang/Object;Ljava/lang/Object;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(beanCopier.sourceType));
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitMethodInsn(182, accessClassNameInternal, copyKeysMethodName, "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(beanCopier.sourceType) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(Set.class) + ")V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(5, 5);
        methodVisitor.visitEnd();
    }

    private static <S, T> void insertCopyKeysSubMethod(ClassWriter cw, BeanCopier<S> beanCopier, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo sourceInfo, BeanPropertyInfo targetInfo, SerializableConsumerWithArgs5<BeanOptionsCopier, Object, Object, CopyOptions, Set<String>> copyKeysMethod) {
        String methodName = copyKeysMethod.serialized().getImplMethodName() + "$" + sourceInfo.getPropertyName() + "$" + targetInfo.getPropertyName();
        MethodVisitor methodVisitor = cw.visitMethod(2, methodName, "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(beanCopier.sourceType) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(Set.class) + ")V", "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(beanCopier.sourceType) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set<Ljava/lang/String;>;)V", null);
        methodVisitor.visitCode();
        BeanOptionsCopier.insertCopyKeysSubMethodCode(methodVisitor, beanCopier, superClassNameInternal, accessClassNameInternal, type, sourceInfo, targetInfo);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(4, 8);
        methodVisitor.visitEnd();
    }

    private static <S, T> void insertCopyKeysSubMethodCode(MethodVisitor methodVisitor, BeanCopier<S> beanCopier, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo sourceInfo, BeanPropertyInfo targetInfo) {
        Class<?> var7Class;
        Label label0 = new Label();
        Label label1 = new Label();
        Label label2 = new Label();
        methodVisitor.visitTryCatchBlock(label0, label1, label2, "java/lang/Throwable");
        Label label3 = new Label();
        Label label4 = new Label();
        methodVisitor.visitTryCatchBlock(label3, label4, label2, "java/lang/Throwable");
        Label label5 = new Label();
        Label label6 = new Label();
        methodVisitor.visitTryCatchBlock(label5, label6, label2, "java/lang/Throwable");
        Label label7 = new Label();
        Label label8 = new Label();
        methodVisitor.visitTryCatchBlock(label7, label8, label2, "java/lang/Throwable");
        Label label9 = new Label();
        Label label10 = new Label();
        methodVisitor.visitTryCatchBlock(label9, label10, label2, "java/lang/Throwable");
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLdcInsn(sourceInfo.getPropertyName());
        methodVisitor.visitVarInsn(58, 5);
        methodVisitor.visitLdcInsn(targetInfo.getPropertyName());
        methodVisitor.visitVarInsn(58, 6);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 5);
        SerializableBiFunction isIgnoredKey = CopyOptions::isIgnoredKey;
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), isIgnoredKey.serialized().getImplMethodName(), "(Ljava/lang/String;)Z", false);
        methodVisitor.visitJumpInsn(154, label1);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z", true);
        methodVisitor.visitJumpInsn(154, label3);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label3);
        if (targetInfo.hasGetter()) {
            Class<?> var7Class2;
            methodVisitor.visitVarInsn(25, 3);
            SerializableFunction override = CopyOptions::override;
            methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), override.serialized().getImplMethodName(), "()Z", false);
            methodVisitor.visitJumpInsn(154, label5);
            methodVisitor.visitVarInsn(25, 2);
            if (targetInfo.getField() != null) {
                var7Class2 = targetInfo.getField().getType();
                methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(targetInfo.getField().getDeclaringClass()), targetInfo.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(var7Class2));
                AsmUtils.autoBoxing(methodVisitor, var7Class2);
            } else {
                var7Class2 = targetInfo.getReadMethod().getReturnType();
                boolean isInterface = targetInfo.getReadMethod().getDeclaringClass().isInterface();
                methodVisitor.visitMethodInsn(isInterface ? 185 : 182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(targetInfo.getReadMethod().getDeclaringClass()), targetInfo.getReadMethod().getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(targetInfo.getReadMethod()), isInterface);
                AsmUtils.autoBoxing(methodVisitor, var7Class2);
            }
            methodVisitor.visitVarInsn(58, 7);
            methodVisitor.visitVarInsn(25, 7);
            methodVisitor.visitJumpInsn(198, label5);
        } else {
            methodVisitor.visitJumpInsn(167, label5);
        }
        methodVisitor.visitLabel(label4);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label5);
        methodVisitor.visitVarInsn(25, 1);
        if (sourceInfo.getField() != null) {
            var7Class = sourceInfo.getField().getType();
            methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(sourceInfo.getField().getDeclaringClass()), sourceInfo.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(var7Class));
            AsmUtils.autoBoxing(methodVisitor, var7Class);
        } else {
            var7Class = sourceInfo.getReadMethod().getReturnType();
            boolean isInterface = sourceInfo.getReadMethod().getDeclaringClass().isInterface();
            methodVisitor.visitMethodInsn(isInterface ? 185 : 182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(sourceInfo.getReadMethod().getDeclaringClass()), sourceInfo.getReadMethod().getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(sourceInfo.getReadMethod()), isInterface);
            AsmUtils.autoBoxing(methodVisitor, var7Class);
        }
        methodVisitor.visitVarInsn(58, 7);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitJumpInsn(199, label7);
        methodVisitor.visitVarInsn(25, 3);
        SerializableFunction ignoreNull = CopyOptions::ignoreNull;
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), ignoreNull.serialized().getImplMethodName(), "()Z", false);
        methodVisitor.visitJumpInsn(153, label7);
        methodVisitor.visitLabel(label6);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label7);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitVarInsn(25, 7);
        SerializableTriFunction<CopyOptions, String, Object, Object> editValue = CopyOptions::editValue;
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), editValue.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(58, 7);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, accessClassNameInternal, FIELD_PREFIX_TYPE + targetInfo.getPropertyName(), "Ljava/lang/reflect/Type;");
        methodVisitor.visitVarInsn(25, 7);
        SerializableTriFunction<CopyOptions, Type, Object, Object> convert = CopyOptions::convert;
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), convert.serialized().getImplMethodName(), "(Ljava/lang/reflect/Type;Ljava/lang/Object;)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(58, 7);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitJumpInsn(199, label9);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), ignoreNull.serialized().getImplMethodName(), "()Z", false);
        methodVisitor.visitJumpInsn(154, label8);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, accessClassNameInternal, FIELD_PREFIX_CLASS + targetInfo.getPropertyName(), "Ljava/lang/Class;");
        methodVisitor.visitMethodInsn(182, "java/lang/Class", "isPrimitive", "()Z", false);
        methodVisitor.visitJumpInsn(153, label9);
        methodVisitor.visitLabel(label8);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label9);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, accessClassNameInternal, FIELD_PREFIX_CLASS + targetInfo.getPropertyName(), "Ljava/lang/Class;");
        SerializableFunction getWrapperClass = Types::getWrapperClass;
        methodVisitor.visitMethodInsn(184, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(Types.class), getWrapperClass.serialized().getImplMethodName(), "(Ljava/lang/Class;)Ljava/lang/Class;", false);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitMethodInsn(182, "java/lang/Class", "isInstance", "(Ljava/lang/Object;)Z", false);
        methodVisitor.visitJumpInsn(153, label10);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 7);
        AsmUtils.autoUnBoxing(methodVisitor, targetInfo.getPropertyType());
        if (targetInfo.getField() != null) {
            methodVisitor.visitFieldInsn(181, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(targetInfo.getField().getDeclaringClass()), targetInfo.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(targetInfo.getField().getType()));
        } else {
            boolean isInterface = targetInfo.getWriteMethod().getDeclaringClass().isInterface();
            methodVisitor.visitMethodInsn(isInterface ? 185 : 182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(targetInfo.getWriteMethod().getDeclaringClass()), targetInfo.getWriteMethod().getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(targetInfo.getWriteMethod()), isInterface);
        }
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "remove", "(Ljava/lang/Object;)Z", true);
        methodVisitor.visitInsn(87);
        methodVisitor.visitLabel(label10);
        Label label11 = new Label();
        methodVisitor.visitJumpInsn(167, label11);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(58, 5);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn(sourceInfo.getPropertyName() + "->" + targetInfo.getPropertyName());
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitVarInsn(25, 3);
        SerializableConsumerWithArgs4<BeanOptionsCopier, String, Throwable, CopyOptions> resolveCopyError = BeanOptionsCopier::resolveCopyError;
        methodVisitor.visitMethodInsn(183, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(BeanOptionsCopier.class), resolveCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + ")V", false);
        methodVisitor.visitLabel(label11);
    }
}

