/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.internal.AsmUtils;
import io.polaris.core.asm.reflect.AccessClassLoader;
import io.polaris.core.asm.reflect.AccessClassPool;
import io.polaris.core.collection.Iterables;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import io.polaris.dependency.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class MethodAccess {
    private static final AccessClassPool<Class, MethodAccess> pool = new AccessClassPool();
    private String[] methodNames;
    private Class[][] parameterTypes;
    private Class[] returnTypes;
    private java.lang.reflect.Type[][] genericParameterTypes;
    private java.lang.reflect.Type[] genericReturnTypes;

    public abstract Object invoke(Object var1, int var2, Object ... var3);

    public Object invoke(Object object, String methodName, Class[] paramTypes, Object ... args) {
        return this.invoke(object, this.getIndex(methodName, paramTypes), args);
    }

    public Object invoke(Object object, String methodName, Object ... args) {
        return this.invoke(object, this.getIndex(methodName, args == null ? 0 : args.length), args);
    }

    public int getIndex(String methodName) {
        int n = this.methodNames.length;
        for (int i = 0; i < n; ++i) {
            if (!this.methodNames[i].equals(methodName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unable to find non-private method: " + methodName);
    }

    public int getIndex(String methodName, Class ... paramTypes) {
        int n = this.methodNames.length;
        for (int i = 0; i < n; ++i) {
            if (!this.methodNames[i].equals(methodName) || !Arrays.equals(paramTypes, this.parameterTypes[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Unable to find non-private method: " + methodName + " " + Arrays.toString(paramTypes));
    }

    public int getIndex(String methodName, int paramsCount) {
        int n = this.methodNames.length;
        for (int i = 0; i < n; ++i) {
            if (!this.methodNames[i].equals(methodName) || this.parameterTypes[i].length != paramsCount) continue;
            return i;
        }
        throw new IllegalArgumentException("Unable to find non-private method: " + methodName + " with " + paramsCount + " params.");
    }

    public List<String> getMethodNames() {
        return Iterables.asList(this.methodNames);
    }

    public List<Class[]> getParameterTypes() {
        return Iterables.asList(this.parameterTypes);
    }

    public List<java.lang.reflect.Type[]> getGenericParameterTypes() {
        return Iterables.asList(this.genericParameterTypes);
    }

    public List<Class> getReturnTypes() {
        return Iterables.asList(this.returnTypes);
    }

    public List<java.lang.reflect.Type> getGenericReturnTypes() {
        return Iterables.asList(this.genericReturnTypes);
    }

    public static MethodAccess get(Class type) {
        return pool.computeIfAbsent(type, MethodAccess::create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodAccess create(Class type) {
        Class accessClass;
        AccessClassLoader loader;
        boolean isInterface = type.isInterface();
        if (!isInterface && type.getSuperclass() == null && type != Object.class) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u57fa\u672c\u6570\u636e\u7c7b\u578b\u6216void\u7c7b\u578b");
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        if (!isInterface) {
            for (Class nextClass = type; nextClass != null && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
                MethodAccess.addDeclaredMethodsToList(nextClass, methods);
            }
        } else {
            MethodAccess.recursiveAddInterfaceMethodsToList(type, methods);
        }
        int n = methods.size();
        String[] methodNames = new String[n];
        Class[][] parameterTypes = new Class[n][];
        java.lang.reflect.Type[][] genericParameterTypes = new java.lang.reflect.Type[n][];
        java.lang.reflect.Type[] genericReturnTypes = new java.lang.reflect.Type[n];
        Class[] returnTypes = new Class[n];
        for (int i = 0; i < n; ++i) {
            Method method = methods.get(i);
            methodNames[i] = method.getName();
            genericParameterTypes[i] = method.getGenericParameterTypes();
            parameterTypes[i] = method.getParameterTypes();
            genericReturnTypes[i] = method.getGenericReturnType();
            returnTypes[i] = method.getReturnType();
        }
        String accessClassName = AccessClassLoader.buildAccessClassName(type, MethodAccess.class);
        AccessClassLoader accessClassLoader = loader = AccessClassLoader.get(type);
        synchronized (accessClassLoader) {
            accessClass = loader.loadAccessClass(accessClassName);
            if (accessClass == null) {
                String accessClassNameInternal = accessClassName.replace('.', '/');
                String classNameInternal = type.getName().replace('.', '/');
                ClassWriter cw = new ClassWriter(2);
                cw.visit(52, 33, accessClassNameInternal, null, MethodAccess.class.getName().replace('.', '/'), null);
                MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, MethodAccess.class.getName().replace('.', '/'), "<init>", "()V");
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
                mv = cw.visitMethod(129, "invoke", "(Ljava/lang/Object;I[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
                mv.visitCode();
                if (!methods.isEmpty()) {
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, classNameInternal);
                    mv.visitVarInsn(58, 4);
                    mv.visitVarInsn(21, 2);
                    Label[] labels = new Label[n];
                    for (int i = 0; i < n; ++i) {
                        labels[i] = new Label();
                    }
                    Label defaultLabel = new Label();
                    mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
                    StringBuilder buffer = new StringBuilder(128);
                    for (int i = 0; i < n; ++i) {
                        mv.visitLabel(labels[i]);
                        if (i == 0) {
                            mv.visitFrame(1, 1, new Object[]{classNameInternal}, 0, null);
                        } else {
                            mv.visitFrame(3, 0, null, 0, null);
                        }
                        mv.visitVarInsn(25, 4);
                        buffer.setLength(0);
                        buffer.append('(');
                        Class[] paramTypes = parameterTypes[i];
                        Class returnType = returnTypes[i];
                        for (int paramIndex = 0; paramIndex < paramTypes.length; ++paramIndex) {
                            mv.visitVarInsn(25, 3);
                            mv.visitIntInsn(16, paramIndex);
                            mv.visitInsn(50);
                            Type paramType = Type.getType(paramTypes[paramIndex]);
                            AsmUtils.autoUnBoxing(mv, paramType);
                            buffer.append(paramType.getDescriptor());
                        }
                        buffer.append(')');
                        buffer.append(Type.getDescriptor(returnType));
                        int invoke = isInterface ? 185 : (Modifier.isStatic(methods.get(i).getModifiers()) ? 184 : 182);
                        mv.visitMethodInsn(invoke, classNameInternal, methodNames[i], buffer.toString());
                        AsmUtils.autoBoxingForReturn(mv, Type.getType(returnType));
                        mv.visitInsn(176);
                    }
                    mv.visitLabel(defaultLabel);
                    mv.visitFrame(3, 0, null, 0, null);
                }
                mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
                mv.visitInsn(89);
                mv.visitTypeInsn(187, "java/lang/StringBuilder");
                mv.visitInsn(89);
                mv.visitLdcInsn("Method not found: ");
                mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
                mv.visitVarInsn(21, 2);
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
                mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
                mv.visitInsn(191);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
                cw.visitEnd();
                byte[] data = cw.toByteArray();
                accessClass = loader.defineAccessClass(accessClassName, data);
            }
        }
        try {
            MethodAccess access = (MethodAccess)accessClass.newInstance();
            access.methodNames = methodNames;
            access.parameterTypes = parameterTypes;
            access.genericParameterTypes = genericParameterTypes;
            access.returnTypes = returnTypes;
            access.genericReturnTypes = genericReturnTypes;
            return access;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error constructing method access class: " + accessClassName, t);
        }
    }

    private static void addDeclaredMethodsToList(Class type, ArrayList<Method> methods) {
        for (Method method : type.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers)) continue;
            methods.add(method);
        }
    }

    private static void recursiveAddInterfaceMethodsToList(Class interfaceType, ArrayList<Method> methods) {
        MethodAccess.addDeclaredMethodsToList(interfaceType, methods);
        for (Class<?> nextInterface : interfaceType.getInterfaces()) {
            MethodAccess.recursiveAddInterfaceMethodsToList(nextInterface, methods);
        }
    }
}

