/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.bloom;

import io.polaris.core.bloom.BloomFilter;
import io.polaris.core.hash.Hashing;
import java.util.function.Function;

public abstract class AbstractHashBloomFilter
implements BloomFilter {
    private static final Function<String, Integer> DEFAULT_HASH_FUNC = Hashing::javaHash;
    private final Function<String, Integer> hashFunction;
    protected final int hashCapacity;
    protected final int expectSize;

    public AbstractHashBloomFilter(int hashCapacity) {
        this(hashCapacity, 0);
    }

    protected AbstractHashBloomFilter(int hashCapacity, int expectSize) {
        this(null, hashCapacity, expectSize);
    }

    public AbstractHashBloomFilter(Function<String, Integer> hashFunction, int hashCapacity, int expectSize) {
        this.hashFunction = hashFunction == null ? DEFAULT_HASH_FUNC : hashFunction;
        this.hashCapacity = hashCapacity;
        this.expectSize = expectSize;
    }

    protected abstract boolean getBit(int var1);

    protected abstract void setBit(int var1);

    @Override
    public boolean contains(String data) {
        int hash = this.hash(data);
        return this.contains(hash);
    }

    @Override
    public boolean add(String data) {
        int hash = this.hash(data);
        if (this.contains(hash)) {
            return false;
        }
        this.setBit(hash);
        return true;
    }

    protected boolean contains(int hash) {
        return this.getBit(hash);
    }

    protected double estimateFnr() {
        if (this.expectSize <= 0) {
            return 0.0;
        }
        return Math.pow(1.0 - Math.exp(-((double)this.expectSize) / (double)this.hashCapacity), 1.0);
    }

    protected int hash(String data) {
        int hash = this.hashFunction.apply(data);
        return Math.abs(hash % this.hashCapacity);
    }
}

