/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.bloom;

import io.polaris.core.bloom.BloomFilter;
import io.polaris.core.hash.Hashing;
import java.util.ArrayList;
import java.util.function.Function;

public abstract class AbstractMultiHashBloomFilter
implements BloomFilter {
    private static final Function<String, Integer>[] DEFAULT_HASH_FUNCS;
    private final Function<String, Integer>[] hashFunctions;
    protected final int hashCount;
    protected final int hashCapacity;
    protected final int expectSize;

    public AbstractMultiHashBloomFilter(int hashCount, int hashCapacity) {
        this(hashCount, hashCapacity, 0);
    }

    protected AbstractMultiHashBloomFilter(int hashCount, int hashCapacity, int expectSize) {
        this(null, hashCount, hashCapacity, expectSize);
    }

    public AbstractMultiHashBloomFilter(Function<String, Integer>[] hashFunctions, int hashCount, int hashCapacity, int expectSize) {
        this.hashFunctions = hashFunctions == null || hashFunctions.length == 0 ? DEFAULT_HASH_FUNCS : hashFunctions;
        this.hashCount = hashCount;
        this.hashCapacity = hashCapacity;
        this.expectSize = expectSize;
    }

    protected abstract boolean getBit(int var1);

    protected abstract void setBit(int var1);

    @Override
    public boolean contains(String data) {
        int[] hashes = this.hash(data);
        return this.contains(hashes);
    }

    @Override
    public boolean add(String data) {
        int[] hashes = this.hash(data);
        if (this.contains(hashes)) {
            return false;
        }
        for (int hash : hashes) {
            this.setBit(hash);
        }
        return true;
    }

    protected boolean contains(int[] hashes) {
        for (int hash : hashes) {
            if (this.getBit(hash)) continue;
            return false;
        }
        return true;
    }

    protected double estimateFnr() {
        if (this.expectSize <= 0) {
            return 0.0;
        }
        return Math.pow(1.0 - Math.exp((double)(-this.hashCount) * (double)this.expectSize / (double)this.hashCapacity), this.hashCount);
    }

    protected int[] hash(String data) {
        int[] rs = new int[this.hashCount];
        for (int i = 0; i < this.hashCount; ++i) {
            int hash = this.hash(data, i);
            rs[i] = Math.abs(hash % this.hashCapacity);
        }
        return rs;
    }

    protected int hash(String data, int seq) {
        if (seq >= 0 && seq < this.hashFunctions.length) {
            return this.hashFunctions[seq].apply(data);
        }
        return 0;
    }

    static {
        ArrayList<Function<String, Integer>> list = new ArrayList<Function<String, Integer>>();
        list.add(Hashing::javaHash);
        list.add(Hashing::murmur32);
        list.add(Hashing::rsHash);
        list.add(Hashing::jsHash);
        list.add(Hashing::pjwHash);
        list.add(Hashing::elfHash);
        list.add(Hashing::bkdrHash);
        list.add(Hashing::sdbmHash);
        list.add(Hashing::djbHash);
        list.add(Hashing::dekHash);
        list.add(Hashing::apHash);
        list.add(Hashing::fnvHash);
        list.add(Hashing::bernstein);
        list.add(Hashing::cityHash32);
        list.add(Hashing::metroHash32);
        list.add(Hashing::ketamaHash);
        DEFAULT_HASH_FUNCS = new Function[list.size()];
        list.toArray(DEFAULT_HASH_FUNCS);
    }
}

