/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.bloom;

import io.polaris.core.bloom.AbstractHashBloomFilter;
import io.polaris.core.bloom.BloomFilter;
import java.util.BitSet;
import java.util.function.Function;

public class BitSetHashBloomFilter
extends AbstractHashBloomFilter
implements BloomFilter {
    private final BitSet bitSet;

    public BitSetHashBloomFilter(int hashCapacity) {
        super(hashCapacity);
        this.bitSet = new BitSet(hashCapacity);
    }

    public BitSetHashBloomFilter(int hashCapacity, int expectSize) {
        super(hashCapacity, expectSize);
        this.bitSet = new BitSet(hashCapacity);
    }

    public BitSetHashBloomFilter(Function<String, Integer> hashFunction, int hashCapacity, int expectSize) {
        super(hashFunction, hashCapacity, expectSize);
        this.bitSet = new BitSet(hashCapacity);
    }

    @Override
    protected boolean getBit(int position) {
        return this.bitSet.get(position);
    }

    @Override
    protected void setBit(int position) {
        this.bitSet.set(position);
    }
}

