/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.cache;

import io.polaris.core.cache.ICache;
import io.polaris.core.map.Maps;
import io.polaris.core.tuple.Ref;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapCache<K, V>
implements ICache<K, V> {
    private final Map<K, Ref<V>> map;

    public MapCache() {
        this.map = new ConcurrentHashMap<K, Ref<V>>();
    }

    public MapCache(int maxCapacity) {
        this.map = maxCapacity > 0 ? Collections.synchronizedMap(Maps.newLimitCapacityMap(maxCapacity)) : new ConcurrentHashMap<K, Ref<V>>();
    }

    public MapCache(int maxCapacity, boolean accessOrder) {
        this.map = maxCapacity > 0 ? Collections.synchronizedMap(Maps.newLimitCapacityMap(maxCapacity, accessOrder)) : new ConcurrentHashMap<K, Ref<V>>();
    }

    public MapCache(Map<K, Ref<V>> map) {
        this.map = map;
    }

    @Override
    @Nullable
    public Ref<V> get(@Nonnull K key) {
        return this.map.get(key);
    }

    @Override
    @Nullable
    public V getIfPresent(@Nonnull K key) {
        Ref<V> ref = this.map.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    @Nullable
    public V get(@Nonnull K key, Supplier<V> loader) {
        Ref<V> ref = this.map.get(key);
        return ref == null ? loader.get() : ref.get(loader);
    }

    @Override
    public Ref<V> putIfAbsent(@Nonnull K key, @Nullable V value) {
        return this.map.putIfAbsent(key, Ref.of(value));
    }

    @Override
    public void put(@Nonnull K key, @Nullable V value) {
        this.map.put(key, Ref.of(value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach((k, v) -> this.map.put(k, Ref.of(v)));
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

