/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.classloader;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public enum ClassLoaders {
    INSTANCE;

    private final AtomicLong prependIndex = new AtomicLong(0L);
    private final AtomicLong appendIndex = new AtomicLong(0L);
    private final Map<ClassLoader, Long> loaders = new WeakHashMap<ClassLoader, Long>();
    private volatile long changeId = 0L;

    private ClassLoaders() {
        this.appendClassLoader(Thread.currentThread().getContextClassLoader());
        this.appendClassLoader(ClassLoaders.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendClassLoader(ClassLoader loader) {
        this.loaders.putIfAbsent(loader, this.appendIndex.getAndIncrement());
        ClassLoaders classLoaders = this;
        synchronized (classLoaders) {
            ++this.changeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prependClassLoader(ClassLoader loader) {
        this.loaders.putIfAbsent(loader, this.prependIndex.decrementAndGet());
        ClassLoaders classLoaders = this;
        synchronized (classLoaders) {
            ++this.changeId;
        }
    }

    public long changeId() {
        return this.changeId;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Collection<ClassLoader> classLoaders = this.getClassLoaders(null);
        return this.loadClass(classLoaders, name);
    }

    public Class<?> loadClass(Collection<ClassLoader> classLoaders, String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : classLoaders) {
            try {
                Class<?> c = classLoader.loadClass(name);
                return c;
            }
            catch (Throwable throwable) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    public Collection<ClassLoader> getClassLoaders(Predicate<ClassLoader> predicate) {
        TreeMap<Long, ClassLoader> map = new TreeMap<Long, ClassLoader>();
        for (Map.Entry<ClassLoader, Long> entry : this.loaders.entrySet()) {
            if (predicate != null && !predicate.test(entry.getKey())) continue;
            map.put(entry.getValue(), entry.getKey());
        }
        return map.values();
    }

    public ClassLoader newTargetSideClassLoader(ClassLoader targetClassLoader) {
        return new TargetSideClassLoader(targetClassLoader);
    }

    static class TargetSideClassLoader
    extends ClassLoader {
        private final ClassLoader targetClassLoader;

        public TargetSideClassLoader(ClassLoader targetClassLoader) {
            super(targetClassLoader);
            this.targetClassLoader = targetClassLoader;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Class<?> readClass(String name) {
            String path = '/' + name.replace('.', '/') + ".class";
            try (InputStream in = this.targetClassLoader.getResourceAsStream(path);){
                Class<?> clazz2;
                if (in == null) return null;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                int i = in.read(buf);
                while (i != -1) {
                    bos.write(buf, 0, i);
                    i = in.read(buf);
                }
                byte[] bytes = bos.toByteArray();
                Class<?> clazz = clazz2 = this.defineClass(name, bytes, 0, bytes.length);
                return clazz;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass == null) {
                    try {
                        loadedClass = Class.forName(name, false, this.targetClassLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (loadedClass == null) {
                    try {
                        loadedClass = this.readClass(name);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (loadedClass != null) {
                    if (resolve) {
                        this.resolveClass(loadedClass);
                    }
                    return loadedClass;
                }
            }
            try {
                Collection<ClassLoader> classLoaders = INSTANCE.getClassLoaders(cl -> cl != this.targetClassLoader && cl != this);
                Class<?> c = INSTANCE.loadClass(classLoaders, name);
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.loadClass(name, resolve);
            }
        }
    }
}

