/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.cluster;

import io.polaris.core.os.OS;
import io.polaris.core.string.Strings;
import java.util.Map;

public class InstanceNode
implements Comparable<InstanceNode> {
    private String id;
    private String host;
    private int port;
    private int pid;
    private String hostName;
    private String osName;
    private long vmStartTime;
    private Map<String, String> metadata;
    private volatile boolean self;

    public void setDefault() {
        this.host = OS.getFirstIp();
        this.hostName = OS.getHostName();
        this.osName = OS.getOsName();
        this.pid = OS.getPid();
        this.vmStartTime = OS.getVmStartTime();
    }

    public void check() {
        if (Strings.isBlank(this.id)) {
            if (Strings.isBlank(this.host)) {
                throw new IllegalArgumentException("address is null");
            }
            if (this.pid <= 0 && this.port <= 0) {
                throw new IllegalArgumentException("pid and port is null");
            }
        }
    }

    public String getId() {
        if (Strings.isBlank(this.id)) {
            if (this.port > 0) {
                return this.host + ':' + this.port;
            }
            return this.host + '@' + this.pid;
        }
        return this.id;
    }

    @Override
    public int compareTo(InstanceNode o) {
        return this.getId().compareTo(o.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getId().equals(((InstanceNode)obj).getId());
    }

    public String toString() {
        return "InstanceNode(id=" + this.id + ", host=" + this.host + ", port=" + this.port + ", pid=" + this.pid + ", hostName=" + this.hostName + ", osName=" + this.osName + ", vmStartTime=" + this.vmStartTime + ", metadata=" + this.metadata + ", self=" + this.self + ")";
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public long getVmStartTime() {
        return this.vmStartTime;
    }

    public void setVmStartTime(long vmStartTime) {
        this.vmStartTime = vmStartTime;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean isSelf() {
        return this.self;
    }

    public void setSelf(boolean self) {
        this.self = self;
    }
}

