/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.collection;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Iterators {
    public static <E> Iterator<E> iterator(final Enumeration<E> enumeration) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <E> Enumeration<E> enumeration(Iterable<E> iterable) {
        return Iterators.enumeration(iterable.iterator());
    }

    public static <E> Enumeration<E> enumeration(final Iterator<E> iterator) {
        return new Enumeration<E>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public E nextElement() {
                return iterator.next();
            }
        };
    }

    public static <S, T> Iterator<T> convert(final Iterator<S> iterator, final Function<S, T> converter) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return converter.apply(iterator.next());
            }

            @Override
            public void remove() {
                iterator.next();
            }
        };
    }

    @Nullable
    public static <E> E getNext(Iterator<? extends E> iterator) {
        return Iterators.getNext(iterator, null);
    }

    @Nullable
    public static <E> E getNext(Iterator<? extends E> iterator, @Nullable E defaultValue) {
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public static <E> E getLast(Iterator<E> iterator) {
        E current;
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }

    @Nullable
    public static <E> E getLast(Iterator<? extends E> iterator, @Nullable E defaultValue) {
        return iterator.hasNext() ? Iterators.getLast(iterator) : defaultValue;
    }

    @Nullable
    public static <E> E get(Iterator<? extends E> iterator, int position) {
        return Iterators.get(iterator, position, null);
    }

    @Nullable
    public static <E> E get(Iterator<? extends E> iterator, int position, @Nullable E defaultValue) {
        Iterators.skip(iterator, position);
        return Iterators.getNext(iterator, defaultValue);
    }

    public static int skip(Iterator<?> iterator, int num) {
        int i;
        for (i = 0; i < num && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return i;
    }
}

