/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.compiler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class MemoryJavaFileObject
extends SimpleJavaFileObject {
    private final CharSequence source;
    private final byte[] bytes;

    public MemoryJavaFileObject(String classFullName, byte[] bytes) {
        super(URI.create(classFullName.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
        this.source = null;
        this.bytes = bytes;
    }

    protected MemoryJavaFileObject(String classFullName, CharSequence source) {
        super(URI.create(classFullName.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
        this.source = source;
        this.bytes = null;
    }

    protected MemoryJavaFileObject(URI uri, CharSequence source) {
        super(uri, JavaFileObject.Kind.SOURCE);
        this.source = source;
        this.bytes = null;
    }

    protected MemoryJavaFileObject(URI uri, JavaFileObject.Kind kind) {
        super(uri, kind);
        this.source = null;
        this.bytes = null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws UnsupportedOperationException {
        if (this.source == null) {
            throw new UnsupportedOperationException();
        }
        return this.source;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] getByteCode() {
        return this.bytes;
    }
}

