/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.compress;

import io.polaris.core.io.IO;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Gzip
implements Closeable {
    private InputStream source;
    private OutputStream target;

    public static Gzip of(InputStream source, OutputStream target) {
        return new Gzip(source, target);
    }

    public Gzip(InputStream source, OutputStream target) {
        this.source = source;
        this.target = target;
    }

    public OutputStream getTarget() {
        return this.target;
    }

    public Gzip gzip() throws IOException {
        this.target = this.target instanceof GZIPOutputStream ? (GZIPOutputStream)this.target : new GZIPOutputStream(this.target);
        IO.copy(this.source, this.target);
        ((GZIPOutputStream)this.target).finish();
        return this;
    }

    public Gzip unGzip() throws IOException {
        this.source = this.source instanceof GZIPInputStream ? (GZIPInputStream)this.source : new GZIPInputStream(this.source);
        IO.copy(this.source, this.target);
        return this;
    }

    @Override
    public void close() {
        IO.close(this.target);
        IO.close(this.source);
    }
}

