/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent;

import io.polaris.core.concurrent.PooledThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class Schedules {
    public static ScheduledExecutorService single() {
        return new ScheduledThreadPoolExecutor(1);
    }

    public static ScheduledExecutorService create(int core) {
        return new ScheduledThreadPoolExecutor(core);
    }

    public static ScheduledExecutorService create(int core, String threadNamePrefix) {
        return Schedules.create(core, threadNamePrefix, true);
    }

    public static ScheduledExecutorService create(int core, String threadNamePrefix, boolean isDaemon) {
        return Schedules.create(core, new PooledThreadFactory().withPrefix(threadNamePrefix).withDaemon(isDaemon));
    }

    public static ScheduledExecutorService create(int core, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(core, threadFactory);
    }

    public static void shutdown(ScheduledExecutorService pool) {
        if (pool == null) {
            return;
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

