/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.collection.Iterables;
import io.polaris.core.converter.AbstractConverter;
import io.polaris.core.converter.Converters;
import io.polaris.core.io.Serializations;
import io.polaris.core.json.JsonSerializer;
import io.polaris.core.lang.JavaType;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.service.StatefulServiceLoader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class ArrayConverter<T>
extends AbstractConverter<T[]> {
    private static final ILogger log = ILoggers.of(ArrayConverter.class);
    private final JavaType<T[]> targetType;
    private final JavaType<T> targetComponentType;

    public ArrayConverter(Class<T[]> targetType) {
        this(targetType == null ? null : JavaType.of(targetType));
    }

    public ArrayConverter(JavaType<T[]> targetType) {
        if (targetType == null) {
            this.targetType = JavaType.of(Object[].class);
            this.targetComponentType = JavaType.of(Object.class);
        } else if (targetType.getRawType() instanceof GenericArrayType) {
            this.targetType = targetType;
            this.targetComponentType = JavaType.of(((GenericArrayType)targetType.getRawType()).getGenericComponentType());
        } else if (targetType.getRawClass().isArray()) {
            this.targetType = targetType;
            this.targetComponentType = JavaType.of(targetType.getRawClass().getComponentType());
        } else {
            this.targetComponentType = JavaType.of(targetType.getRawType());
            this.targetType = JavaType.of(new GenericArrayType(){

                @Override
                public Type getGenericComponentType() {
                    return ArrayConverter.this.targetComponentType.getRawType();
                }

                public String toString() {
                    return ArrayConverter.this.targetComponentType.getRawType().getTypeName() + "[]";
                }
            });
        }
    }

    @Override
    public JavaType<T[]> getTargetType() {
        return this.targetType;
    }

    @Override
    protected <S> T[] doConvert(S value, JavaType<T[]> targetType, JavaType<S> sourceType) {
        Type genericComponentType;
        if (sourceType.getRawType() instanceof Class ? ((Class)sourceType.getRawType()).isArray() && this.targetComponentType.getRawClass().isAssignableFrom(((Class)sourceType.getRawType()).getComponentType()) : sourceType.getRawType() instanceof GenericArrayType && this.targetComponentType == (genericComponentType = ((GenericArrayType)sourceType.getRawType()).getGenericComponentType())) {
            return (Object[])value;
        }
        return (Object[])(value.getClass().isArray() ? this.convertArrayToArray(value) : this.convertObjectToArray(value));
    }

    private Object convertArrayToArray(Object array) {
        int len = Array.getLength(array);
        Object result = Array.newInstance(this.targetComponentType.getRawClass(), len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, this.convertComponentType(Array.get(array, i)));
        }
        return result;
    }

    private String[] splitCharSequence(CharSequence value) {
        char ch;
        int begin = 0;
        int end = value.length();
        int i = 0;
        while (i < value.length()) {
            ch = value.charAt(i);
            if (!Character.isWhitespace(ch)) {
                if (ch != '[') break;
                begin = i + 1;
                break;
            }
            begin = i++;
        }
        i = value.length() - 1;
        while (i >= 0) {
            ch = value.charAt(i);
            if (!Character.isWhitespace(ch)) {
                if (ch != ']') break;
                end = i;
                break;
            }
            end = i--;
        }
        if (end > begin) {
            return value.subSequence(begin, end).toString().trim().split(",");
        }
        return new String[]{""};
    }

    private Object convertObjectToArray(Object value) {
        if (value instanceof CharSequence) {
            block14: {
                if (this.targetComponentType.getRawClass() == Character.TYPE || this.targetComponentType.getRawClass() == Character.class) {
                    return this.convertArrayToArray(value.toString().toCharArray());
                }
                try {
                    Optional<JsonSerializer> optional = StatefulServiceLoader.load(JsonSerializer.class).optionalService();
                    if (optional.isPresent()) {
                        String json = value.toString();
                        return optional.get().deserialize(json, this.targetType.getRawType());
                    }
                }
                catch (Exception e) {
                    log.warn("\u89e3\u6790JSON\u5931\u8d25\uff1a{}", e.getMessage());
                    if (!log.isDebugEnabled()) break block14;
                    log.debug(e.getMessage(), e);
                }
            }
            return this.convertArrayToArray(this.splitCharSequence((CharSequence)value));
        }
        if (value instanceof List) {
            List list = (List)value;
            Object result = Array.newInstance(this.targetComponentType.getRawClass(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
            return result;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Object result = Array.newInstance(this.targetComponentType.getRawClass(), collection.size());
            int i = 0;
            for (Object element : collection) {
                Array.set(result, i, this.convertComponentType(element));
                ++i;
            }
            return result;
        }
        if (value instanceof Iterable) {
            List list = Iterables.asList((Iterable)value);
            Object result = Array.newInstance(this.targetComponentType.getRawClass(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
            return result;
        }
        if (value instanceof Iterator) {
            List list = Iterables.asList((Iterator)value);
            Object result = Array.newInstance(this.targetComponentType.getRawClass(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
            return result;
        }
        if (value instanceof Serializable && Byte.TYPE == this.targetComponentType.getRawClass()) {
            return Serializations.serialize(value);
        }
        return this.convertToSingleElementArray(value);
    }

    private Object convertToSingleElementArray(Object value) {
        Object result = Array.newInstance(this.targetComponentType.getRawClass(), 1);
        Array.set(result, 0, this.convertComponentType(value));
        return result;
    }

    private Object convertComponentType(Object value) {
        return Converters.convert(this.targetComponentType, value, null);
    }
}

