/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.converter.AbstractConverter;
import io.polaris.core.converter.ConversionException;
import io.polaris.core.converter.Converters;
import io.polaris.core.io.Serializations;
import io.polaris.core.json.JsonSerializer;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.copier.Copiers;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.service.StatefulServiceLoader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;

public class BeanConverter<T>
extends AbstractConverter<T> {
    private final JavaType<T> targetType;
    private final CopyOptions copyOptions;

    public BeanConverter(Type beanType) {
        this(beanType, CopyOptions.create().ignoreError(true));
    }

    public BeanConverter(Type beanType, CopyOptions copyOptions) {
        this(JavaType.of(beanType), copyOptions);
    }

    public BeanConverter(JavaType<T> beanType, CopyOptions copyOptions) {
        this.targetType = beanType;
        this.copyOptions = copyOptions.converter((t, s) -> Converters.convert(t, s));
    }

    @Override
    public JavaType<T> getTargetType() {
        return this.targetType;
    }

    @Override
    protected <S> T doConvert(S value, JavaType<T> targetType, JavaType<S> sourceType) {
        Optional<JsonSerializer> optional;
        if (sourceType.getRawType() instanceof Class ? targetType.getRawClass().isAssignableFrom((Class)sourceType.getRawType()) : targetType.getRawType() == sourceType.getRawType()) {
            return (T)value;
        }
        if (value instanceof Map || Beans.isBeanClass(value.getClass())) {
            T target = Reflects.newInstanceIfPossible(targetType.getRawClass());
            return Copiers.copy(value, targetType.getRawType(), target, this.copyOptions);
        }
        if (value instanceof byte[]) {
            return (T)Serializations.deserialize((byte[])value);
        }
        if (value instanceof CharSequence && (optional = StatefulServiceLoader.load(JsonSerializer.class).optionalService()).isPresent()) {
            String json = value.toString();
            return optional.get().deserialize(json, targetType.getRawType());
        }
        throw new ConversionException("\u6e90\u5bf9\u8c61\u7c7b\u578b\u4e0d\u652f\u6301");
    }
}

