/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.collection.Iterables;
import io.polaris.core.converter.AbstractConverter;
import io.polaris.core.converter.ConversionException;
import io.polaris.core.converter.Converters;
import io.polaris.core.json.JsonSerializer;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.service.StatefulServiceLoader;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class CollectionConverter<T extends Collection<E>, E>
extends AbstractConverter<T> {
    private static final ILogger log = ILoggers.of(CollectionConverter.class);
    private final JavaType<T> collectionType;
    private final JavaType<E> elementType;

    public CollectionConverter(JavaType<T> collectionType, JavaType<E> elementType) {
        this.collectionType = collectionType;
        if (elementType == null) {
            elementType = JavaType.of(collectionType.getActualType(Collection.class, 0));
        }
        this.elementType = elementType;
    }

    public CollectionConverter(JavaType<T> collectionType) {
        this(collectionType, null);
    }

    public CollectionConverter(Type collectionType) {
        this(JavaType.of(collectionType), null);
    }

    public CollectionConverter() {
        this((Type)((Object)Collection.class));
    }

    @Override
    public JavaType<T> getTargetType() {
        return this.collectionType;
    }

    @Override
    protected <S> T doConvert(S value, JavaType<T> targetType, JavaType<S> sourceType) {
        Type sourceElementType;
        if (this.collectionType.getRawClass().isAssignableFrom(sourceType.getRawClass()) && ((sourceElementType = sourceType.getActualType(Collection.class, 0)) instanceof Class ? this.elementType.getRawClass().isAssignableFrom((Class)sourceElementType) : this.elementType.getRawType() == sourceElementType)) {
            return (T)((Collection)value);
        }
        Collection<?> c = CollectionConverter.create(Types.getClass(this.collectionType), Types.getClass(this.elementType));
        Iterator<Object> iter = null;
        if (value instanceof Iterator) {
            iter = (Iterator)value;
        } else if (value instanceof Iterable) {
            iter = ((Iterable)value).iterator();
        } else if (value instanceof Enumeration) {
            iter = Iterables.iterator((Enumeration)value);
        } else if (value != null) {
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    Object value1 = Array.get(value, i);
                    c.add(Converters.convert(this.elementType, value1));
                }
            } else if (value instanceof CharSequence) {
                block18: {
                    try {
                        Optional<JsonSerializer> optional = StatefulServiceLoader.load(JsonSerializer.class).optionalService();
                        if (optional.isPresent()) {
                            String json = value.toString();
                            return (T)((Collection)optional.get().deserialize(json, this.collectionType.getRawType()));
                        }
                    }
                    catch (Exception e) {
                        log.warn("\u89e3\u6790JSON\u5931\u8d25\uff1a{}", e.getMessage());
                        if (!log.isDebugEnabled()) break block18;
                        log.debug(e.getMessage(), e);
                    }
                }
                this.splitCharSequence((CharSequence)value, c);
            } else {
                c.add(Converters.convert(this.elementType, value));
            }
        }
        if (iter != null) {
            while (iter.hasNext()) {
                Object next = iter.next();
                c.add(Converters.convert(this.elementType, next));
            }
        }
        return (T)c;
    }

    private void splitCharSequence(CharSequence value, Collection<?> c) {
        char ch;
        int begin = 0;
        int end = value.length();
        int i = 0;
        while (i < value.length()) {
            ch = value.charAt(i);
            if (!Character.isWhitespace(ch)) {
                if (ch != '[') break;
                begin = i + 1;
                break;
            }
            begin = i++;
        }
        i = value.length() - 1;
        while (i >= 0) {
            ch = value.charAt(i);
            if (!Character.isWhitespace(ch)) {
                if (ch != ']') break;
                end = i;
                break;
            }
            end = i--;
        }
        if (end > begin) {
            for (String s : value.subSequence(begin, end).toString().trim().split(",")) {
                c.add(Converters.convert(this.elementType, s));
            }
        } else {
            c.add(null);
        }
    }

    static <T> Collection<T> create(Class<?> collectionType, Class<T> elementType) {
        Collection<Object> c;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            c = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            c = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            c = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            c = new TreeSet((o1, o2) -> {
                if (o1 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return o1.toString().compareTo(o2.toString());
            });
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            c = EnumSet.noneOf(elementType);
        } else if (collectionType.isAssignableFrom(BlockingDeque.class)) {
            c = new LinkedBlockingDeque();
        } else if (collectionType.isAssignableFrom(Deque.class)) {
            c = new ArrayDeque();
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            c = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            c = new LinkedList();
        } else {
            try {
                c = (Collection)Reflects.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                Class<?> superclass = collectionType.getSuperclass();
                if (null != superclass && collectionType != superclass) {
                    return CollectionConverter.create(superclass, elementType);
                }
                throw new ConversionException("\u96c6\u5408\u7c7b\u578b\u5bf9\u8c61\u65e0\u6cd5\u521b\u5efa", e);
            }
        }
        return c;
    }
}

