/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.lang.JavaType;

public class EnumConverter<T extends Enum<T>>
extends AbstractSimpleConverter<T> {
    private final JavaType<T> targetType;

    public EnumConverter(Class<T> enumClass) {
        this.targetType = JavaType.of(enumClass);
    }

    @Override
    public JavaType<T> getTargetType() {
        return this.targetType;
    }

    @Override
    protected T doConvert(Object value, JavaType<T> targetType) {
        if (value == null) {
            return null;
        }
        Enum[] enumConstants = (Enum[])targetType.getRawClass().getEnumConstants();
        if (value instanceof Number) {
            int i = ((Number)value).intValue();
            return (T)(i >= 0 && i < enumConstants.length ? enumConstants[i] : null);
        }
        return Enum.valueOf(targetType.getRawClass(), this.asString(value));
    }
}

