/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter.support;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.converter.Converters;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.function.Function;

public class ReferenceConverter<T extends Reference>
extends AbstractSimpleConverter<T> {
    private final JavaType<T> targetType;
    private final Function<Object, T> factory;

    public ReferenceConverter(Class<T> targetType) {
        this(JavaType.of(targetType));
    }

    public ReferenceConverter(JavaType<T> targetType) {
        this.targetType = targetType;
        if (this.targetType.getRawClass() == WeakReference.class) {
            this.factory = targetValue -> new WeakReference<Object>(targetValue);
        } else if (this.targetType.getRawClass() == SoftReference.class) {
            this.factory = targetValue -> new SoftReference<Object>(targetValue);
        } else {
            throw new IllegalArgumentException("\u76ee\u6807\u7c7b\u578b\u4e0d\u652f\u6301");
        }
    }

    @Override
    public JavaType<T> getTargetType() {
        return this.targetType;
    }

    @Override
    protected T doConvert(Object value, JavaType<T> targetType) {
        Object targetValue = null;
        Type paramType = targetType.getActualType(Reference.class, 0);
        if (!Types.isUnknown(paramType)) {
            targetValue = Converters.convert(paramType, value);
        }
        if (targetValue == null) {
            targetValue = value;
        }
        return (T)((Reference)this.factory.apply(targetValue));
    }
}

