/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto;

import io.polaris.core.collection.Iterables;
import io.polaris.core.crypto.CryptoRuntimeException;
import io.polaris.core.crypto.ICryptoProviderLoader;
import io.polaris.core.crypto.asymmetric.AsymmetricAlgorithm;
import io.polaris.core.crypto.symmetric.SymmetricAlgorithm;
import io.polaris.core.io.IO;
import io.polaris.core.random.Randoms;
import io.polaris.core.string.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoKeys {
    public static final int DEFAULT_KEY_SIZE = 1024;
    public static final String SM2_DEFAULT_CURVE = "sm2p256v1";
    public static final String KEY_TYPE_JKS = "JKS";
    public static final String KEY_TYPE_PKCS12 = "pkcs12";
    public static final String CERT_TYPE_X509 = "X.509";

    public static KeyGenerator getKeyGenerator(String algorithm) {
        try {
            return KeyGenerator.getInstance(CryptoKeys.getMainAlgorithm(algorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyGenerator getKeyGenerator(String algorithm, String provider) {
        try {
            return KeyGenerator.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyGenerator getKeyGenerator(String algorithm, Provider provider) {
        try {
            return KeyGenerator.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) {
        try {
            return KeyPairGenerator.getInstance(CryptoKeys.getMainAlgorithm(algorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm, String provider) {
        try {
            return KeyPairGenerator.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm, Provider provider) {
        try {
            return KeyPairGenerator.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) {
        try {
            return SecretKeyFactory.getInstance(CryptoKeys.getMainAlgorithm(algorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm, String provider) {
        try {
            return SecretKeyFactory.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm, Provider provider) {
        try {
            return SecretKeyFactory.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyFactory getKeyFactory(String algorithm) {
        try {
            return KeyFactory.getInstance(CryptoKeys.getMainAlgorithm(algorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyFactory getKeyFactory(String algorithm, String provider) {
        try {
            return KeyFactory.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyFactory getKeyFactory(String algorithm, Provider provider) {
        try {
            return KeyFactory.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Signature getSignature(String algorithm) {
        try {
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Signature getSignature(String algorithm, String provider) {
        try {
            return Signature.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Signature getSignature(String algorithm, Provider provider) {
        try {
            return Signature.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Cipher getCipher(String algorithm) {
        try {
            return Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Cipher getCipher(String algorithm, String provider) {
        try {
            return Cipher.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Cipher getCipher(String algorithm, Provider provider) {
        try {
            return Cipher.getInstance(CryptoKeys.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static String getMainAlgorithm(@Nonnull String algorithm) {
        int slashIndex = algorithm.indexOf(47);
        if (slashIndex > 0) {
            return algorithm.substring(0, slashIndex);
        }
        return algorithm;
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        if (Strings.startsWithIgnoreCase(algorithm, "ECIESWith")) {
            return "EC";
        }
        int indexOfWith = Strings.lastIndexOfIgnoreCase(algorithm, "with");
        if (indexOfWith > 0) {
            algorithm = algorithm.substring(indexOfWith + "with".length());
        }
        if ("ECDSA".equalsIgnoreCase(algorithm) || "SM2".equalsIgnoreCase(algorithm) || "ECIES".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    public static SecretKey generateKey(String algorithm) {
        return CryptoKeys.generateKey(algorithm, -1);
    }

    public static SecretKey generateKey(String provider, String algorithm) {
        return CryptoKeys.generateKey(provider, algorithm, -1);
    }

    public static SecretKey generateKey(Provider provider, String algorithm) {
        return CryptoKeys.generateKey(provider, algorithm, -1);
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        return CryptoKeys.generateKey(algorithm, keySize, (SecureRandom)null);
    }

    public static SecretKey generateKey(String provider, String algorithm, int keySize) {
        return CryptoKeys.generateKey(provider, algorithm, keySize, (SecureRandom)null);
    }

    public static SecretKey generateKey(Provider provider, String algorithm, int keySize) {
        return CryptoKeys.generateKey(provider, algorithm, keySize, (SecureRandom)null);
    }

    public static SecretKey generateKey(String algorithm, int keySize, SecureRandom random) {
        algorithm = CryptoKeys.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = CryptoKeys.getKeyGenerator(algorithm);
        if (keySize <= 0 && SymmetricAlgorithm.AES.code().equals(algorithm)) {
            keySize = 128;
        }
        if (keySize > 0) {
            if (null == random) {
                keyGenerator.init(keySize);
            } else {
                keyGenerator.init(keySize, random);
            }
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String provider, String algorithm, int keySize, SecureRandom random) {
        algorithm = CryptoKeys.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = CryptoKeys.getKeyGenerator(algorithm, provider);
        if (keySize <= 0 && SymmetricAlgorithm.AES.code().equals(algorithm)) {
            keySize = 128;
        }
        if (keySize > 0) {
            if (null == random) {
                keyGenerator.init(keySize);
            } else {
                keyGenerator.init(keySize, random);
            }
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(Provider provider, String algorithm, int keySize, SecureRandom random) {
        algorithm = CryptoKeys.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = CryptoKeys.getKeyGenerator(algorithm, provider);
        if (keySize <= 0 && SymmetricAlgorithm.AES.code().equals(algorithm)) {
            keySize = 128;
        }
        if (keySize > 0) {
            if (null == random) {
                keyGenerator.init(keySize);
            } else {
                keyGenerator.init(keySize, random);
            }
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        SecretKey secretKey = algorithm.startsWith("PBE") ? CryptoKeys.generatePBEKey(algorithm, null == key ? null : new String(key, StandardCharsets.UTF_8).toCharArray()) : (algorithm.startsWith("DES") ? CryptoKeys.generateDESKey(algorithm, key) : (null == key ? CryptoKeys.generateKey(algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateKey(String provider, String algorithm, byte[] key) {
        SecretKey secretKey = algorithm.startsWith("PBE") ? CryptoKeys.generatePBEKey(provider, algorithm, null == key ? null : new String(key, StandardCharsets.UTF_8).toCharArray()) : (algorithm.startsWith("DES") ? CryptoKeys.generateDESKey(provider, algorithm, key) : (null == key ? CryptoKeys.generateKey(provider, algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateKey(Provider provider, String algorithm, byte[] key) {
        SecretKey secretKey = algorithm.startsWith("PBE") ? CryptoKeys.generatePBEKey(provider, algorithm, null == key ? null : new String(key, StandardCharsets.UTF_8).toCharArray()) : (algorithm.startsWith("DES") ? CryptoKeys.generateDESKey(provider, algorithm, key) : (null == key ? CryptoKeys.generateKey(provider, algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateKeyBySeed(String algorithm, byte[] seed) {
        if (seed == null) {
            return CryptoKeys.generateKey(algorithm);
        }
        KeyGenerator keyGen = CryptoKeys.getKeyGenerator(algorithm);
        keyGen.init(new SecureRandom(seed));
        return keyGen.generateKey();
    }

    public static SecretKey generateKeyBySeed(String provider, String algorithm, byte[] seed) {
        if (seed == null) {
            return CryptoKeys.generateKey(algorithm);
        }
        KeyGenerator keyGen = CryptoKeys.getKeyGenerator(algorithm, provider);
        keyGen.init(new SecureRandom(seed));
        return keyGen.generateKey();
    }

    public static SecretKey generateKeyBySeed(Provider provider, String algorithm, byte[] seed) {
        if (seed == null) {
            return CryptoKeys.generateKey(algorithm);
        }
        KeyGenerator keyGen = CryptoKeys.getKeyGenerator(algorithm, provider);
        keyGen.init(new SecureRandom(seed));
        return keyGen.generateKey();
    }

    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        if (Strings.isNotBlank(algorithm) || !algorithm.startsWith("PBE")) {
            throw new IllegalArgumentException("Not PBE algorithm!");
        }
        if (key == null) {
            key = Randoms.randomString(32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return CryptoKeys.generateKey(algorithm, keySpec);
    }

    public static SecretKey generatePBEKey(String provider, String algorithm, char[] key) {
        if (Strings.isNotBlank(algorithm) || !algorithm.startsWith("PBE")) {
            throw new IllegalArgumentException("Not PBE algorithm!");
        }
        if (key == null) {
            key = Randoms.randomString(32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return CryptoKeys.generateKey(provider, algorithm, (KeySpec)keySpec);
    }

    public static SecretKey generatePBEKey(Provider provider, String algorithm, char[] key) {
        if (Strings.isNotBlank(algorithm) || !algorithm.startsWith("PBE")) {
            throw new IllegalArgumentException("Not PBE algorithm!");
        }
        if (key == null) {
            key = Randoms.randomString(32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return CryptoKeys.generateKey(provider, algorithm, (KeySpec)keySpec);
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        if (Strings.isBlank(algorithm) || !algorithm.startsWith("DES")) {
            throw new IllegalArgumentException("Not DES algorithm!");
        }
        try {
            SecretKey secretKey;
            if (null == key) {
                secretKey = CryptoKeys.generateKey(algorithm);
            } else {
                KeySpec keySpec = algorithm.startsWith("DESede") ? new DESedeKeySpec(key) : new DESKeySpec(key);
                secretKey = CryptoKeys.generateKey(algorithm, keySpec);
            }
            return secretKey;
        }
        catch (InvalidKeyException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static SecretKey generateDESKey(String provider, String algorithm, byte[] key) {
        if (Strings.isBlank(algorithm) || !algorithm.startsWith("DES")) {
            throw new IllegalArgumentException("Not DES algorithm!");
        }
        try {
            SecretKey secretKey;
            if (null == key) {
                secretKey = CryptoKeys.generateKey(provider, algorithm);
            } else {
                KeySpec keySpec = algorithm.startsWith("DESede") ? new DESedeKeySpec(key) : new DESKeySpec(key);
                secretKey = CryptoKeys.generateKey(provider, algorithm, keySpec);
            }
            return secretKey;
        }
        catch (InvalidKeyException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static SecretKey generateDESKey(Provider provider, String algorithm, byte[] key) {
        if (Strings.isBlank(algorithm) || !algorithm.startsWith("DES")) {
            throw new IllegalArgumentException("Not DES algorithm!");
        }
        try {
            SecretKey secretKey;
            if (null == key) {
                secretKey = CryptoKeys.generateKey(provider, algorithm);
            } else {
                KeySpec keySpec = algorithm.startsWith("DESede") ? new DESedeKeySpec(key) : new DESKeySpec(key);
                secretKey = CryptoKeys.generateKey(provider, algorithm, keySpec);
            }
            return secretKey;
        }
        catch (InvalidKeyException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = CryptoKeys.getSecretKeyFactory(algorithm);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static SecretKey generateKey(String provider, String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = CryptoKeys.getSecretKeyFactory(algorithm, provider);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static SecretKey generateKey(Provider provider, String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = CryptoKeys.getSecretKeyFactory(algorithm, provider);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PrivateKey generateRSAPrivateKey(@Nonnull byte[] key) {
        return CryptoKeys.generatePrivateKey(AsymmetricAlgorithm.RSA.code(), key);
    }

    public static PrivateKey generateRSAPrivateKey(String provider, @Nonnull byte[] key) {
        return CryptoKeys.generatePrivateKey(provider, AsymmetricAlgorithm.RSA.code(), key);
    }

    public static PrivateKey generateRSAPrivateKey(Provider provider, @Nonnull byte[] key) {
        return CryptoKeys.generatePrivateKey(provider, AsymmetricAlgorithm.RSA.code(), key);
    }

    public static PrivateKey generatePrivateKey(@Nonnull String algorithm, @Nonnull byte[] key) {
        return CryptoKeys.generatePrivateKey(algorithm, new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String provider, @Nonnull String algorithm, @Nonnull byte[] key) {
        return CryptoKeys.generatePrivateKey(provider, algorithm, (KeySpec)new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(Provider provider, @Nonnull String algorithm, @Nonnull byte[] key) {
        return CryptoKeys.generatePrivateKey(provider, algorithm, (KeySpec)new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(@Nonnull String algorithm, @Nonnull KeySpec keySpec) {
        algorithm = CryptoKeys.getAlgorithmAfterWith(algorithm);
        try {
            return CryptoKeys.getKeyFactory(algorithm).generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PrivateKey generatePrivateKey(String provider, @Nonnull String algorithm, @Nonnull KeySpec keySpec) {
        algorithm = CryptoKeys.getAlgorithmAfterWith(algorithm);
        try {
            return CryptoKeys.getKeyFactory(algorithm, provider).generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PrivateKey generatePrivateKey(Provider provider, @Nonnull String algorithm, @Nonnull KeySpec keySpec) {
        algorithm = CryptoKeys.getAlgorithmAfterWith(algorithm);
        try {
            return CryptoKeys.getKeyFactory(algorithm, provider).generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PublicKey generateRSAPublicKey(@Nonnull byte[] key) {
        return CryptoKeys.generatePublicKey(AsymmetricAlgorithm.RSA.code(), key);
    }

    public static PublicKey generateRSAPublicKey(String provider, @Nonnull byte[] key) {
        return CryptoKeys.generatePublicKey(provider, AsymmetricAlgorithm.RSA.code(), key);
    }

    public static PublicKey generateRSAPublicKey(Provider provider, @Nonnull byte[] key) {
        return CryptoKeys.generatePublicKey(provider, AsymmetricAlgorithm.RSA.code(), key);
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        return CryptoKeys.generatePublicKey(algorithm, new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(String provider, String algorithm, byte[] key) {
        return CryptoKeys.generatePublicKey(provider, algorithm, (KeySpec)new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(Provider provider, String algorithm, byte[] key) {
        return CryptoKeys.generatePublicKey(provider, algorithm, (KeySpec)new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        algorithm = CryptoKeys.getAlgorithmAfterWith(algorithm);
        try {
            return CryptoKeys.getKeyFactory(algorithm).generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PublicKey generatePublicKey(String provider, String algorithm, KeySpec keySpec) {
        algorithm = CryptoKeys.getAlgorithmAfterWith(algorithm);
        try {
            return CryptoKeys.getKeyFactory(algorithm, provider).generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PublicKey generatePublicKey(Provider provider, String algorithm, KeySpec keySpec) {
        algorithm = CryptoKeys.getAlgorithmAfterWith(algorithm);
        try {
            return CryptoKeys.getKeyFactory(algorithm, provider).generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) {
        int keySize = "ECIES".equalsIgnoreCase(algorithm) ? 256 : 1024;
        return CryptoKeys.generateKeyPair(algorithm, keySize);
    }

    public static KeyPair generateKeyPair(String provider, String algorithm) {
        int keySize = "ECIES".equalsIgnoreCase(algorithm) ? 256 : 1024;
        return CryptoKeys.generateKeyPair(provider, algorithm, keySize);
    }

    public static KeyPair generateKeyPair(Provider provider, String algorithm) {
        int keySize = "ECIES".equalsIgnoreCase(algorithm) ? 256 : 1024;
        return CryptoKeys.generateKeyPair(provider, algorithm, keySize);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return CryptoKeys.generateKeyPair(algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String provider, String algorithm, int keySize) {
        return CryptoKeys.generateKeyPair(provider, algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(Provider provider, String algorithm, int keySize) {
        return CryptoKeys.generateKeyPair(provider, algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        if ("SM2".equalsIgnoreCase(algorithm)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec(SM2_DEFAULT_CURVE);
            return CryptoKeys.generateKeyPair(algorithm, keySize, seed, sm2p256v1);
        }
        return CryptoKeys.generateKeyPair(algorithm, keySize, seed, (AlgorithmParameterSpec[])null);
    }

    public static KeyPair generateKeyPair(String provider, String algorithm, int keySize, byte[] seed) {
        if ("SM2".equalsIgnoreCase(algorithm)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec(SM2_DEFAULT_CURVE);
            return CryptoKeys.generateKeyPair(algorithm, keySize, seed, sm2p256v1);
        }
        return CryptoKeys.generateKeyPair(provider, algorithm, keySize, seed, (AlgorithmParameterSpec[])null);
    }

    public static KeyPair generateKeyPair(Provider provider, String algorithm, int keySize, byte[] seed) {
        if ("SM2".equalsIgnoreCase(algorithm)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec(SM2_DEFAULT_CURVE);
            return CryptoKeys.generateKeyPair(algorithm, keySize, seed, sm2p256v1);
        }
        return CryptoKeys.generateKeyPair(provider, algorithm, keySize, seed, (AlgorithmParameterSpec[])null);
    }

    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) {
        return CryptoKeys.generateKeyPair(algorithm, (byte[])null, params);
    }

    public static KeyPair generateKeyPair(String provider, String algorithm, AlgorithmParameterSpec params) {
        return CryptoKeys.generateKeyPair(provider, algorithm, (byte[])null, params);
    }

    public static KeyPair generateKeyPair(Provider provider, String algorithm, AlgorithmParameterSpec params) {
        return CryptoKeys.generateKeyPair(provider, algorithm, (byte[])null, params);
    }

    public static KeyPair generateKeyPair(String algorithm, byte[] seed, AlgorithmParameterSpec param) {
        return CryptoKeys.generateKeyPair(algorithm, 1024, seed, param);
    }

    public static KeyPair generateKeyPair(String provider, String algorithm, byte[] seed, AlgorithmParameterSpec param) {
        return CryptoKeys.generateKeyPair(provider, algorithm, 1024, seed, param);
    }

    public static KeyPair generateKeyPair(Provider provider, String algorithm, byte[] seed, AlgorithmParameterSpec param) {
        return CryptoKeys.generateKeyPair(provider, algorithm, 1024, seed, param);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        return CryptoKeys.generateKeyPair(algorithm, keySize, Randoms.createSecureRandom(seed), params);
    }

    public static KeyPair generateKeyPair(String provider, String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        return CryptoKeys.generateKeyPair(provider, algorithm, keySize, Randoms.createSecureRandom(seed), params);
    }

    public static KeyPair generateKeyPair(Provider provider, String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        return CryptoKeys.generateKeyPair(provider, algorithm, keySize, Randoms.createSecureRandom(seed), params);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = CryptoKeys.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = CryptoKeys.getKeyPairGenerator(algorithm);
        return CryptoKeys.getKeyPair(keyPairGen, algorithm, keySize, random, params);
    }

    public static KeyPair generateKeyPair(String provider, String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = CryptoKeys.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = CryptoKeys.getKeyPairGenerator(algorithm, provider);
        return CryptoKeys.getKeyPair(keyPairGen, algorithm, keySize, random, params);
    }

    public static KeyPair generateKeyPair(Provider provider, String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = CryptoKeys.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = CryptoKeys.getKeyPairGenerator(algorithm, provider);
        return CryptoKeys.getKeyPair(keyPairGen, algorithm, keySize, random, params);
    }

    private static KeyPair getKeyPair(KeyPairGenerator keyPairGen, String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec[] params) {
        try {
            if (keySize > 0) {
                if ("EC".equalsIgnoreCase(algorithm) && keySize > 256) {
                    keySize = 256;
                }
                if (null != random) {
                    keyPairGen.initialize(keySize, random);
                } else {
                    keyPairGen.initialize(keySize);
                }
            }
            if (Iterables.isNotEmpty(params)) {
                for (AlgorithmParameterSpec param : params) {
                    if (null == param) continue;
                    if (null != random) {
                        keyPairGen.initialize(param, random);
                        continue;
                    }
                    keyPairGen.initialize(param);
                }
            }
            return keyPairGen.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PrivateKey toPrivateKey(String algorithm, byte[] key) {
        try {
            return CryptoKeys.getKeyFactory(algorithm).generatePrivate(new PKCS8EncodedKeySpec(key));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PrivateKey toPrivateKey(String provider, String algorithm, byte[] key) {
        try {
            return CryptoKeys.getKeyFactory(algorithm, provider).generatePrivate(new PKCS8EncodedKeySpec(key));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PrivateKey toPrivateKey(Provider provider, String algorithm, byte[] key) {
        try {
            return CryptoKeys.getKeyFactory(algorithm, provider).generatePrivate(new PKCS8EncodedKeySpec(key));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PublicKey toPublicKey(String algorithm, byte[] key) {
        try {
            return CryptoKeys.getKeyFactory(algorithm).generatePublic(new X509EncodedKeySpec(key));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PublicKey toPublicKey(String provider, String algorithm, byte[] key) {
        try {
            return CryptoKeys.getKeyFactory(algorithm, provider).generatePublic(new X509EncodedKeySpec(key));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PublicKey toPublicKey(Provider provider, String algorithm, byte[] key) {
        try {
            return CryptoKeys.getKeyFactory(algorithm, provider).generatePublic(new X509EncodedKeySpec(key));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static RSAPrivateKey toRSAPrivateKey(RSAPublicKey rsaPublicKey) {
        try {
            return (RSAPrivateKey)CryptoKeys.getKeyFactory(AsymmetricAlgorithm.RSA.code()).generatePrivate(new RSAPrivateKeySpec(rsaPublicKey.getModulus(), rsaPublicKey.getPublicExponent()));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static RSAPrivateKey toRSAPrivateKey(String provider, RSAPublicKey rsaPublicKey) {
        try {
            return (RSAPrivateKey)CryptoKeys.getKeyFactory(AsymmetricAlgorithm.RSA.code(), provider).generatePrivate(new RSAPrivateKeySpec(rsaPublicKey.getModulus(), rsaPublicKey.getPublicExponent()));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static RSAPrivateKey toRSAPrivateKey(Provider provider, RSAPublicKey rsaPublicKey) {
        try {
            return (RSAPrivateKey)CryptoKeys.getKeyFactory(AsymmetricAlgorithm.RSA.code(), provider).generatePrivate(new RSAPrivateKeySpec(rsaPublicKey.getModulus(), rsaPublicKey.getPublicExponent()));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static RSAPublicKey toRSAPublicKey(RSAPrivateKey rsaPrivateKey) {
        try {
            return (RSAPublicKey)((Object)CryptoKeys.getKeyFactory(AsymmetricAlgorithm.RSA.code()).generatePrivate(new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPrivateExponent())));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static RSAPublicKey toRSAPublicKey(String provider, RSAPrivateKey rsaPrivateKey) {
        try {
            return (RSAPublicKey)((Object)CryptoKeys.getKeyFactory(AsymmetricAlgorithm.RSA.code(), provider).generatePrivate(new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPrivateExponent())));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static RSAPublicKey toRSAPublicKey(Provider provider, RSAPrivateKey rsaPrivateKey) {
        try {
            return (RSAPublicKey)((Object)CryptoKeys.getKeyFactory(AsymmetricAlgorithm.RSA.code(), provider).generatePrivate(new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPrivateExponent())));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static RSAPrivateKey toRSAPrivateKey(byte[] modulus, byte[] publicExponent) {
        try {
            return (RSAPrivateKey)CryptoKeys.getKeyFactory(AsymmetricAlgorithm.RSA.code()).generatePrivate(new RSAPrivateKeySpec(new BigInteger(modulus), new BigInteger(publicExponent)));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static RSAPublicKey toRSAPublicKey(byte[] modulus, byte[] publicExponent) {
        try {
            return (RSAPublicKey)CryptoKeys.getKeyFactory(AsymmetricAlgorithm.RSA.code()).generatePublic(new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(publicExponent)));
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PrivateKey readPrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey readPublicKeyByX509(String x509File) throws IOException {
        try (InputStream in = IO.getInputStream(x509File);){
            CertificateFactory factory = CertificateFactory.getInstance(CERT_TYPE_X509);
            Certificate cer = factory.generateCertificate(in);
            PublicKey publicKey = cer.getPublicKey();
            return publicKey;
        }
        catch (CertificateException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static PublicKey readPublicKeyByX509(InputStream in) {
        Certificate certificate = CryptoKeys.readX509Certificate(in);
        if (null != certificate) {
            return certificate.getPublicKey();
        }
        return null;
    }

    public static PublicKey readPublicKeyFile(String algorithm, String file) throws IOException {
        try (InputStream in = IO.getInputStream(file);){
            byte[] publicKeyBytes = IO.toBytes(in, 64);
            PublicKey publicKey = CryptoKeys.toPublicKey(algorithm, publicKeyBytes);
            return publicKey;
        }
    }

    public static KeyStore readJKSKeyStore(File keyFile, char[] password) throws IOException {
        return CryptoKeys.readKeyStore(KEY_TYPE_JKS, keyFile, password);
    }

    public static KeyStore readJKSKeyStore(InputStream in, char[] password) throws IOException {
        return CryptoKeys.readKeyStore(KEY_TYPE_JKS, in, password);
    }

    public static KeyStore readPKCS12KeyStore(File keyFile, char[] password) throws IOException {
        return CryptoKeys.readKeyStore(KEY_TYPE_PKCS12, keyFile, password);
    }

    public static KeyStore readPKCS12KeyStore(InputStream in, char[] password) throws IOException {
        return CryptoKeys.readKeyStore(KEY_TYPE_PKCS12, in, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore readKeyStore(String type, File keyFile, char[] password) throws IOException {
        BufferedInputStream in = null;
        try {
            in = IO.getInputStream(keyFile);
            KeyStore keyStore = CryptoKeys.readKeyStore(type, in, password);
            return keyStore;
        }
        finally {
            IO.close(in);
        }
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) throws IOException {
        try {
            KeyStore keyStore = CryptoKeys.getKeyStore(type);
            keyStore.load(in, password);
            return keyStore;
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyStore getKeyStore(String type) {
        try {
            return KeyStore.getInstance(type);
        }
        catch (KeyStoreException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static KeyPair getKeyPair(String type, InputStream in, char[] password, String alias) throws IOException {
        KeyStore keyStore = CryptoKeys.readKeyStore(type, in, password);
        return CryptoKeys.getKeyPair(keyStore, password, alias);
    }

    public static KeyPair getKeyPair(KeyStore keyStore, char[] password, String alias) {
        try {
            PublicKey publicKey = keyStore.getCertificate(alias).getPublicKey();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password);
            return new KeyPair(publicKey, privateKey);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) throws IOException {
        return CryptoKeys.readCertificate(CERT_TYPE_X509, in, password, alias);
    }

    public static Certificate readX509Certificate(InputStream in) {
        return CryptoKeys.readCertificate(CERT_TYPE_X509, in);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) throws IOException {
        KeyStore keyStore = CryptoKeys.readKeyStore(type, in, password);
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Certificate readCertificate(String type, InputStream in) {
        try {
            return CryptoKeys.getCertificateFactory(type).generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static CertificateFactory getCertificateFactory(String type) {
        try {
            return CertificateFactory.getInstance(type);
        }
        catch (CertificateException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    static {
        ICryptoProviderLoader.loadProviders();
    }
}

