/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.asymmetric;

import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.crypto.CryptoRuntimeException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class Signatures {
    public static Signature getSignature(String algorithm) {
        return CryptoKeys.getSignature(algorithm);
    }

    public static Signature getInitializedSignature(String algorithm, PrivateKey key) {
        Signature signature = Signatures.getSignature(algorithm);
        try {
            signature.initSign(key);
        }
        catch (InvalidKeyException e) {
            throw new CryptoRuntimeException(e);
        }
        return signature;
    }

    public static Signature getInitializedSignature(String algorithm, PublicKey key) {
        Signature signature = Signatures.getSignature(algorithm);
        try {
            signature.initVerify(key);
            return signature;
        }
        catch (InvalidKeyException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Signature doUpdate(Signature signature, byte[] data) {
        try {
            signature.update(data);
            return signature;
        }
        catch (SignatureException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static byte[] doSign(Signature signature, byte[] data) {
        try {
            signature.update(data);
            return signature.sign();
        }
        catch (SignatureException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static boolean doVerify(Signature signature, byte[] data, byte[] sign) {
        try {
            signature.update(data);
            return signature.verify(sign);
        }
        catch (SignatureException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static byte[] sign(String algorithm, PrivateKey key, byte[] data) {
        Signature signature = Signatures.getSignature(algorithm);
        try {
            signature.initSign(key);
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static boolean verify(String algorithm, PublicKey key, byte[] data, byte[] sign) {
        Signature signature = Signatures.getSignature(algorithm);
        try {
            signature.initVerify(key);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new CryptoRuntimeException(e);
        }
    }
}

