/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.data.buffer;

import io.polaris.core.data.buffer.BlockingQueueBuffer;
import io.polaris.core.data.buffer.BufferStrategy;
import io.polaris.core.data.buffer.IQueueBuffer;
import io.polaris.core.data.buffer.QueueBuffer;
import io.polaris.core.data.partition.IDataPartitioner;

public class BufferChannel<T> {
    private final IQueueBuffer<T>[] buffers;
    private final BufferStrategy strategy;
    private final long size;
    private int maxRetryCount = 3;
    private IDataPartitioner<T> dataPartitioner;

    public BufferChannel(int bufferCount, int bufferSize, IDataPartitioner<T> partitioner, BufferStrategy strategy) {
        this.dataPartitioner = partitioner;
        this.strategy = strategy;
        this.buffers = new IQueueBuffer[bufferCount];
        switch (strategy) {
            case BLOCKING: {
                for (int i = 0; i < bufferCount; ++i) {
                    this.buffers[i] = new BlockingQueueBuffer(bufferSize);
                }
                break;
            }
            case FAIL_FAST: {
                for (int i = 0; i < bufferCount; ++i) {
                    this.buffers[i] = new QueueBuffer(bufferSize, false);
                }
                break;
            }
            default: {
                for (int i = 0; i < bufferCount; ++i) {
                    this.buffers[i] = new QueueBuffer(bufferSize, true);
                }
            }
        }
        this.size = 1L * (long)bufferCount * (long)bufferSize;
    }

    public boolean produce(T data) {
        int index = this.dataPartitioner.partition(this.buffers.length, data);
        int retryCountDown = 1;
        if (BufferStrategy.FAIL_FAST.equals((Object)this.strategy) && this.maxRetryCount > 1) {
            retryCountDown = this.maxRetryCount;
        }
        while (retryCountDown > 0) {
            if (this.buffers[index].push(data)) {
                return true;
            }
            --retryCountDown;
        }
        return false;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public void setPartitioner(IDataPartitioner<T> dataPartitioner) {
        this.dataPartitioner = dataPartitioner;
    }

    public int getBufferCount() {
        return this.buffers.length;
    }

    public long size() {
        return this.size;
    }

    public IQueueBuffer<T> getBuffer(int index) {
        return this.buffers[index];
    }
}

