/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.env;

import io.polaris.core.env.DelegateEnv;
import io.polaris.core.env.Env;
import io.polaris.core.env.GroupEnv;
import io.polaris.core.env.StdEnvCustomizer;
import io.polaris.core.env.SystemEnvWrapper;
import io.polaris.core.env.SystemPropertiesWrapper;
import io.polaris.core.service.StatefulServiceLoader;
import io.polaris.core.string.Strings;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class StdEnv
implements Env {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final String SYSTEM_PROPS = "SystemProps";
    public static final String SYSTEM_ENV = "SystemEnv";
    public static final String DEFAULT = "Default";
    public static final String APP_ENV = "AppEnv";
    private GroupEnv runtime = new GroupEnv(null, true);
    private DelegateEnv appEnv = new DelegateEnv("AppEnv", null);
    private DelegateEnv defaults = new DelegateEnv("Default", null);
    private final AtomicBoolean customized = new AtomicBoolean(false);

    private StdEnv(String appConf) {
        this.runtime.addEnvLast(new SystemPropertiesWrapper(SYSTEM_PROPS));
        this.runtime.addEnvLast(new SystemEnvWrapper(SYSTEM_ENV));
        this.runtime.addEnvLast(this.appEnv);
        this.runtime.addEnvLast(this.defaults);
        if (appConf != null) {
            Env properties = this.loadProperties(APP_ENV, appConf);
            this.appEnv.setDelegate(properties);
        }
    }

    private Env loadProperties(String name, String appConf) {
        if (appConf != null) {
            GroupEnv group = new GroupEnv(name);
            try {
                try (FileInputStream fis2 = new FileInputStream(appConf);){
                    Properties properties = new Properties();
                    properties.load(fis2);
                    if (!properties.isEmpty()) {
                        group.addEnvLast(Env.wrap(properties));
                    }
                }
                catch (IOException fis2) {
                    // empty catch block
                }
                Properties propInDir = null;
                Properties propInJar = null;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Enumeration<URL> urls = classLoader.getResources(appConf);
                while (urls.hasMoreElements()) {
                    Properties prop;
                    URL url = urls.nextElement();
                    if ("file".equals(url.getProtocol())) {
                        if (propInDir == null) {
                            propInDir = new Properties();
                        }
                        prop = propInDir;
                    } else {
                        if (propInJar == null) {
                            propInJar = new Properties();
                        }
                        prop = propInJar;
                    }
                    try {
                        InputStream in = url.openStream();
                        Throwable throwable = null;
                        try {
                            Properties properties = new Properties();
                            properties.load(in);
                            if (properties.isEmpty()) continue;
                            for (String key : properties.stringPropertyNames()) {
                                prop.putIfAbsent(key, properties.get(key));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (propInDir != null) {
                    group.addEnvLast(Env.wrap(propInDir));
                }
                if (propInJar != null) {
                    group.addEnvLast(Env.wrap(propInJar));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return group;
        }
        return null;
    }

    public void setAppEnv(Env appEnv) {
        this.runtime.replaceEnv(APP_ENV, appEnv);
    }

    public static StdEnv newInstance() {
        return new StdEnv(null);
    }

    public static StdEnv newInstance(String conf) {
        return new StdEnv(conf);
    }

    public StdEnv withCustomizer() {
        if (this.customized.compareAndSet(false, true)) {
            try {
                StatefulServiceLoader<StdEnvCustomizer> loader = StatefulServiceLoader.load(StdEnvCustomizer.class);
                for (StdEnvCustomizer customizer : loader) {
                    customizer.customize(this);
                }
            }
            catch (Throwable e) {
                this.customized.set(false);
                throw e;
            }
        }
        return this;
    }

    @Override
    public Set<String> keys() {
        return this.runtime.keys();
    }

    @Override
    public void set(String key, String value) {
        this.runtime.set(key, value);
    }

    @Override
    public void remove(String key) {
        this.runtime.remove(key);
    }

    public void setDefaults(Env defaults) {
        this.defaults.setDelegate(defaults);
    }

    public void setDefaults(String key, String value) {
        if (this.defaults.getDelegate() == null) {
            this.defaults.setDelegate(Env.wrap(new Properties()));
        }
        this.defaults.set(key, value);
    }

    public void addEnvFirst(Env env) {
        this.runtime.addEnvFirst(env);
    }

    public void addEnvLast(Env env) {
        this.runtime.addEnvBefore(DEFAULT, env);
    }

    public boolean addEnvBefore(String name, Env env) {
        return this.runtime.addEnvBefore(name, env);
    }

    public boolean addEnvAfter(String name, Env env) {
        return this.runtime.addEnvAfter(name, env);
    }

    public boolean replaceEnv(String name, Env env) {
        return this.runtime.replaceEnv(name, env);
    }

    public boolean removeEnv(String name) {
        return this.runtime.removeEnv(name);
    }

    @Override
    public String get(String key) {
        String val = this.runtime.get(key);
        try {
            if (val != null) {
                val = this.resolveRef(val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private boolean isInvalidPropertyValue(String val) {
        return Strings.isBlank(val);
    }

    @Override
    public String get(String key, String defaultVal) {
        String val = this.get(key);
        return val != null ? val : defaultVal;
    }

    public String getOrEmpty(String key) {
        String val = this.get(key);
        return val != null ? val : "";
    }

    public String getOrDefault(String key, String defaultVal) {
        String val = this.get(key);
        return val != null ? val : defaultVal;
    }

    public String getOrDefaultIfEmpty(String key, String defaultVal) {
        String val = this.get(key);
        return Strings.isNotEmpty(val) ? val : defaultVal;
    }

    public String getOrDefaultIfBlank(String key, String defaultVal) {
        String val = this.get(key);
        return Strings.isNotBlank(val) ? val : defaultVal;
    }

    public String resolveRef(String origin, Function<String, String> getter) {
        return Strings.resolvePlaceholders(origin, getter, false);
    }

    public String resolveRef(String origin) {
        return this.resolveRef(origin, this::get);
    }

    public String resolveRef(String origin, Map<String, String> map) {
        return this.resolveRef(origin, map::get);
    }

    public String resolveRef(String origin, Properties env) {
        return this.resolveRef(origin, env::getProperty);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        String val = this.get(key);
        return this.isInvalidPropertyValue(val) ? defaultVal : Boolean.parseBoolean(val);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultVal) {
        try {
            String val = this.get(key);
            return this.isInvalidPropertyValue(val) ? defaultVal : Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultVal) {
        try {
            String val = this.get(key);
            return this.isInvalidPropertyValue(val) ? defaultVal : Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public LocalDate getLocalDate(String key, String defaultVal) {
        String val = this.get(key, defaultVal);
        LocalDate localDate = LocalDate.parse(val, DATE_FORMATTER);
        return localDate;
    }

    public LocalDateTime getLocalDateTime(String key, String defaultVal) {
        String val = this.get(key, defaultVal);
        LocalDateTime localDate = LocalDateTime.parse(val, DATE_TIME_FORMATTER);
        return localDate;
    }

    public LocalTime getLocalTime(String key, String defaultVal) {
        String val = this.get(key, defaultVal);
        LocalTime localDate = LocalTime.parse(val, TIME_FORMATTER);
        return localDate;
    }

    public Date getDate(String key, String defaultVal) {
        LocalDate localDate = this.getLocalDate(key, defaultVal);
        Instant instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public Timestamp getDateTime(String key, String defaultVal) {
        LocalDateTime localDateTime = this.getLocalDateTime(key, defaultVal);
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Timestamp.from(instant);
    }

    public Time getTime(String key, String defaultVal) {
        LocalDateTime localDateTime = this.getLocalTime(key, defaultVal).atDate(LocalDate.now());
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return new Time(instant.toEpochMilli());
    }

    public String[] getArray(String key) {
        return this.getArray(key, null);
    }

    public String[] getArray(String key, String[] defaultVal) {
        String val = this.get(key);
        return this.isInvalidPropertyValue(val) ? defaultVal : val.split("[,|\r\n]+");
    }
}

