/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.env;

import io.polaris.core.env.InternalProperties;
import io.polaris.core.string.Strings;
import java.util.Objects;
import java.util.StringJoiner;

public class Version
implements Comparable<Version> {
    private static final Version CURRENT;
    private final int major;
    private final int minor;
    private final int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Version(String version) {
        String[] arr = version.replaceAll("[^.\\d]", "").split("\\.");
        String[] vs = new String[]{"0", "0", "0"};
        System.arraycopy(arr, 0, vs, 0, vs.length);
        int major = 0;
        int minor = 0;
        int patch = 0;
        try {
            major = Integer.parseInt(vs[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            minor = Integer.parseInt(vs[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            patch = Integer.parseInt(vs[2]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version current() {
        return CURRENT;
    }

    public int asInt() {
        return (this.major & 0xFF) << 24 | (this.minor & 0xFF) << 16 | this.patch & 0xFFFF;
    }

    public String toString() {
        return new StringJoiner(".").add(Objects.toString(this.major)).add(Objects.toString(this.minor)).add(Objects.toString(this.patch)).toString();
    }

    @Override
    public int compareTo(Version another) {
        return Version.compare(this, another);
    }

    public static int compare(Version x, Version y) {
        if (x.major < y.major) {
            return -1;
        }
        if (x.major > y.major) {
            return 1;
        }
        if (x.minor < y.minor) {
            return -1;
        }
        if (x.minor > y.minor) {
            return 1;
        }
        if (x.patch < y.patch) {
            return -1;
        }
        if (x.patch > y.patch) {
            return 1;
        }
        return 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.major;
        result = result * 59 + this.minor;
        result = result * 59 + this.patch;
        return result;
    }

    static {
        String version = Version.class.getPackage().getImplementationVersion();
        if (Strings.isBlank(version)) {
            version = InternalProperties.INSTANCE.getProperty("version");
        }
        if (Strings.isBlank(version)) {
            version = "0.0.0";
        }
        CURRENT = new Version(version);
    }
}

