/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.err;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class Exceptions {
    public static <T extends Exception> T of(Throwable t, Class<T> type, Function<Throwable, T> builder) {
        if (t == null) {
            return (T)((Exception)builder.apply(t));
        }
        if (type.isAssignableFrom(t.getClass())) {
            return (T)((Exception)t);
        }
        while (t.getCause() != null) {
            if (!type.isAssignableFrom((t = t.getCause()).getClass())) continue;
            return (T)((Exception)t);
        }
        return (T)((Exception)builder.apply(t));
    }

    public static <T extends Exception> T of(Throwable t, Class<T> type, Supplier<T> builder) {
        if (t == null) {
            return (T)((Exception)builder.get());
        }
        if (type.isAssignableFrom(t.getClass())) {
            return (T)((Exception)t);
        }
        while (t.getCause() != null) {
            if (!type.isAssignableFrom((t = t.getCause()).getClass())) continue;
            return (T)((Exception)t);
        }
        return (T)((Exception)builder.get());
    }

    public static Throwable getRootCauseUntil(@Nonnull Throwable t, Predicate<Throwable> predicate) {
        while (t.getCause() != null) {
            if (!predicate.test(t = t.getCause())) continue;
            return t;
        }
        return t;
    }

    public static Throwable getRootCause(@Nonnull Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static Throwable getRootCauseSafely(@Nonnull Throwable t) {
        HashSet<Throwable> set = new HashSet<Throwable>();
        while (t.getCause() != null && !set.contains(t)) {
            set.add(t);
            t = t.getCause();
        }
        return t;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

