/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.guid;

import io.polaris.core.guid.GuidNodeStrategy;
import io.polaris.core.guid.LocalNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class LocalNodeStrategy
implements GuidNodeStrategy {
    private static final Map<String, LocalNodeStrategy> cache = new ConcurrentHashMap<String, LocalNodeStrategy>();
    private final String appName;
    private final int nodeId;
    private final int bizSize;

    private LocalNodeStrategy(String appName) {
        this.appName = appName;
        this.bizSize = 12;
        this.nodeId = LocalNode.nextNodeId(appName, 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalNodeStrategy getInstance(@Nullable String name) {
        LocalNodeStrategy o = cache.get(name = String.valueOf(name));
        if (o == null) {
            Map<String, LocalNodeStrategy> map = cache;
            synchronized (map) {
                o = cache.get(name);
                if (o == null) {
                    o = new LocalNodeStrategy(name);
                    cache.put(name, o);
                }
            }
        }
        return o;
    }

    @Override
    public int bitSize() {
        return this.bizSize;
    }

    @Override
    public int nodeId() {
        return this.nodeId;
    }
}

