/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.io.image;

import io.polaris.core.assertion.Assertions;
import io.polaris.core.codec.Base64;
import io.polaris.core.io.Filenames;
import io.polaris.core.io.IO;
import io.polaris.core.io.image.BackgroundRemoval;
import io.polaris.core.io.image.Colors;
import io.polaris.core.io.image.Fonts;
import io.polaris.core.io.image.GraphicsOps;
import io.polaris.core.io.image.ImageEditor;
import io.polaris.core.lang.Numbers;
import io.polaris.core.lang.Objs;
import io.polaris.core.string.Strings;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;

public class Images {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";

    public static void scale(File srcImageFile, File destImageFile, float scale) throws IOException {
        Images.scale((Image)Images.read(srcImageFile), destImageFile, scale);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, float scale) throws IOException {
        Images.scale((Image)Images.read(srcStream), destStream, scale);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale) throws IOException {
        Images.scale((Image)Images.read(srcStream), destStream, scale);
    }

    public static void scale(Image srcImg, File destFile, float scale) throws IOException {
        ImageEditor.from(srcImg).setTargetImageType(Filenames.extName(destFile)).scale(scale).write(destFile);
    }

    public static void scale(Image srcImg, OutputStream out, float scale) throws IOException {
        Images.scale(srcImg, Images.getImageOutputStream(out), scale);
    }

    public static void scale(Image srcImg, ImageOutputStream destImageStream, float scale) throws IOException {
        Images.writeJpg(Images.scale(srcImg, scale), destImageStream);
    }

    public static Image scale(Image srcImg, float scale) {
        return ImageEditor.from(srcImg).scale(scale).getImg();
    }

    public static Image scale(Image srcImg, int width, int height) {
        return ImageEditor.from(srcImg).scale(width, height).getImg();
    }

    public static void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws IOException {
        ImageEditor.from(srcImageFile).setTargetImageType(Filenames.extName(destImageFile)).scale(width, height, fixedColor).write(destImageFile);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws IOException {
        Images.scale(Images.read(srcStream), Images.getImageOutputStream(destStream), width, height, fixedColor);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws IOException {
        Images.scale(Images.read(srcStream), destStream, width, height, fixedColor);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws IOException {
        Images.writeJpg(Images.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        return ImageEditor.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle) throws IOException {
        Images.cut((Image)Images.read(srcImgFile), destImgFile, rectangle);
    }

    public static void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle) throws IOException {
        Images.cut((Image)Images.read(srcStream), destStream, rectangle);
    }

    public static void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle) throws IOException {
        Images.cut((Image)Images.read(srcStream), destStream, rectangle);
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle) throws IOException {
        Images.write(Images.cut(srcImage, rectangle), destFile);
    }

    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws IOException {
        Images.cut(srcImage, Images.getImageOutputStream(out), rectangle);
    }

    public static void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle) throws IOException {
        Images.writeJpg(Images.cut(srcImage, rectangle), destImageStream);
    }

    public static Image cut(Image srcImage, Rectangle rectangle) {
        return ImageEditor.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static Image cut(Image srcImage, int x, int y) {
        return Images.cut(srcImage, x, y, -1);
    }

    public static Image cut(Image srcImage, int x, int y, int radius) {
        return ImageEditor.from(srcImage).cut(x, y, radius).getImg();
    }

    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) throws IOException {
        Images.slice(Images.read(srcImageFile), descDir, destWidth, destHeight);
    }

    public static void slice(Image srcImage, File descDir, int destWidth, int destHeight) throws IOException {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        if (srcWidth < destWidth) {
            destWidth = srcWidth;
        }
        if (srcHeight < destHeight) {
            destHeight = srcHeight;
        }
        int cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor((double)srcWidth / (double)destWidth) + 1;
        int rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor((double)srcHeight / (double)destHeight) + 1;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image tag = Images.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                Images.write(tag, new File(descDir, "_r" + i + "_c" + j + ".jpg"));
            }
        }
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, int rows, int cols) throws IOException {
        Images.sliceByRowsAndCols(srcImageFile, destDir, IMAGE_TYPE_JPEG, rows, cols);
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, String format, int rows, int cols) throws IOException {
        Images.sliceByRowsAndCols(ImageIO.read(srcImageFile), destDir, format, rows, cols);
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, int rows, int cols) throws IOException {
        Images.sliceByRowsAndCols(srcImage, destDir, IMAGE_TYPE_JPEG, rows, cols);
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, String format, int rows, int cols) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdirs();
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        if (rows <= 0 || rows > 20) {
            rows = 2;
        }
        if (cols <= 0 || cols > 20) {
            cols = 2;
        }
        BufferedImage bi = Images.toBufferedImage(srcImage);
        int srcWidth = bi.getWidth();
        int srcHeight = bi.getHeight();
        int destWidth = Numbers.partValue(srcWidth, cols);
        int destHeight = Numbers.partValue(srcHeight, rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image tag = Images.cut(bi, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                ImageIO.write(Images.toRenderedImage(tag), format, new File(destDir, "_r" + i + "_c" + j + "." + format));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File destImageFile) throws IOException {
        Objects.requireNonNull(srcImageFile);
        Objects.requireNonNull(destImageFile);
        Assertions.assertFalse(srcImageFile.equals(destImageFile), "Src file is equals to dest file!");
        String srcExtName = Filenames.extName(srcImageFile);
        String destExtName = Filenames.extName(destImageFile);
        if (Strings.equalsIgnoreCase(srcExtName, destExtName)) {
            Files.copy(srcImageFile.toPath(), destImageFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = Images.getImageOutputStream(destImageFile);
            Images.convert(Images.read(srcImageFile), destExtName, imageOutputStream, Strings.equalsIgnoreCase(IMAGE_TYPE_PNG, srcExtName));
        }
        finally {
            IO.close(imageOutputStream);
        }
    }

    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) throws IOException {
        Images.write((Image)Images.read(srcStream), formatName, Images.getImageOutputStream(destStream));
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) throws IOException {
        ImageIO.write((RenderedImage)(isSrcPng ? Images.copyImage(srcImage, 1) : Images.toBufferedImage(srcImage)), formatName, destImageStream);
    }

    public static void gray(File srcImageFile, File destImageFile) throws IOException {
        Images.gray((Image)Images.read(srcImageFile), destImageFile);
    }

    public static void gray(InputStream srcStream, OutputStream destStream) throws IOException {
        Images.gray((Image)Images.read(srcStream), Images.getImageOutputStream(destStream));
    }

    public static void gray(ImageInputStream srcStream, ImageOutputStream destStream) throws IOException {
        Images.gray((Image)Images.read(srcStream), destStream);
    }

    public static void gray(Image srcImage, File outFile) throws IOException {
        Images.write(Images.gray(srcImage), outFile);
    }

    public static void gray(Image srcImage, OutputStream out) throws IOException {
        Images.gray(srcImage, Images.getImageOutputStream(out));
    }

    public static void gray(Image srcImage, ImageOutputStream destImageStream) throws IOException {
        Images.writeJpg(Images.gray(srcImage), destImageStream);
    }

    public static Image gray(Image srcImage) {
        return ImageEditor.from(srcImage).gray().getImg();
    }

    public static void binary(File srcImageFile, File destImageFile) throws IOException {
        Images.binary(Images.read(srcImageFile), destImageFile);
    }

    public static void binary(InputStream srcStream, OutputStream destStream, String imageType) throws IOException {
        Images.binary((Image)Images.read(srcStream), Images.getImageOutputStream(destStream), imageType);
    }

    public static void binary(ImageInputStream srcStream, ImageOutputStream destStream, String imageType) throws IOException {
        Images.binary((Image)Images.read(srcStream), destStream, imageType);
    }

    public static void binary(Image srcImage, File outFile) throws IOException {
        Images.write(Images.binary(srcImage), outFile);
    }

    public static void binary(Image srcImage, OutputStream out, String imageType) throws IOException {
        Images.binary(srcImage, Images.getImageOutputStream(out), imageType);
    }

    public static void binary(Image srcImage, ImageOutputStream destImageStream, String imageType) throws IOException {
        Images.write(Images.binary(srcImage), imageType, destImageStream);
    }

    public static Image binary(Image srcImage) {
        return ImageEditor.from(srcImage).binary().getImg();
    }

    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws IOException {
        Images.pressText((Image)Images.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) throws IOException {
        Images.pressText((Image)Images.read(srcStream), Images.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
    }

    public static void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) throws IOException {
        Images.pressText((Image)Images.read(srcStream), destStream, pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws IOException {
        Images.write(Images.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws IOException {
        Images.pressText(srcImage, Images.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws IOException {
        Images.writeJpg(Images.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static Image pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        return ImageEditor.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    public static void pressImage(File srcImageFile, File destImageFile, Image pressImg, int x, int y, float alpha) throws IOException {
        Images.pressImage((Image)Images.read(srcImageFile), destImageFile, pressImg, x, y, alpha);
    }

    public static void pressImage(InputStream srcStream, OutputStream destStream, Image pressImg, int x, int y, float alpha) throws IOException {
        Images.pressImage((Image)Images.read(srcStream), Images.getImageOutputStream(destStream), pressImg, x, y, alpha);
    }

    public static void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImg, int x, int y, float alpha) throws IOException {
        Images.pressImage((Image)Images.read(srcStream), destStream, pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImg, int x, int y, float alpha) throws IOException {
        Images.write(Images.pressImage(srcImage, pressImg, x, y, alpha), outFile);
    }

    public static void pressImage(Image srcImage, OutputStream out, Image pressImg, int x, int y, float alpha) throws IOException {
        Images.pressImage(srcImage, Images.getImageOutputStream(out), pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImg, int x, int y, float alpha) throws IOException {
        Images.writeJpg(Images.pressImage(srcImage, pressImg, x, y, alpha), destImageStream);
    }

    public static Image pressImage(Image srcImage, Image pressImg, int x, int y, float alpha) {
        return ImageEditor.from(srcImage).pressImage(pressImg, x, y, alpha).getImg();
    }

    public static Image pressImage(Image srcImage, Image pressImg, Rectangle rectangle, float alpha) {
        return ImageEditor.from(srcImage).pressImage(pressImg, rectangle, alpha).getImg();
    }

    public static void rotate(File imageFile, int degree, File outFile) throws IOException {
        Images.rotate((Image)Images.read(imageFile), degree, outFile);
    }

    public static void rotate(Image image, int degree, File outFile) throws IOException {
        Images.write(Images.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws IOException {
        Images.writeJpg(Images.rotate(image, degree), Images.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws IOException {
        Images.writeJpg(Images.rotate(image, degree), out);
    }

    public static Image rotate(Image image, int degree) {
        return ImageEditor.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) throws IOException {
        Images.flip((Image)Images.read(imageFile), outFile);
    }

    public static void flip(Image image, File outFile) throws IOException {
        Images.write(Images.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws IOException {
        Images.flip(image, Images.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws IOException {
        Images.writeJpg(Images.flip(image), out);
    }

    public static Image flip(Image image) {
        return ImageEditor.from(image).flip().getImg();
    }

    public static void compress(File imageFile, File outFile, float quality) throws IOException {
        ImageEditor.from(imageFile).setQuality(quality).write(outFile);
    }

    public static RenderedImage toRenderedImage(Image img) {
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return Images.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return Images.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        return Images.toBufferedImage(image, imageType, null);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType, Color backgroundColor) {
        int type = IMAGE_TYPE_PNG.equalsIgnoreCase(imageType) ? 2 : 1;
        return Images.toBufferedImage(image, type, backgroundColor);
    }

    public static BufferedImage toBufferedImage(Image image, int imageType) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = Images.copyImage(image, imageType);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = Images.copyImage(image, imageType);
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image, int imageType, Color backgroundColor) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = Images.copyImage(image, imageType, backgroundColor);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = Images.copyImage(image, imageType, backgroundColor);
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image img, int imageType) {
        return Images.copyImage(img, imageType, null);
    }

    public static BufferedImage copyImage(Image img, int imageType, Color backgroundColor) {
        img = new ImageIcon(img).getImage();
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = GraphicsOps.createGraphics(bimage, backgroundColor);
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) throws HeadlessException {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage toImage(String base64) throws IOException {
        return Images.toImage(Base64.decode(base64));
    }

    public static BufferedImage toImage(byte[] imageBytes) throws IOException {
        return Images.read(new ByteArrayInputStream(imageBytes));
    }

    public static ByteArrayInputStream toStream(Image image, String imageType) throws IOException {
        return IO.toStream(Images.toBytes(image, imageType));
    }

    public static String toBase64DataUri(Image image, String imageType) throws IOException {
        return Images.toBase64ImageDataUri(imageType, Images.toBase64(image, imageType));
    }

    public static String toBase64ImageDataUri(String imageType, String base64Data) {
        return "data:image/" + imageType + ";base64," + base64Data;
    }

    public static String toBase64DataUri(String mimeType, String base64Data) {
        return "data:" + mimeType + ";base64," + base64Data;
    }

    public static String toBase64(Image image, String imageType) throws IOException {
        return Base64.encodeToString(Images.toBytes(image, imageType));
    }

    public static byte[] toBytes(Image image, String imageType) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Images.write(image, imageType, out);
        return out.toByteArray();
    }

    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) throws IOException {
        Images.writePng((Image)Images.createImage(str, font, backgroundColor, fontColor, 2), out);
    }

    public static void createTransparentImage(String str, Font font, Color fontColor, ImageOutputStream out) throws IOException {
        Images.writePng((Image)Images.createImage(str, font, null, fontColor, 2), out);
    }

    public static BufferedImage createImage(String str, Font font, Color backgroundColor, Color fontColor, int imageType) throws IOException {
        Rectangle2D r = Images.getRectangle(str, font);
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics g = image.getGraphics();
        if (null != backgroundColor) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(Objs.defaultIfNull(fontColor, Color.BLACK));
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        return image;
    }

    public static Rectangle2D getRectangle(String str, Font font) {
        return font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }

    public static Font createFont(File fontFile) {
        return Fonts.createFont(fontFile);
    }

    public static Font createFont(InputStream fontStream) {
        return Fonts.createFont(fontStream);
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        return GraphicsOps.createGraphics(image, color);
    }

    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws IOException {
        Images.write(image, IMAGE_TYPE_JPG, destImageStream);
    }

    public static void writePng(Image image, ImageOutputStream destImageStream) throws IOException {
        Images.write(image, IMAGE_TYPE_PNG, destImageStream);
    }

    public static void writeJpg(Image image, OutputStream out) throws IOException {
        Images.write(image, IMAGE_TYPE_JPG, out);
    }

    public static void writePng(Image image, OutputStream out) throws IOException {
        Images.write(image, IMAGE_TYPE_PNG, out);
    }

    public static void write(ImageInputStream srcStream, String formatName, ImageOutputStream destStream) throws IOException {
        Images.write((Image)Images.read(srcStream), formatName, destStream);
    }

    public static void write(Image image, String imageType, OutputStream out) throws IOException {
        Images.write(image, imageType, Images.getImageOutputStream(out));
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) throws IOException {
        return Images.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) throws IOException {
        return Images.write(image, imageType, destImageStream, quality, null);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality, Color backgroundColor) throws IOException {
        if (Strings.isBlank(imageType)) {
            imageType = IMAGE_TYPE_JPG;
        }
        BufferedImage bufferedImage = Images.toBufferedImage(image, imageType, backgroundColor);
        ImageWriter writer = Images.getWriter(bufferedImage, imageType);
        return Images.write((Image)bufferedImage, writer, destImageStream, quality);
    }

    public static void write(Image image, File targetFile) throws IOException {
        Files.createDirectories(targetFile.getParentFile().toPath(), new FileAttribute[0]);
        Files.createFile(targetFile.toPath(), new FileAttribute[0]);
        ImageOutputStream out = null;
        try {
            out = Images.getImageOutputStream(targetFile);
            Images.write(image, Filenames.extName(targetFile), out);
        }
        finally {
            IO.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) throws IOException {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = Images.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(String imageFilePath) throws IOException {
        return Images.read(new File(imageFilePath));
    }

    public static BufferedImage read(File imageFile) throws IOException {
        BufferedImage result = ImageIO.read(imageFile);
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + imageFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static Image getImage(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public static BufferedImage read(InputStream imageStream) throws IOException {
        BufferedImage result = ImageIO.read(imageStream);
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(ImageInputStream imageStream) throws IOException {
        BufferedImage result = ImageIO.read(imageStream);
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(URL imageUrl) throws IOException {
        BufferedImage result = ImageIO.read(imageUrl);
        if (null == result) {
            throw new IllegalArgumentException("Image type of [" + imageUrl + "] is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws IOException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws IOException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + outFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws IOException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(in);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageWriter getWriter(Image img, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(Images.toBufferedImage(img, formatName));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageWriter getWriter(String formatName) {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static String toHex(Color color) {
        return Colors.toHex(color);
    }

    public static String toHex(int r, int g, int b) {
        return Colors.toHex(r, g, b);
    }

    public static Color hexToColor(String hex) {
        return Colors.hexToColor(hex);
    }

    public static Color getColor(int rgb) {
        return Colors.getColor(rgb);
    }

    public static Color getColor(String colorName) {
        return Colors.getColor(colorName);
    }

    public static Color randomColor() {
        return Colors.randomColor();
    }

    public static Color randomColor(Random random) {
        return Colors.randomColor(random);
    }

    public static Point getPointBaseCentre(Rectangle rectangle, int backgroundWidth, int backgroundHeight) {
        return new Point(rectangle.x + Math.abs(backgroundWidth - rectangle.width) / 2, rectangle.y + Math.abs(backgroundHeight - rectangle.height) / 2);
    }

    public static String getMainColor(BufferedImage image, int[] ... rgbFilters) {
        return Colors.getMainColor(image, rgbFilters);
    }

    public static boolean backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(inputPath, outputPath, tolerance);
    }

    public static boolean backgroundRemoval(File input, File output, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(input, output, tolerance);
    }

    public static boolean backgroundRemoval(File input, File output, Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(input, output, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(bufferedImage, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(ByteArrayOutputStream outputStream, Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(outputStream, override, tolerance);
    }

    public static BufferedImage colorConvert(ColorSpace colorSpace, BufferedImage image) {
        return Images.filter(new ColorConvertOp(colorSpace, null), image);
    }

    public static BufferedImage transform(AffineTransform xform, BufferedImage image) {
        return Images.filter(new AffineTransformOp(xform, null), image);
    }

    public static BufferedImage filter(BufferedImageOp op, BufferedImage image) {
        return op.filter(image, null);
    }

    public static Image filter(ImageFilter filter, Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter));
    }
}

