/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc;

import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.ExpressionMeta;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class TableMeta
implements Cloneable {
    private final Class<?> entityClass;
    private final String schema;
    private final String catalog;
    private final String table;
    private final String alias;
    private final Map<String, ColumnMeta> columns;
    private final Map<String, ColumnMeta> pkColumns;
    private final Map<String, ExpressionMeta> expressions;

    public TableMeta(Class<?> entityClass, String schema, String catalog, String table, String alias, Map<String, ColumnMeta> columns, Map<String, ExpressionMeta> expressions) {
        this.entityClass = entityClass;
        this.schema = schema;
        this.catalog = catalog;
        this.table = table;
        this.alias = alias == null ? "" : alias;
        String canonicalName = columns.getClass().getName();
        this.columns = canonicalName.equals("java.util.Collections$UnmodifiableMap") ? columns : Collections.unmodifiableMap(columns);
        canonicalName = expressions.getClass().getName();
        this.expressions = canonicalName.equals("java.util.Collections$UnmodifiableMap") ? expressions : Collections.unmodifiableMap(expressions);
        HashMap pkColumns = new HashMap();
        columns.forEach((key, value) -> {
            if (value.isPrimaryKey()) {
                pkColumns.put(key, value);
            }
        });
        this.pkColumns = Collections.unmodifiableMap(pkColumns);
    }

    public static Builder builder() {
        return new Builder();
    }

    public TableMeta clone() {
        HashMap cloneColumns = new HashMap();
        HashMap cloneExpressions = new HashMap();
        this.columns.forEach((key, value) -> cloneColumns.put(key, value.clone()));
        this.expressions.forEach((key, value) -> cloneExpressions.put(key, value.clone()));
        return TableMeta.builder().entityClass(this.entityClass).schema(this.schema).catalog(this.catalog).table(this.table).alias(this.alias).columns(Collections.unmodifiableMap(cloneColumns)).expressions(Collections.unmodifiableMap(cloneExpressions)).build();
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getTable() {
        return this.table;
    }

    public String getAlias() {
        return this.alias;
    }

    public Map<String, ColumnMeta> getColumns() {
        return this.columns;
    }

    public Map<String, ColumnMeta> getPkColumns() {
        return this.pkColumns;
    }

    public Map<String, ExpressionMeta> getExpressions() {
        return this.expressions;
    }

    public String toString() {
        return "TableMeta(entityClass=" + this.entityClass + ", schema=" + this.schema + ", catalog=" + this.catalog + ", table=" + this.table + ", alias=" + this.alias + ", columns=" + this.columns + ", pkColumns=" + this.pkColumns + ", expressions=" + this.expressions + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableMeta)) {
            return false;
        }
        TableMeta other = (TableMeta)o;
        Class<?> this$entityClass = this.entityClass;
        Class<?> other$entityClass = other.entityClass;
        if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
            return false;
        }
        String this$schema = this.schema;
        String other$schema = other.schema;
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$catalog = this.catalog;
        String other$catalog = other.catalog;
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$table = this.table;
        String other$table = other.table;
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$alias = this.alias;
        String other$alias = other.alias;
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Map<String, ColumnMeta> this$columns = this.columns;
        Map<String, ColumnMeta> other$columns = other.columns;
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, ColumnMeta> this$pkColumns = this.pkColumns;
        Map<String, ColumnMeta> other$pkColumns = other.pkColumns;
        if (this$pkColumns == null ? other$pkColumns != null : !((Object)this$pkColumns).equals(other$pkColumns)) {
            return false;
        }
        Map<String, ExpressionMeta> this$expressions = this.expressions;
        Map<String, ExpressionMeta> other$expressions = other.expressions;
        return !(this$expressions == null ? other$expressions != null : !((Object)this$expressions).equals(other$expressions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $entityClass = this.entityClass;
        result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
        String $schema = this.schema;
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $catalog = this.catalog;
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $table = this.table;
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $alias = this.alias;
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Map<String, ColumnMeta> $columns = this.columns;
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, ColumnMeta> $pkColumns = this.pkColumns;
        result = result * 59 + ($pkColumns == null ? 43 : ((Object)$pkColumns).hashCode());
        Map<String, ExpressionMeta> $expressions = this.expressions;
        result = result * 59 + ($expressions == null ? 43 : ((Object)$expressions).hashCode());
        return result;
    }

    public static final class Builder {
        private Class<?> entityClass;
        private String schema;
        private String catalog;
        private String table;
        private String alias;
        private Map<String, ColumnMeta> columns;
        private Map<String, ExpressionMeta> expressions;

        private Builder() {
        }

        public TableMeta build() {
            return new TableMeta(this.entityClass, this.schema, this.catalog, this.table, this.alias, this.columns, this.expressions);
        }

        public Builder entityClass(Class<?> entityClass) {
            this.entityClass = entityClass;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder columns(Map<String, ColumnMeta> columns) {
            this.columns = columns;
            return this;
        }

        public Builder expressions(Map<String, ExpressionMeta> expressions) {
            this.expressions = expressions;
            return this;
        }
    }
}

