/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.BeanCompositeMapping;
import io.polaris.core.jdbc.base.BeanPropertyMapping;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.bean.MetaObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BeanMapping<T> {
    private MetaObject<T> metaObject;
    private List<BeanPropertyMapping> columns;
    private List<BeanCompositeMapping<?>> composites;
    private boolean caseInsensitive = true;
    private boolean caseCamel = true;
    private int caseModel;

    public BeanMapping() {
    }

    public BeanMapping(Class<T> javaType) {
        this.javaType(JavaType.of(javaType));
    }

    public BeanMapping(JavaType<T> javaType) {
        this.javaType(javaType);
    }

    public boolean isValid() {
        return this.metaObject != null;
    }

    public void prepare() {
        Iterator<Object> it;
        this.caseModel = MetaObject.buildCaseModel(this.caseInsensitive, this.caseCamel);
        if (this.columns != null) {
            it = this.columns.iterator();
            while (it.hasNext()) {
                BeanPropertyMapping col = (BeanPropertyMapping)it.next();
                if (col.isValid()) continue;
                it.remove();
            }
        }
        if (this.composites != null) {
            it = this.composites.iterator();
            while (it.hasNext()) {
                BeanCompositeMapping composite = (BeanCompositeMapping)it.next();
                if (!composite.isValid()) {
                    it.remove();
                    continue;
                }
                MetaObject<?> compositeMetaObject = this.metaObject.getProperty(this.caseModel, composite.getProperty());
                if (compositeMetaObject == null) {
                    it.remove();
                    continue;
                }
                BeanMapping<?> compositeMapping = composite.getMapping();
                compositeMapping.metaObject(compositeMetaObject).caseInsensitive(this.caseInsensitive).caseCamel(this.caseCamel).prepare();
            }
        }
    }

    public BeanMapping<T> caseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    public BeanMapping<T> caseCamel(boolean caseCamel) {
        this.caseCamel = caseCamel;
        return this;
    }

    public BeanMapping<T> metaObject(MetaObject<T> metaObject) {
        this.metaObject = metaObject;
        return this;
    }

    public BeanMapping<T> javaType(JavaType<T> javaType) {
        this.metaObject = MetaObject.of(javaType);
        return this;
    }

    public BeanMapping<T> column(BeanPropertyMapping column) {
        if (this.columns == null) {
            this.columns = new ArrayList<BeanPropertyMapping>();
        }
        this.columns.add(column);
        return this;
    }

    public BeanMapping<T> columns(List<BeanPropertyMapping> columns) {
        this.columns = columns;
        return this;
    }

    public BeanMapping<T> composite(BeanCompositeMapping<?> composite) {
        if (this.composites == null) {
            this.composites = new ArrayList();
        }
        this.composites.add(composite);
        return this;
    }

    public BeanMapping<T> composites(List<BeanCompositeMapping<?>> composites) {
        this.composites = composites;
        return this;
    }

    public MetaObject<T> getMetaObject() {
        return this.metaObject;
    }

    public List<BeanPropertyMapping> getColumns() {
        return this.columns;
    }

    public List<BeanCompositeMapping<?>> getComposites() {
        return this.composites;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean isCaseCamel() {
        return this.caseCamel;
    }

    public int getCaseModel() {
        return this.caseModel;
    }
}

