/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.BeanCompositeMapping;
import io.polaris.core.jdbc.base.BeanMapping;
import io.polaris.core.jdbc.base.BeanPropertyMapping;
import io.polaris.core.lang.bean.MetaObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

class BeanMappingKit {
    BeanMappingKit() {
    }

    public static <T> void setProperty(ResultSet rs, BeanMapping<T> mapping, int caseModel, T bean) throws SQLException {
        MetaObject<T> metaObject = mapping.getMetaObject();
        if (mapping.getColumns() != null) {
            for (BeanPropertyMapping beanPropertyMapping : mapping.getColumns()) {
                Object val = rs.getObject(beanPropertyMapping.getColumn());
                if (val == null) continue;
                metaObject.setProperty(bean, caseModel, beanPropertyMapping.getProperty(), val);
            }
        }
        if (mapping.getComposites() != null) {
            for (BeanCompositeMapping beanCompositeMapping : mapping.getComposites()) {
                String subProperty = beanCompositeMapping.getProperty();
                BeanMapping subMapping = beanCompositeMapping.getMapping();
                MetaObject subMetaObject = subMapping.getMetaObject();
                if (subMetaObject == null) continue;
                Object subBean = metaObject.getProperty(bean, caseModel, subProperty);
                if (subBean == null) {
                    subBean = subMetaObject.newInstance();
                    metaObject.setProperty(bean, caseModel, subProperty, subBean);
                }
                BeanMappingKit.setProperty(rs, subMapping, caseModel, subBean);
            }
        }
    }

    public static <T> void removeMappingCols(Map<String, Integer> resultCols, BeanMapping<T> mapping) {
        if (mapping == null) {
            return;
        }
        if (mapping.getColumns() != null) {
            for (BeanPropertyMapping beanPropertyMapping : mapping.getColumns()) {
                resultCols.remove(beanPropertyMapping.getColumn());
            }
        }
        if (mapping.getComposites() != null) {
            for (BeanCompositeMapping beanCompositeMapping : mapping.getComposites()) {
                BeanMappingKit.removeMappingCols(resultCols, beanCompositeMapping.getMapping());
            }
        }
    }

    public static <T> void markMappingCols(Map<String, Boolean> resultCols, BeanMapping<T> mapping) {
        if (mapping == null) {
            return;
        }
        if (mapping.getColumns() != null) {
            for (BeanPropertyMapping beanPropertyMapping : mapping.getColumns()) {
                if (!resultCols.containsKey(beanPropertyMapping.getColumn())) continue;
                resultCols.put(beanPropertyMapping.getColumn(), true);
            }
        }
        if (mapping.getComposites() != null) {
            for (BeanCompositeMapping beanCompositeMapping : mapping.getComposites()) {
                BeanMappingKit.markMappingCols(resultCols, beanCompositeMapping.getMapping());
            }
        }
    }
}

