/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.BeanMapping;
import io.polaris.core.jdbc.base.ResultBeanExtractor;
import io.polaris.core.jdbc.base.ResultBeanListExtractor;
import io.polaris.core.jdbc.base.ResultBeanMappingExtractor;
import io.polaris.core.jdbc.base.ResultBeanMappingListExtractor;
import io.polaris.core.jdbc.base.ResultExtractor;
import io.polaris.core.jdbc.base.ResultMapExtractor;
import io.polaris.core.jdbc.base.ResultMapListExtractor;
import io.polaris.core.jdbc.base.ResultSingleExtractor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ResultExtractors {
    public static final ResultMapExtractor<Map<String, Object>> MAP_EXTRACTOR = new ResultMapExtractor();
    public static final ResultMapListExtractor<Map<String, Object>> MAP_LIST_EXTRACTOR = new ResultMapListExtractor();

    public static ResultExtractor<Map<String, Object>> ofMap() {
        return MAP_EXTRACTOR;
    }

    public static ResultExtractor<List<Map<String, Object>>> ofMapList() {
        return MAP_LIST_EXTRACTOR;
    }

    public static <T extends Map<String, Object>> ResultExtractor<T> ofMap(Class<T> type) {
        return new ResultMapExtractor<T>(type);
    }

    public static <T extends Map<String, Object>> ResultExtractor<List<T>> ofMapList(Class<T> type) {
        return new ResultMapListExtractor<T>(type);
    }

    public static <T> ResultExtractor<T> ofBean(Class<T> type) {
        return new ResultBeanExtractor<T>(type);
    }

    public static <T> ResultExtractor<T> ofBean(Type type) {
        return new ResultBeanExtractor(type);
    }

    public static <T> ResultExtractor<T> ofBean(Class<T> type, boolean caseInsensitive, boolean caseCamel) {
        return new ResultBeanExtractor<T>(type, caseInsensitive, caseCamel);
    }

    public static <T> ResultExtractor<T> ofBean(Type type, boolean caseInsensitive, boolean caseCamel) {
        return new ResultBeanExtractor(type, caseInsensitive, caseCamel);
    }

    public static <T> ResultExtractor<List<T>> ofBeanList(Class<T> type) {
        return new ResultBeanListExtractor<T>(type);
    }

    public static <T> ResultExtractor<List<T>> ofBeanList(Type type) {
        return new ResultBeanListExtractor(type);
    }

    public static <T> ResultExtractor<List<T>> ofBeanList(Class<T> type, boolean caseInsensitive, boolean caseCamel) {
        return new ResultBeanListExtractor<T>(type, caseInsensitive, caseCamel);
    }

    public static <T> ResultExtractor<List<T>> ofBeanList(Type type, boolean caseInsensitive, boolean caseCamel) {
        return new ResultBeanListExtractor(type, caseInsensitive, caseCamel);
    }

    public static <T> ResultExtractor<T> ofMapping(BeanMapping<T> mapping) {
        return new ResultBeanMappingExtractor<T>(mapping);
    }

    public static <T> ResultExtractor<List<T>> ofMappingList(BeanMapping<T> mapping) {
        return new ResultBeanMappingListExtractor<T>(mapping);
    }

    public static <T> ResultExtractor<T> ofSingle(Class<T> type) {
        return new ResultSingleExtractor<T>(type);
    }

    public static <T> ResultExtractor<T> ofSingle(Type type) {
        return new ResultSingleExtractor(type);
    }

    public static <T> ResultExtractor<Object> ofSingle() {
        return new ResultSingleExtractor<Object>(Object.class);
    }
}

