/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.ResultExtractor;
import io.polaris.core.jdbc.base.ResultRowMapper;
import io.polaris.core.jdbc.base.ResultRowMappers;
import io.polaris.core.reflect.Reflects;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public class ResultMapCollectionExtractor<C extends Collection<T>, T extends Map<String, Object>>
implements ResultExtractor<C> {
    private final Supplier<C> collectionBuilder;
    private final ResultRowMapper<T> mapper;

    public ResultMapCollectionExtractor(Supplier<C> collectionBuilder, Class<T> mapType) {
        this.collectionBuilder = collectionBuilder;
        this.mapper = mapType == null ? ResultRowMappers.ofMap() : ResultRowMappers.ofMap(mapType);
    }

    public ResultMapCollectionExtractor(Supplier<C> collectionBuilder) {
        this(collectionBuilder, null);
    }

    public ResultMapCollectionExtractor(Class<C> collectionType, Class<T> mapType) {
        this(() -> (Collection)Reflects.newInstanceIfPossible(collectionType), mapType);
    }

    @Override
    public C extract(ResultSet rs) throws SQLException {
        Collection list = (Collection)this.collectionBuilder.get();
        ResultSetMetaData meta = rs.getMetaData();
        int cnt = meta.getColumnCount();
        String[] keys = new String[cnt];
        for (int i = 1; i <= cnt; ++i) {
            keys[i - 1] = meta.getColumnLabel(i);
        }
        while (rs.next()) {
            Map map = (Map)this.mapper.map(rs, keys);
            list.add(map);
        }
        return (C)list;
    }
}

