/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.BaseResultRowMapper;
import io.polaris.core.jdbc.base.BeanMapping;
import io.polaris.core.jdbc.base.BeanMappingKit;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResultRowBeanMappingMapper<T>
extends BaseResultRowMapper<T> {
    private final BeanMapping<T> mapping;
    private String[] colsLast;
    private Map<String, Integer> unmappedCols;

    public ResultRowBeanMappingMapper(BeanMapping<T> mapping) {
        mapping.prepare();
        this.mapping = mapping;
    }

    @Override
    protected T doMap(ResultSet rs, String[] columns) throws SQLException {
        if (this.colsLast != columns) {
            HashMap<String, Integer> cols = new HashMap<String, Integer>();
            for (int i = 1; i <= columns.length; ++i) {
                cols.put(columns[i - 1], i);
            }
            BeanMappingKit.removeMappingCols(cols, this.mapping);
            this.unmappedCols = Collections.unmodifiableMap(cols);
            this.colsLast = columns;
        }
        int caseModel = this.mapping.getCaseModel();
        T bean = this.mapping.getMetaObject().newInstance();
        for (Map.Entry<String, Integer> entry : this.unmappedCols.entrySet()) {
            String key = entry.getKey();
            Object val = rs.getObject(entry.getValue());
            this.mapping.getMetaObject().setPathProperty(bean, caseModel, key, val);
        }
        BeanMappingKit.setProperty(rs, this.mapping, caseModel, bean);
        return bean;
    }
}

