/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.ResultRowMapper;
import io.polaris.core.jdbc.base.ResultRowMappers;
import io.polaris.core.jdbc.base.ResultSetVisitor;
import io.polaris.core.jdbc.base.ResultVisitor;

public class ResultSetVisitors {
    public static <T> ResultSetVisitor ofRows(ResultRowMapper<T> mapper, ResultVisitor<T> visitor) {
        return rs -> {
            String[] columns = ResultRowMappers.getColumns(rs);
            while (rs.next()) {
                Object t = mapper.map(rs, columns);
                visitor.visit(t);
            }
        };
    }

    public static <T> ResultSetVisitor ofRow(ResultRowMapper<T> mapper, ResultVisitor<T> visitor) {
        return rs -> {
            if (rs.next()) {
                String[] columns = ResultRowMappers.getColumns(rs);
                Object t = mapper.map(rs, columns);
                visitor.visit(t);
            }
        };
    }
}

