/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.ResultExtractor;
import io.polaris.core.jdbc.base.ResultRowMapper;
import io.polaris.core.jdbc.base.ResultRowMappers;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.function.Supplier;

public class ResultSingleCollectionExtractor<C extends Collection<Object>>
implements ResultExtractor<C> {
    private final Supplier<C> collectionBuilder;
    private final ResultRowMapper<Object> rowMapper;

    public ResultSingleCollectionExtractor(Supplier<C> collectionBuilder) {
        this(collectionBuilder, (Type)((Object)Object.class));
    }

    public ResultSingleCollectionExtractor(Supplier<C> collectionBuilder, Type type) {
        this.collectionBuilder = collectionBuilder;
        this.rowMapper = ResultRowMappers.ofSingle(type);
    }

    @Override
    public C extract(ResultSet rs) throws SQLException {
        Collection list = (Collection)this.collectionBuilder.get();
        while (rs.next()) {
            list.add(this.rowMapper.map(rs, null));
        }
        return (C)list;
    }
}

